/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.lianlu.service;

import cn.hutool.json.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.lianlu.config.LianLuConfig;
import org.dromara.sms4j.lianlu.req.LianLuRequest;
import org.dromara.sms4j.lianlu.utils.LianLuUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LianLuSmsImpl
extends AbstractSmsBlend<LianLuConfig> {
    private static final Logger log = LoggerFactory.getLogger(LianLuSmsImpl.class);
    private int retry = 0;
    private static final String NORMAL_MSG = "1";
    private static final String TEMPLATE_MSG = "3";

    public LianLuSmsImpl(LianLuConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public LianLuSmsImpl(LianLuConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "lianlu";
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateParam) {
        return this.massTexting(Collections.singletonList(phone), templateParam);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessage(phone, ((LianLuConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        return this.massTexting(Collections.singletonList(phone), templateId, messages);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateParam) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put("", templateParam);
        return this.massTexting(phones, ((LianLuConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        LianLuRequest req = this.getRequest();
        req.setType(TEMPLATE_MSG).setPhoneNumberSet(phones).setTemplateId(templateId).setTemplateParamSet(messages.values());
        return this.getSmsResponse(req);
    }

    private LianLuRequest getRequest() {
        return ((LianLuConfig)this.getConfig()).toLianLuRequest();
    }

    private String getRequestUrl(String type) {
        String url;
        switch (type) {
            case "1": {
                url = "/normal/send";
                break;
            }
            case "3": {
                url = "/template/send";
                break;
            }
            default: {
                throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u7684\u77ed\u4fe1\u7c7b\u578b:" + type);
            }
        }
        return ((LianLuConfig)this.getConfig()).getRequestUrl() + url;
    }

    public SmsResponse sendNormalMessage(String phone, String message) {
        return this.sendNormalMessage(Collections.singletonList(phone), message);
    }

    public SmsResponse sendNormalMessage(String phone, String message, String signName) {
        return this.sendNormalMessage(Collections.singletonList(phone), message, signName);
    }

    public SmsResponse sendNormalMessage(List<String> phones, String message) {
        return this.sendNormalMessage(phones, message, ((LianLuConfig)this.getConfig()).getSignature());
    }

    public SmsResponse sendNormalMessage(List<String> phones, String message, String signName) {
        LianLuRequest req = this.getRequest();
        req.setType(NORMAL_MSG).setPhoneNumberSet(phones).setSessionContext(message).setSignName(signName);
        return this.getSmsResponse(req);
    }

    private SmsResponse getSmsResponse(LianLuRequest req) {
        if (req.getPhoneNumberSet().size() > 10000) {
            throw new SmsBlendException("\u8054\u9e93\u77ed\u4fe1:\u624b\u673a\u53f7\u6570\u91cf\u6700\u591a\u4e3a10000\uff01");
        }
        req.setTimeStamp(System.currentTimeMillis());
        TreeMap<String, Object> requestBody = req.toMap();
        requestBody.put("Signature", LianLuUtils.generateSignature(requestBody, ((LianLuConfig)this.getConfig()).getAppKey(), req.getSignType()));
        String reqUrl = this.getRequestUrl(req.getType());
        log.debug("requestBody:{}", requestBody);
        try {
            HashMap<String, String> headers = new HashMap<String, String>(2);
            headers.put("Content-Type", "application/json; charset=utf-8");
            headers.put("Accept", "application/json");
            SmsResponse smsResponse = this.getResponse(this.http.postJson(reqUrl, headers, requestBody));
            if (!smsResponse.isSuccess() && this.retry != ((LianLuConfig)this.getConfig()).getMaxRetries()) {
                return this.requestRetry(req);
            }
            this.retry = 0;
            return smsResponse;
        }
        catch (SmsBlendException e) {
            return this.requestRetry(req);
        }
    }

    private SmsResponse requestRetry(LianLuRequest req) {
        this.http.safeSleep(((LianLuConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c{}\u6b21\u91cd\u65b0\u53d1\u9001, \u8bf7\u6c42\u53c2\u6570:{}", (Object)this.retry, (Object)req);
        return this.getSmsResponse(req);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        return SmsRespUtils.resp((Object)resJson, (boolean)"00".equals(resJson.getStr((Object)"status")), (String)this.getConfigId());
    }
}

