/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.jg.service;

import cn.hutool.json.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.jg.config.JgConfig;
import org.dromara.sms4j.jg.util.JgUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JgSmsImpl
extends AbstractSmsBlend<JgConfig> {
    private static final Logger log = LoggerFactory.getLogger(JgSmsImpl.class);
    private int retry = 0;

    public JgSmsImpl(JgConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public JgSmsImpl(JgConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "jiguang";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        if (SmsUtils.isNotEmpty((Object)((JgConfig)this.getConfig()).getTemplateName()) && SmsUtils.isNotEmpty((Object)message)) {
            map.put(((JgConfig)this.getConfig()).getTemplateName(), message);
        }
        return this.sendMessage(phone, ((JgConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (SmsUtils.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessage(phone, ((JgConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (SmsUtils.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        return this.getSmsResponse(phone, messages, templateId, null, null);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        if (SmsUtils.isNotEmpty((Object)((JgConfig)this.getConfig()).getTemplateName()) && SmsUtils.isNotEmpty((Object)message)) {
            map.put(((JgConfig)this.getConfig()).getTemplateName(), message);
        }
        return this.massTexting(phones, ((JgConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (SmsUtils.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        return this.getSmsResponse(SmsUtils.addCodePrefixIfNot(phones), messages, templateId, null, null);
    }

    public SmsResponse sendVoiceCode(String phone, String code) {
        return this.getSmsResponse(phone, null, null, code, null);
    }

    public SmsResponse verifyCode(String code, String msgId) {
        return this.getSmsResponse(null, null, null, code, msgId);
    }

    private SmsResponse getSmsResponse(String phone, LinkedHashMap<String, String> messages, String templateId, String code, String msgId) {
        SmsResponse smsResponse;
        JgConfig config = (JgConfig)this.getConfig();
        String url = JgUtils.buildUrl(config.getRequestUrl(), config.getAction(), msgId);
        Map<String, String> headers = JgUtils.buildHeaders(config.getAccessKeyId(), config.getAccessKeySecret());
        Map<String, Object> body = JgUtils.buildBody(phone, messages, templateId, config, code);
        String jsonKey = JgUtils.buildJsonKey(config.getAction());
        try {
            smsResponse = this.getResponse(this.http.postJson(url, headers, body), jsonKey);
        }
        catch (SmsBlendException e) {
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry >= ((JgConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phone, messages, templateId, code, msgId);
    }

    private SmsResponse requestRetry(String phone, LinkedHashMap<String, String> messages, String templateId, String code, String msgId) {
        this.http.safeSleep(((JgConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.getSmsResponse(phone, messages, templateId, code, msgId);
    }

    private SmsResponse getResponse(JSONObject resJson, String jsonKey) {
        return SmsRespUtils.resp((Object)resJson, (resJson.getObj((Object)jsonKey) != null ? 1 : 0) != 0, (String)this.getConfigId());
    }
}

