/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.starter.aop;

import org.dromara.sms4j.api.dao.SmsDao;
import org.dromara.sms4j.api.dao.SmsDaoDefaultImpl;
import org.dromara.sms4j.api.proxy.RestrictedProcess;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.provider.config.SmsConfig;
import org.dromara.sms4j.provider.factory.BeanFactory;
import org.dromara.sms4j.starter.utils.SmsSpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringRestrictedProcess
implements RestrictedProcess {
    private static final Logger log = LoggerFactory.getLogger(SpringRestrictedProcess.class);
    private static final Long minTimer = 60000L;
    private static final Long accTimer = 86400000L;
    private static final String REDIS_KEY = "sms:restricted:";

    /*
     * Enabled aggressive block sorting
     */
    public SmsBlendException process(String phone) {
        SmsConfig config = BeanFactory.getSmsConfig();
        SmsDao smsDao = SmsSpringUtils.getBean(SmsDao.class);
        if (SmsUtils.isEmpty((Object)smsDao)) {
            smsDao = SmsDaoDefaultImpl.getInstance();
        }
        Integer accountMax = config.getAccountMax();
        Integer minuteMax = config.getMinuteMax();
        if (SmsUtils.isNotEmpty((Object)accountMax)) {
            Integer i = (Integer)smsDao.get(REDIS_KEY + phone + "max");
            if (SmsUtils.isEmpty((Object)i)) {
                smsDao.set(REDIS_KEY + phone + "max", (Object)1, accTimer / 1000L);
            } else {
                if (i >= accountMax) {
                    log.info("The phone:" + phone + ",number of short messages reached the maximum today");
                    return new SmsBlendException("The phone:" + phone + ",number of short messages reached the maximum today");
                }
                smsDao.set(REDIS_KEY + phone + "max", (Object)(i + 1), accTimer / 1000L);
            }
        }
        if (!SmsUtils.isNotEmpty((Object)minuteMax)) return null;
        Integer o = (Integer)smsDao.get(REDIS_KEY + phone);
        if (!SmsUtils.isNotEmpty((Object)o)) {
            smsDao.set(REDIS_KEY + phone, (Object)1, minTimer / 1000L);
            return null;
        }
        if (o < minuteMax) {
            smsDao.set(REDIS_KEY + phone, (Object)(o + 1), minTimer / 1000L);
            return null;
        }
        log.info("The phone:" + phone + ",number of short messages reached the maximum today");
        return new SmsBlendException("The phone:", phone + " Text messages are sent too often\uff01");
    }
}

