/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.starter.utils;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SmsSpringUtils
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SmsSpringUtils.class);
    private static ApplicationContext applicationContext;
    private final DefaultListableBeanFactory beanFactory;

    public SmsSpringUtils(DefaultListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (SmsSpringUtils.applicationContext == null) {
            SmsSpringUtils.applicationContext = applicationContext;
        }
    }

    public static Object getBean(String name) {
        try {
            return SmsSpringUtils.getApplicationContext().getBean(name);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return (T)SmsSpringUtils.getApplicationContext().getBean(clazz);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        try {
            return (T)SmsSpringUtils.getApplicationContext().getBean(name, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void createBean(Class<?> clazz) {
        String name = clazz.getName();
        this.beanFactory.createBean(clazz);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        this.beanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    public void createBean(Object o) {
        applicationContext.getAutowireCapableBeanFactory().autowireBean(o);
    }

    public void replaceBean(String beanName, Class<?> clazz) {
        String name = clazz.getName();
        this.beanFactory.removeBeanDefinition(beanName);
        this.beanFactory.createBean(clazz);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        this.beanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    public void deleteBean(String beanName) {
        this.beanFactory.removeBeanDefinition(beanName);
    }

    public static boolean interfaceExist(Class<?> interfaceType) {
        return !applicationContext.getBeansOfType(interfaceType).isEmpty();
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> interfaceType) {
        return applicationContext.getBeansOfType(interfaceType);
    }
}

