/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.apache.dubbo.proxy;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericException;
import org.apache.dubbo.rpc.service.GenericService;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.common.utils.ParamCheckUtils;
import org.dromara.soul.plugin.apache.dubbo.cache.ApplicationConfigCache;
import org.dromara.soul.plugin.api.param.BodyParamResolveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ApacheDubboProxyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApacheDubboProxyService.class);
    private final BodyParamResolveService bodyParamResolveService;

    public ApacheDubboProxyService(BodyParamResolveService bodyParamResolveService) {
        this.bodyParamResolveService = bodyParamResolveService;
    }

    public Mono<Object> genericInvoker(String body, MetaData metaData, ServerWebExchange exchange) throws SoulException {
        Object reference;
        String dubboTagRouteFromHttpHeaders = exchange.getRequest().getHeaders().getFirst("Dubbo_Tag_Route");
        if (StringUtils.isNotBlank((CharSequence)dubboTagRouteFromHttpHeaders)) {
            RpcContext.getContext().setAttachment("dubbo.tag", dubboTagRouteFromHttpHeaders);
        }
        if (Objects.isNull(reference = ApplicationConfigCache.getInstance().get(metaData.getPath())) || StringUtils.isEmpty((CharSequence)reference.getInterface())) {
            ApplicationConfigCache.getInstance().invalidate(metaData.getPath());
            reference = ApplicationConfigCache.getInstance().initRef(metaData);
        }
        GenericService genericService = (GenericService)reference.get();
        Object pair = ParamCheckUtils.dubboBodyIsEmpty((String)body) ? new ImmutablePair((Object)new String[0], (Object)new Object[0]) : this.bodyParamResolveService.buildParameter(body, metaData.getParameterTypes());
        CompletableFuture future = genericService.$invokeAsync(metaData.getMethodName(), (String[])pair.getLeft(), (Object[])pair.getRight());
        return Mono.fromFuture((CompletableFuture)future.thenApply(ret -> {
            if (Objects.isNull(ret)) {
                ret = "dubbo has not return value!";
            }
            exchange.getAttributes().put("dubbo_rpc_result", ret);
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            return ret;
        })).onErrorMap(exception -> exception instanceof GenericException ? new SoulException(((GenericException)exception).getExceptionMessage()) : new SoulException(exception));
    }
}

