/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.apache.dubbo.subscriber;

import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.plugin.apache.dubbo.cache.ApplicationConfigCache;
import org.dromara.soul.sync.data.api.MetaDataSubscriber;

public class ApacheDubboMetaDataSubscriber
implements MetaDataSubscriber {
    private static final ConcurrentMap<String, MetaData> META_DATA = Maps.newConcurrentMap();

    public void onSubscribe(MetaData metaData) {
        if (RpcTypeEnum.DUBBO.getName().equals(metaData.getRpcType())) {
            MetaData exist = (MetaData)META_DATA.get(metaData.getPath());
            if (Objects.isNull(exist) || Objects.isNull(ApplicationConfigCache.getInstance().get(metaData.getPath()))) {
                ApplicationConfigCache.getInstance().initRef(metaData);
            } else if (!(Objects.equals(metaData.getServiceName(), exist.getServiceName()) && Objects.equals(metaData.getRpcExt(), exist.getRpcExt()) && Objects.equals(metaData.getParameterTypes(), exist.getParameterTypes()) && Objects.equals(metaData.getMethodName(), exist.getMethodName()))) {
                ApplicationConfigCache.getInstance().build(metaData);
            }
            META_DATA.put(metaData.getPath(), metaData);
        }
    }

    public void unSubscribe(MetaData metaData) {
        if (RpcTypeEnum.DUBBO.getName().equals(metaData.getRpcType())) {
            ApplicationConfigCache.getInstance().invalidate(metaData.getPath());
            META_DATA.remove(metaData.getPath());
        }
    }
}

