/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc;

import io.grpc.CallOptions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.dromara.soul.plugin.api.result.SoulResultEnum;
import org.dromara.soul.plugin.api.result.SoulResultWrap;
import org.dromara.soul.plugin.api.utils.WebFluxResultUtils;
import org.dromara.soul.plugin.base.AbstractSoulPlugin;
import org.dromara.soul.plugin.grpc.cache.GrpcClientCache;
import org.dromara.soul.plugin.grpc.client.SoulGrpcClient;
import org.dromara.soul.plugin.grpc.proto.SoulGrpcResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GrpcPlugin
extends AbstractSoulPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        String param = (String)exchange.getAttribute("param_transform");
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        MetaData metaData = (MetaData)exchange.getAttribute("metaData");
        if (!this.checkMetaData(metaData)) {
            assert (metaData != null);
            log.error(" path is :{}, meta data have error.... {}", (Object)soulContext.getPath(), (Object)metaData.toString());
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = SoulResultWrap.error((int)SoulResultEnum.META_DATA_ERROR.getCode(), (String)SoulResultEnum.META_DATA_ERROR.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{metaData.getParameterTypes()}) && StringUtils.isBlank((CharSequence)param)) {
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = SoulResultWrap.error((int)SoulResultEnum.GRPC_HAVE_BODY_PARAM.getCode(), (String)SoulResultEnum.GRPC_HAVE_BODY_PARAM.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        SoulGrpcClient client = GrpcClientCache.getGrpcClient(selector.getName());
        if (Objects.isNull(client)) {
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = SoulResultWrap.error((int)SoulResultEnum.GRPC_CLIENT_NULL.getCode(), (String)SoulResultEnum.GRPC_CLIENT_NULL.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        GrpcExtInfo extInfo = (GrpcExtInfo)GsonUtils.getGson().fromJson(metaData.getRpcExt(), GrpcExtInfo.class);
        CallOptions callOptions = CallOptions.DEFAULT.withDeadlineAfter((long)extInfo.timeout.intValue(), TimeUnit.MILLISECONDS);
        CompletableFuture<SoulGrpcResponse> result = client.call(metaData, callOptions, param);
        return Mono.fromFuture((CompletableFuture)result.thenApply(ret -> {
            exchange.getAttributes().put("grpc_rpc_result", ret.getResult());
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            return ret;
        })).onErrorMap(SoulException::new).then(chain.execute(exchange));
    }

    public String named() {
        return PluginEnum.GRPC.getName();
    }

    public Boolean skip(ServerWebExchange exchange) {
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        return !Objects.equals(soulContext.getRpcType(), RpcTypeEnum.GRPC.getName());
    }

    public int getOrder() {
        return PluginEnum.GRPC.getCode();
    }

    private boolean checkMetaData(MetaData metaData) {
        return null != metaData && !StringUtils.isBlank((CharSequence)metaData.getMethodName()) && !StringUtils.isBlank((CharSequence)metaData.getServiceName());
    }

    static class GrpcExtInfo {
        private Integer timeout = 5000;

        @Generated
        public GrpcExtInfo() {
        }

        @Generated
        public Integer getTimeout() {
            return this.timeout;
        }

        @Generated
        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GrpcExtInfo)) {
                return false;
            }
            GrpcExtInfo other = (GrpcExtInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$timeout = this.getTimeout();
            Integer other$timeout = other.getTimeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GrpcExtInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GrpcPlugin.GrpcExtInfo(timeout=" + this.getTimeout() + ")";
        }
    }
}

