/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.cache;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.dromara.soul.plugin.grpc.client.GrpcClientBuilder;
import org.dromara.soul.plugin.grpc.client.SoulGrpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClientCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcClientCache.class);
    private static final Map<String, SoulGrpcClient> CLIENT_CACHE = Maps.newConcurrentMap();

    public static void initGrpcClient(String contextPath) {
        CLIENT_CACHE.computeIfAbsent(contextPath, s -> GrpcClientBuilder.buildClient(contextPath));
    }

    public static SoulGrpcClient getGrpcClient(String contextPath) {
        return CLIENT_CACHE.get(contextPath);
    }

    public static void removeClient(String contextPath) {
        SoulGrpcClient grpcClient = CLIENT_CACHE.remove(contextPath);
        if (Objects.nonNull(grpcClient)) {
            grpcClient.close();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Map.Entry<String, SoulGrpcClient> entry : CLIENT_CACHE.entrySet()) {
                SoulGrpcClient grpcClient = entry.getValue();
                grpcClient.close();
            }
            CLIENT_CACHE.clear();
        }));
    }
}

