/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.client;

import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import org.dromara.soul.plugin.grpc.client.SoulGrpcClient;
import org.dromara.soul.plugin.grpc.loadbalance.LoadBalancerStrategy;
import org.dromara.soul.plugin.grpc.loadbalance.RandomLoadBalancerProvider;
import org.dromara.soul.plugin.grpc.loadbalance.RoundRobinLoadBalancerProvider;
import org.dromara.soul.plugin.grpc.resolver.SoulNameResolverProvider;

public class GrpcClientBuilder {
    public static SoulGrpcClient buildClient(String contextPath) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forTarget((String)contextPath).defaultLoadBalancingPolicy(LoadBalancerStrategy.Random.getStrategy()).usePlaintext().maxInboundMessageSize(0x6400000).disableRetry();
        ManagedChannel channel = builder.build();
        channel.getState(true);
        return new SoulGrpcClient(channel);
    }

    static {
        LoadBalancerRegistry.getDefaultRegistry().register((LoadBalancerProvider)new RandomLoadBalancerProvider());
        LoadBalancerRegistry.getDefaultRegistry().register((LoadBalancerProvider)new RoundRobinLoadBalancerProvider());
        NameResolverRegistry.getDefaultRegistry().register((NameResolverProvider)new SoulNameResolverProvider());
    }
}

