/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.client;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.util.JsonFormat;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.plugin.grpc.proto.CompleteObserver;
import org.dromara.soul.plugin.grpc.proto.CompositeStreamObserver;
import org.dromara.soul.plugin.grpc.proto.DynamicMessageMarshaller;
import org.dromara.soul.plugin.grpc.proto.MessageWriter;
import org.dromara.soul.plugin.grpc.proto.SoulGrpcCallRequest;
import org.dromara.soul.plugin.grpc.proto.SoulGrpcResponse;
import org.dromara.soul.plugin.grpc.reflection.SoulGrpcReflectionClient;
import org.dromara.soul.plugin.grpc.resolver.ServiceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoulGrpcClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoulGrpcClient.class);
    private final ManagedChannel channel;
    private final SoulGrpcReflectionClient reflectionClient;

    public SoulGrpcClient(ManagedChannel channel) {
        this.channel = channel;
        this.reflectionClient = SoulGrpcReflectionClient.create((Channel)channel);
    }

    public CompletableFuture<SoulGrpcResponse> call(MetaData metaData, CallOptions callOptions, String requestJsons) {
        DescriptorProtos.FileDescriptorSet fileDescriptorSet = this.reflectionClient.resolveService(metaData.getServiceName());
        if (fileDescriptorSet == null) {
            return null;
        }
        ServiceResolver serviceResolver = ServiceResolver.fromFileDescriptorSet(fileDescriptorSet);
        Descriptors.MethodDescriptor methodDescriptor = serviceResolver.resolveServiceMethod(metaData);
        JsonFormat.TypeRegistry registry = JsonFormat.TypeRegistry.newBuilder().add(serviceResolver.listMessageTypes()).build();
        DynamicMessage requestMessages = this.reflectionClient.parseToMessages(registry, methodDescriptor.getInputType(), requestJsons);
        SoulGrpcResponse soulGrpcResponse = new SoulGrpcResponse();
        MessageWriter<DynamicMessage> streamObserver = MessageWriter.newInstance(registry, soulGrpcResponse);
        SoulGrpcCallRequest callParams = SoulGrpcCallRequest.builder().methodDescriptor(methodDescriptor).channel((Channel)this.channel).callOptions(callOptions).requests(requestMessages).responseObserver(streamObserver).build();
        try {
            this.invoke(callParams).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Caught exception while waiting for rpc :{ " + e.getMessage() + "}");
        }
        return CompletableFuture.completedFuture(soulGrpcResponse);
    }

    public ListenableFuture<Void> invoke(SoulGrpcCallRequest callParams) {
        MethodDescriptor.MethodType methodType = this.reflectionClient.fetchMethodType(callParams.getMethodDescriptor());
        DynamicMessage request = callParams.getRequests();
        StreamObserver<DynamicMessage> responseObserver = callParams.getResponseObserver();
        CompleteObserver doneObserver = new CompleteObserver();
        CompositeStreamObserver<DynamicMessage> compositeObserver = CompositeStreamObserver.of(responseObserver, doneObserver);
        switch (methodType) {
            case UNARY: {
                ClientCalls.asyncUnaryCall(this.createCall(callParams), (Object)request, compositeObserver);
                return doneObserver.getCompletionFuture();
            }
            case SERVER_STREAMING: {
                ClientCalls.asyncServerStreamingCall(this.createCall(callParams), (Object)request, compositeObserver);
                return doneObserver.getCompletionFuture();
            }
            case CLIENT_STREAMING: {
                StreamObserver requestObserver = ClientCalls.asyncClientStreamingCall(this.createCall(callParams), compositeObserver);
                requestObserver.onCompleted();
                return doneObserver.getCompletionFuture();
            }
            case BIDI_STREAMING: {
                StreamObserver requestObserver = ClientCalls.asyncBidiStreamingCall(this.createCall(callParams), compositeObserver);
                requestObserver.onCompleted();
                return doneObserver.getCompletionFuture();
            }
        }
        log.info("Unknown methodType:{}", (Object)methodType);
        return null;
    }

    @Override
    public void close() {
        this.channel.shutdown();
        this.reflectionClient.getFileDescriptorCache().clear();
    }

    private ClientCall<DynamicMessage, DynamicMessage> createCall(SoulGrpcCallRequest callParams) {
        return callParams.getChannel().newCall(this.createGrpcMethodDescriptor(callParams.getMethodDescriptor()), callParams.getCallOptions());
    }

    private MethodDescriptor<DynamicMessage, DynamicMessage> createGrpcMethodDescriptor(Descriptors.MethodDescriptor descriptor) {
        return MethodDescriptor.newBuilder().setType(this.reflectionClient.fetchMethodType(descriptor)).setFullMethodName(this.reflectionClient.fetchFullMethodName(descriptor)).setRequestMarshaller((MethodDescriptor.Marshaller)new DynamicMessageMarshaller(descriptor.getInputType())).setResponseMarshaller((MethodDescriptor.Marshaller)new DynamicMessageMarshaller(descriptor.getOutputType())).build();
    }
}

