/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.loadbalance;

import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import lombok.Generated;

public class SubChannels {
    private static final Attributes.Key<Ref<ConnectivityStateInfo>> STATE_INFO_KEY = Attributes.Key.create((String)"state-info");
    private static final Attributes.Key<Ref<Integer>> WEIGHT_KEY = Attributes.Key.create((String)"weight");
    private static final Attributes.Key<Ref<String>> STATSU_KEY = Attributes.Key.create((String)"status");

    public static LoadBalancer.Subchannel createSubChannel(LoadBalancer.Helper helper, EquivalentAddressGroup addressGroup, Attributes attributes) {
        Attributes newAttributes = attributes.toBuilder().set(STATE_INFO_KEY, new Ref<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError((ConnectivityState)ConnectivityState.IDLE))).build();
        return helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(addressGroup).setAttributes(newAttributes).build());
    }

    public static Attributes createAttributes(int weight, String status) {
        return Attributes.newBuilder().set(WEIGHT_KEY, new Ref<Integer>(weight)).set(STATSU_KEY, new Ref<String>(status)).build();
    }

    public static int getWeight(LoadBalancer.Subchannel subchannel) {
        return SubChannels.getAttributeValue(subchannel, WEIGHT_KEY, 0);
    }

    public static String getStatus(LoadBalancer.Subchannel subchannel) {
        return SubChannels.getAttributeValue(subchannel, STATSU_KEY, "true");
    }

    public static ConnectivityStateInfo getStateInfo(LoadBalancer.Subchannel subchannel) {
        return SubChannels.getAttributeValue(subchannel, STATE_INFO_KEY, null);
    }

    public static void setStateInfo(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo value) {
        SubChannels.setAttributeValue(subchannel, STATE_INFO_KEY, value);
    }

    private static <T> T getAttributeValue(LoadBalancer.Subchannel subchannel, Attributes.Key<Ref<T>> key, T defaultValue) {
        Ref ref = (Ref)subchannel.getAttributes().get(key);
        return (T)(ref == null ? defaultValue : ref.value);
    }

    private static <T> void setAttributeValue(LoadBalancer.Subchannel subchannel, Attributes.Key<Ref<T>> key, T newValue) {
        Ref targetRef = (Ref)subchannel.getAttributes().get(key);
        if (targetRef != null) {
            targetRef.value = newValue;
        }
    }

    private static <T> void setAttributeValue(LoadBalancer.Subchannel subchannel, Attributes.Key<Ref<T>> key, Attributes newAttributes) {
        Ref newValueRef = (Ref)newAttributes.get(key);
        if (newValueRef != null) {
            SubChannels.setAttributeValue(subchannel, key, newValueRef.value);
        }
    }

    public static void updateAttributes(LoadBalancer.Subchannel subchannel, Attributes attributes) {
        SubChannels.setAttributeValue(subchannel, WEIGHT_KEY, attributes);
        SubChannels.setAttributeValue(subchannel, STATSU_KEY, attributes);
    }

    static final class Ref<T> {
        private T value;

        Ref(T value) {
            this.value = value;
        }

        @Generated
        public T getValue() {
            return this.value;
        }

        @Generated
        public void setValue(T value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ref)) {
                return false;
            }
            Ref other = (Ref)o;
            T this$value = this.getValue();
            T other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SubChannels.Ref(value=" + this.getValue() + ")";
        }
    }
}

