/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.loadbalance.picker;

import io.grpc.LoadBalancer;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.plugin.grpc.loadbalance.SubChannelCopy;
import org.dromara.soul.plugin.grpc.loadbalance.picker.AbstractReadyPicker;

public class RoundRobinPicker
extends AbstractReadyPicker {
    private static final AtomicIntegerFieldUpdater<RoundRobinPicker> INDEX_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RoundRobinPicker.class, "index");
    private volatile Integer index = 0;

    public RoundRobinPicker(List<LoadBalancer.Subchannel> list) {
        super(list);
    }

    @Override
    protected SubChannelCopy pick(List<SubChannelCopy> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        int size = list.size();
        if (size == 1) {
            return list.get(0);
        }
        int i = INDEX_UPDATER.incrementAndGet(this);
        if (i >= size) {
            int oldi = i;
            INDEX_UPDATER.compareAndSet(this, oldi, i %= size);
        }
        return list.get(i);
    }
}

