/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.reflection;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.reflection.v1alpha.ServerReflectionResponse;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dromara.soul.common.exception.SoulException;

public class LookupServiceHandler
implements StreamObserver<ServerReflectionResponse> {
    private final String serviceName;
    private final Set<String> requestedDescriptors;
    private final SettableFuture<DescriptorProtos.FileDescriptorSet> resultFuture;
    private final Map<String, DescriptorProtos.FileDescriptorProto> resolvedDescriptors;
    private StreamObserver<ServerReflectionRequest> requestStream;
    private int outstandingRequests;

    public LookupServiceHandler(String serviceName) {
        this.serviceName = serviceName;
        this.resultFuture = SettableFuture.create();
        this.resolvedDescriptors = new HashMap<String, DescriptorProtos.FileDescriptorProto>();
        this.requestedDescriptors = new HashSet<String>();
        this.outstandingRequests = 0;
    }

    public ListenableFuture<DescriptorProtos.FileDescriptorSet> start(StreamObserver<ServerReflectionRequest> requestStream) {
        this.requestStream = requestStream;
        requestStream.onNext((Object)LookupServiceHandler.requestForSymbol(this.serviceName));
        ++this.outstandingRequests;
        return this.resultFuture;
    }

    public void onNext(ServerReflectionResponse response) {
        ServerReflectionResponse.MessageResponseCase responseCase = response.getMessageResponseCase();
        if (responseCase == ServerReflectionResponse.MessageResponseCase.FILE_DESCRIPTOR_RESPONSE) {
            ImmutableSet<DescriptorProtos.FileDescriptorProto> descriptors = this.parseDescriptors(response.getFileDescriptorResponse().getFileDescriptorProtoList());
            descriptors.forEach(d -> this.resolvedDescriptors.put(d.getName(), (DescriptorProtos.FileDescriptorProto)d));
            descriptors.forEach(this::processDependencies);
        }
    }

    public void onError(Throwable t) {
        this.resultFuture.setException((Throwable)new RuntimeException("Reflection lookup rpc failed for: " + this.serviceName, t));
    }

    public void onCompleted() {
        if (!this.resultFuture.isDone()) {
            this.resultFuture.setException((Throwable)new RuntimeException("Unexpected end of rpc"));
        }
    }

    private ImmutableSet<DescriptorProtos.FileDescriptorProto> parseDescriptors(List<ByteString> descriptorBytes) {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (ByteString fileDescriptorBytes : descriptorBytes) {
            try {
                resultBuilder.add((Object)DescriptorProtos.FileDescriptorProto.parseFrom((ByteString)fileDescriptorBytes));
            }
            catch (InvalidProtocolBufferException e) {
                throw new SoulException((Throwable)e);
            }
        }
        return resultBuilder.build();
    }

    private void processDependencies(DescriptorProtos.FileDescriptorProto fileDescriptor) {
        fileDescriptor.getDependencyList().forEach(dep -> {
            if (!this.resolvedDescriptors.containsKey(dep) && !this.requestedDescriptors.contains(dep)) {
                this.requestedDescriptors.add((String)dep);
                ++this.outstandingRequests;
                this.requestStream.onNext((Object)LookupServiceHandler.requestForDescriptor(dep));
            }
        });
        --this.outstandingRequests;
        if (this.outstandingRequests == 0) {
            this.resultFuture.set((Object)DescriptorProtos.FileDescriptorSet.newBuilder().addAllFile(this.resolvedDescriptors.values()).build());
            this.requestStream.onCompleted();
        }
    }

    private static ServerReflectionRequest requestForDescriptor(String name) {
        return ServerReflectionRequest.newBuilder().setFileByFilename(name).build();
    }

    private static ServerReflectionRequest requestForSymbol(String symbol) {
        return ServerReflectionRequest.newBuilder().setFileContainingSymbol(symbol).build();
    }
}

