/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.springboot.starter.plugin.httpclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.dromara.soul.plugin.api.SoulPlugin;
import org.dromara.soul.plugin.httpclient.NettyHttpClientPlugin;
import org.dromara.soul.plugin.httpclient.WebClientPlugin;
import org.dromara.soul.plugin.httpclient.config.HttpClientProperties;
import org.dromara.soul.plugin.httpclient.response.NettyClientResponsePlugin;
import org.dromara.soul.plugin.httpclient.response.WebClientResponsePlugin;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.ProxyProvider;

@Configuration
public class HttpClientPluginConfiguration {
    @Bean
    @ConfigurationProperties(prefix="soul.httpclient")
    public HttpClientProperties httpClientProperties() {
        return new HttpClientProperties();
    }

    @Bean
    public HttpClient httpClient(HttpClientProperties properties) {
        HttpClientProperties.Pool pool = properties.getPool();
        ConnectionProvider connectionProvider = pool.getType() == HttpClientProperties.Pool.PoolType.DISABLED ? ConnectionProvider.newConnection() : (pool.getType() == HttpClientProperties.Pool.PoolType.FIXED ? ConnectionProvider.fixed((String)pool.getName(), (int)pool.getMaxConnections(), (long)pool.getAcquireTimeout()) : ConnectionProvider.elastic((String)pool.getName()));
        HttpClient httpClient = HttpClient.create((ConnectionProvider)connectionProvider).tcpConfiguration(tcpClient -> {
            HttpClientProperties.Proxy proxy;
            if (properties.getConnectTimeout() != null) {
                tcpClient = tcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)properties.getConnectTimeout());
            }
            if (StringUtils.hasText((String)(proxy = properties.getProxy()).getHost())) {
                tcpClient = tcpClient.proxy(proxySpec -> {
                    ProxyProvider.Builder builder = proxySpec.type(ProxyProvider.Proxy.HTTP).host(proxy.getHost());
                    PropertyMapper map = PropertyMapper.get();
                    map.from(() -> ((HttpClientProperties.Proxy)proxy).getPort()).whenNonNull().to(arg_0 -> ((ProxyProvider.Builder)builder).port(arg_0));
                    map.from(() -> ((HttpClientProperties.Proxy)proxy).getUsername()).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).username(arg_0));
                    map.from(() -> ((HttpClientProperties.Proxy)proxy).getPassword()).whenHasText().to(password -> builder.password(s -> password));
                    map.from(() -> ((HttpClientProperties.Proxy)proxy).getNonProxyHostsPattern()).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).nonProxyHosts(arg_0));
                });
            }
            tcpClient = tcpClient.option(ChannelOption.SO_TIMEOUT, (Object)5000);
            tcpClient = tcpClient.doOnConnected(c -> {
                ChannelPipeline pipeline = c.channel().pipeline();
                Map nameChannelHandlerMap = pipeline.toMap();
                if (!nameChannelHandlerMap.containsKey("write_timeout")) {
                    pipeline.addFirst("write_timeout", (ChannelHandler)new WriteTimeoutHandler((long)properties.getWriteTimeout().intValue(), TimeUnit.MILLISECONDS));
                }
                if (!nameChannelHandlerMap.containsKey("read_timeout")) {
                    pipeline.addFirst("read_timeout", (ChannelHandler)new ReadTimeoutHandler((long)properties.getReadTimeout().intValue(), TimeUnit.MILLISECONDS));
                }
            });
            return tcpClient;
        });
        HttpClientProperties.Ssl ssl = properties.getSsl();
        if (ssl.getTrustedX509CertificatesForTrustManager().length > 0 || ssl.isUseInsecureTrustManager()) {
            httpClient = httpClient.secure(sslContextSpec -> {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
                X509Certificate[] trustedX509Certificates = ssl.getTrustedX509CertificatesForTrustManager();
                if (trustedX509Certificates.length > 0) {
                    sslContextBuilder.trustManager(trustedX509Certificates);
                } else if (ssl.isUseInsecureTrustManager()) {
                    sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                }
                sslContextSpec.sslContext(sslContextBuilder).defaultConfiguration(ssl.getDefaultConfigurationType()).handshakeTimeout(ssl.getHandshakeTimeout()).closeNotifyFlushTimeout(ssl.getCloseNotifyFlushTimeout()).closeNotifyReadTimeout(ssl.getCloseNotifyReadTimeout());
            });
        }
        if (properties.isWiretap()) {
            httpClient = httpClient.wiretap(true);
        }
        return httpClient;
    }

    @Configuration
    @ConditionalOnProperty(name={"soul.httpclient.strategy"}, havingValue="netty")
    static class NettyHttpClientConfiguration {
        NettyHttpClientConfiguration() {
        }

        @Bean
        public SoulPlugin nettyHttpClientPlugin(ObjectProvider<HttpClient> httpClient) {
            return new NettyHttpClientPlugin((HttpClient)httpClient.getIfAvailable());
        }

        @Bean
        public SoulPlugin nettyClientResponsePlugin() {
            return new NettyClientResponsePlugin();
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"soul.httpclient.strategy"}, havingValue="webClient", matchIfMissing=true)
    static class WebClientConfiguration {
        WebClientConfiguration() {
        }

        @Bean
        public SoulPlugin webClientPlugin(ObjectProvider<HttpClient> httpClient) {
            WebClient webClient = WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector((HttpClient)Objects.requireNonNull(httpClient.getIfAvailable()))).build();
            return new WebClientPlugin(webClient);
        }

        @Bean
        public SoulPlugin webClientResponsePlugin() {
            return new WebClientResponsePlugin();
        }
    }
}

