/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.sync.data.nacos.handler;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.sync.data.api.AuthDataSubscriber;
import org.dromara.soul.sync.data.api.MetaDataSubscriber;
import org.dromara.soul.sync.data.api.PluginDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosCacheHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NacosCacheHandler.class);
    protected static final String GROUP = "DEFAULT_GROUP";
    protected static final String PLUGIN_DATA_ID = "soul.plugin.json";
    protected static final String SELECTOR_DATA_ID = "soul.selector.json";
    protected static final String RULE_DATA_ID = "soul.rule.json";
    protected static final String AUTH_DATA_ID = "soul.auth.json";
    protected static final String META_DATA_ID = "soul.meta.json";
    protected static final Map<String, List<Listener>> LISTENERS = Maps.newConcurrentMap();
    private final ConfigService configService;
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;

    public NacosCacheHandler(ConfigService configService, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        this.configService = configService;
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
    }

    protected void updatePluginMap(String configInfo) {
        try {
            ArrayList pluginDataList = new ArrayList(GsonUtils.getInstance().toObjectMap(configInfo, PluginData.class).values());
            pluginDataList.forEach(pluginData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(subscriber -> {
                subscriber.unSubscribe(pluginData);
                subscriber.onSubscribe(pluginData);
            }));
        }
        catch (JsonParseException e) {
            log.error("sync plugin data have error:", (Throwable)e);
        }
    }

    protected void updateSelectorMap(String configInfo) {
        try {
            List<SelectorData> selectorDataList = GsonUtils.getInstance().toObjectMapList(configInfo, SelectorData.class).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            selectorDataList.forEach(selectorData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(subscriber -> {
                subscriber.unSelectorSubscribe(selectorData);
                subscriber.onSelectorSubscribe(selectorData);
            }));
        }
        catch (JsonParseException e) {
            log.error("sync selector data have error:", (Throwable)e);
        }
    }

    protected void updateRuleMap(String configInfo) {
        try {
            List<RuleData> ruleDataList = GsonUtils.getInstance().toObjectMapList(configInfo, RuleData.class).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            ruleDataList.forEach(ruleData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(subscriber -> {
                subscriber.unRuleSubscribe(ruleData);
                subscriber.onRuleSubscribe(ruleData);
            }));
        }
        catch (JsonParseException e) {
            log.error("sync rule data have error:", (Throwable)e);
        }
    }

    protected void updateMetaDataMap(String configInfo) {
        try {
            ArrayList metaDataList = new ArrayList(GsonUtils.getInstance().toObjectMap(configInfo, MetaData.class).values());
            metaDataList.forEach(metaData -> this.metaDataSubscribers.forEach(subscriber -> {
                subscriber.unSubscribe(metaData);
                subscriber.onSubscribe(metaData);
            }));
        }
        catch (JsonParseException e) {
            log.error("sync meta data have error:", (Throwable)e);
        }
    }

    protected void updateAuthMap(String configInfo) {
        try {
            ArrayList appAuthDataList = new ArrayList(GsonUtils.getInstance().toObjectMap(configInfo, AppAuthData.class).values());
            appAuthDataList.forEach(appAuthData -> this.authDataSubscribers.forEach(subscriber -> {
                subscriber.unSubscribe(appAuthData);
                subscriber.onSubscribe(appAuthData);
            }));
        }
        catch (JsonParseException e) {
            log.error("sync auth data have error:", (Throwable)e);
        }
    }

    private String getConfigAndSignListener(String dataId, Listener listener) {
        String config = this.configService.getConfigAndSignListener(dataId, GROUP, 6000L, listener);
        if (config == null) {
            config = "{}";
        }
        return config;
    }

    protected void watcherData(String dataId, final OnChange oc) {
        Listener listener = new Listener(){

            public void receiveConfigInfo(String configInfo) {
                oc.change(configInfo);
            }

            public Executor getExecutor() {
                return null;
            }
        };
        oc.change(this.getConfigAndSignListener(dataId, listener));
        LISTENERS.computeIfAbsent(dataId, key -> new ArrayList()).add(listener);
    }

    @Generated
    public ConfigService getConfigService() {
        return this.configService;
    }

    protected static interface OnChange {
        public void change(String var1);
    }
}

