/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.plugin.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.warm.flow.core.json.JsonConvert;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class JsonConvertGson
implements JsonConvert {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public Map<String, Object> strToMap(String jsonStr) {
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            return (Map)gson.fromJson(jsonStr, type);
        }
        return new HashMap<String, Object>();
    }

    public <T> T strToBean(String jsonStr, Class<T> clazz) {
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            return (T)gson.fromJson(jsonStr, clazz);
        }
        return null;
    }

    public <T> List<T> strToList(String jsonStr) {
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            Type listType = new TypeToken<List<T>>(){}.getType();
            return (List)gson.fromJson(jsonStr, listType);
        }
        return null;
    }

    public String objToStr(Object variable) {
        if (ObjectUtil.isNotNull((Object)variable)) {
            return gson.toJson(variable);
        }
        return null;
    }
}

