/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.component.image;

import java.util.Optional;
import org.dromara.pdf.fop.core.doc.component.Component;
import org.dromara.pdf.fop.core.doc.component.image.ImageParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Image
implements Component {
    private final ImageParam param = new ImageParam();

    public Image setMargin(String margin) {
        this.param.setMargin(margin);
        return this;
    }

    public Image setMarginTop(String marginTop) {
        this.param.setMarginTop(marginTop);
        return this;
    }

    public Image setMarginBottom(String marginBottom) {
        this.param.setMarginBottom(marginBottom);
        return this;
    }

    public Image setMarginLeft(String marginLeft) {
        this.param.setMarginLeft(marginLeft);
        return this;
    }

    public Image setMarginRight(String paddingRight) {
        this.param.setMarginRight(paddingRight);
        return this;
    }

    public Image setPadding(String padding) {
        this.param.setPadding(padding);
        return this;
    }

    public Image setPaddingTop(String paddingTop) {
        this.param.setPaddingTop(paddingTop);
        return this;
    }

    public Image setPaddingBottom(String paddingBottom) {
        this.param.setPaddingBottom(paddingBottom);
        return this;
    }

    public Image setPaddingLeft(String paddingLeft) {
        this.param.setPaddingLeft(paddingLeft);
        return this;
    }

    public Image setPaddingRight(String paddingRight) {
        this.param.setPaddingRight(paddingRight);
        return this;
    }

    public Image setId(String id) {
        this.param.setId(id);
        return this;
    }

    public Image setWidth(String width) {
        this.param.setWidth(width);
        return this;
    }

    public Image setHeight(String height) {
        this.param.setHeight(height);
        return this;
    }

    public Image setScaling(String scaling) {
        this.param.setScaling(scaling);
        return this;
    }

    public Image setPath(String path) {
        this.param.setPath(path);
        return this;
    }

    public Image setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public Image setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public Image setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public Image enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public Image enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public Image enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public Image enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        if (this.param.getPath() == null) {
            return null;
        }
        Element block = this.createBlockElement(document, this.param);
        block.appendChild(this.createExternalGraphic(document));
        return block;
    }

    private Element createExternalGraphic(Document document) {
        Element externalGraphic = document.createElement("fo:external-graphic");
        Optional.ofNullable(this.param.getWidth()).ifPresent(v -> externalGraphic.setAttribute("content-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getHeight()).ifPresent(v -> externalGraphic.setAttribute("content-height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getScaling()).ifPresent(v -> externalGraphic.setAttribute("scaling", v.intern().toLowerCase()));
        externalGraphic.setAttribute("src", this.param.getPath().intern());
        return externalGraphic;
    }
}

