/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.support.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Rectangle;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.apache.fop.fonts.Font;
import org.apache.fop.util.ColorUtil;
import org.apache.xmlgraphics.util.UnitConv;
import org.dromara.pdf.fop.core.doc.page.PageRectangle;
import org.dromara.pdf.fop.util.FontStyleUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BarCodeConfig {
    private BarcodeFormat type;
    private Double scaleRate;
    private Integer width;
    private Integer height;
    private String content;
    private Integer codeMargin;
    private ErrorCorrectionLevel errorLevel;
    private Color onColor;
    private Color offColor;
    private String words;
    private Color wordsColor;
    private String wordsFamily;
    private FontStyleUtil.FontStyle wordsStyle;
    private Integer wordsSize;
    private Integer wordsOffsetX;
    private Integer wordsOffsetY;
    private Double radians;
    private Boolean isNoWhiteBorder;
    private Boolean isCache;
    private final Map<EncodeHintType, Object> encodeHints = new HashMap<EncodeHintType, Object>(8);

    static BarCodeConfig init(NamedNodeMap attributes) {
        BarCodeConfig config = new BarCodeConfig();
        config.initParams(attributes);
        config.initEncodeHints();
        return config;
    }

    static BarCodeConfig onlyInitRectangle(NamedNodeMap attributes) {
        BarCodeConfig config = new BarCodeConfig();
        config.onlyInitRectangleParams(attributes);
        return config;
    }

    boolean isRotate() {
        return this.radians != null;
    }

    Rectangle getRotateRectangle() {
        return PageRectangle.getRotateRectangle(this.width, this.height, this.radians);
    }

    private void initParams(NamedNodeMap attributes) {
        this.type = this.resolveValue(attributes, "type", null, v -> BarcodeFormat.valueOf((String)v.toUpperCase()));
        this.scaleRate = this.resolveValue(attributes, "scale-rate", "2", Double::parseDouble);
        this.width = this.resolveValue(attributes, "width", null, this::parseUnit);
        this.height = this.resolveValue(attributes, "height", null, this::parseUnit);
        this.content = this.resolveValue(attributes, "content", null, v -> v);
        this.codeMargin = this.resolveValue(attributes, "code-margin", "1", Integer::parseInt);
        this.errorLevel = this.resolveValue(attributes, "error-level", "M", v -> ErrorCorrectionLevel.valueOf((String)v.toUpperCase()));
        this.onColor = this.resolveValue(attributes, "on-color", "BLACK", this::parseColor);
        this.offColor = this.resolveValue(attributes, "off-color", "WHITE", this::parseColor);
        this.words = Optional.ofNullable(attributes.getNamedItem("words")).map(Node::getNodeValue).orElse(null);
        this.wordsColor = this.resolveValue(attributes, "words-color", "BLACK", this::parseColor);
        this.wordsFamily = Optional.ofNullable(attributes.getNamedItem("words-family")).map(Node::getNodeValue).orElse(Font.DEFAULT_FONT.getName());
        this.wordsStyle = this.resolveValue(attributes, "words-style", "NORMAL", FontStyleUtil::getStyle);
        this.wordsSize = this.resolveValue(attributes, "words-size", "12pt", this::parseUnit);
        this.wordsOffsetX = this.resolveValue(attributes, "words-offset-x", "0pt", this::parseUnit);
        this.wordsOffsetY = this.resolveValue(attributes, "words-offset-y", "2pt", this::parseUnit);
        this.radians = this.resolveValue(attributes, "radians", "0", Double::parseDouble);
        this.isNoWhiteBorder = this.resolveValue(attributes, "no-white-border", "false", Boolean::parseBoolean);
        this.isCache = this.resolveValue(attributes, "cache", "false", Boolean::parseBoolean);
    }

    private void onlyInitRectangleParams(NamedNodeMap attributes) {
        this.width = this.resolveValue(attributes, "width", null, v -> UnitConv.convert((String)v) / 1000);
        this.height = this.resolveValue(attributes, "height", null, v -> UnitConv.convert((String)v) / 1000);
        this.radians = this.resolveValue(attributes, "radians", "0", Double::parseDouble);
        this.words = Optional.ofNullable(attributes.getNamedItem("words")).map(Node::getNodeValue).orElse(null);
        this.wordsSize = this.resolveValue(attributes, "words-size", "12pt", v -> UnitConv.convert((String)v) / 1000);
        if (this.isRotate()) {
            Rectangle rectangle = this.getRotateRectangle();
            this.width = rectangle.width;
            this.height = rectangle.height;
        }
    }

    private void initEncodeHints() {
        this.initErrorLevel();
        this.encodeHints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8);
        this.encodeHints.put(EncodeHintType.MARGIN, this.codeMargin);
    }

    private void initErrorLevel() {
        if (BarcodeFormat.AZTEC == this.type || BarcodeFormat.PDF_417 == this.type) {
            this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, this.errorLevel.getBits());
        } else {
            this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, this.errorLevel);
        }
    }

    private <R> R resolveValue(NamedNodeMap attributes, String attributeName, String defaultValue, Function<String, R> function) {
        return (R)Optional.ofNullable(Optional.ofNullable(attributes.getNamedItem(attributeName)).map(Node::getNodeValue).orElse(defaultValue)).map(v -> {
            try {
                return function.apply((String)v);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("the barcode attribute['" + attributeName + "'] is error");
            }
        }).orElseThrow(() -> new IllegalArgumentException("the barcode attribute['" + attributeName + "'] can not be null"));
    }

    private Color parseColor(String color) {
        return ColorUtil.parseColorString(null, (String)color);
    }

    private int parseUnit(String unit) {
        return (int)((double)UnitConv.convert((String)unit) / 1000.0 * this.scaleRate);
    }

    @Generated
    public BarCodeConfig() {
    }

    @Generated
    public BarcodeFormat getType() {
        return this.type;
    }

    @Generated
    public Double getScaleRate() {
        return this.scaleRate;
    }

    @Generated
    public Integer getWidth() {
        return this.width;
    }

    @Generated
    public Integer getHeight() {
        return this.height;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public Integer getCodeMargin() {
        return this.codeMargin;
    }

    @Generated
    public ErrorCorrectionLevel getErrorLevel() {
        return this.errorLevel;
    }

    @Generated
    public Color getOnColor() {
        return this.onColor;
    }

    @Generated
    public Color getOffColor() {
        return this.offColor;
    }

    @Generated
    public String getWords() {
        return this.words;
    }

    @Generated
    public Color getWordsColor() {
        return this.wordsColor;
    }

    @Generated
    public String getWordsFamily() {
        return this.wordsFamily;
    }

    @Generated
    public FontStyleUtil.FontStyle getWordsStyle() {
        return this.wordsStyle;
    }

    @Generated
    public Integer getWordsSize() {
        return this.wordsSize;
    }

    @Generated
    public Integer getWordsOffsetX() {
        return this.wordsOffsetX;
    }

    @Generated
    public Integer getWordsOffsetY() {
        return this.wordsOffsetY;
    }

    @Generated
    public Double getRadians() {
        return this.radians;
    }

    @Generated
    public Boolean getIsNoWhiteBorder() {
        return this.isNoWhiteBorder;
    }

    @Generated
    public Boolean getIsCache() {
        return this.isCache;
    }

    @Generated
    public Map<EncodeHintType, Object> getEncodeHints() {
        return this.encodeHints;
    }

    @Generated
    public BarCodeConfig setType(BarcodeFormat type) {
        this.type = type;
        return this;
    }

    @Generated
    public BarCodeConfig setScaleRate(Double scaleRate) {
        this.scaleRate = scaleRate;
        return this;
    }

    @Generated
    public BarCodeConfig setWidth(Integer width) {
        this.width = width;
        return this;
    }

    @Generated
    public BarCodeConfig setHeight(Integer height) {
        this.height = height;
        return this;
    }

    @Generated
    public BarCodeConfig setContent(String content) {
        this.content = content;
        return this;
    }

    @Generated
    public BarCodeConfig setCodeMargin(Integer codeMargin) {
        this.codeMargin = codeMargin;
        return this;
    }

    @Generated
    public BarCodeConfig setErrorLevel(ErrorCorrectionLevel errorLevel) {
        this.errorLevel = errorLevel;
        return this;
    }

    @Generated
    public BarCodeConfig setOnColor(Color onColor) {
        this.onColor = onColor;
        return this;
    }

    @Generated
    public BarCodeConfig setOffColor(Color offColor) {
        this.offColor = offColor;
        return this;
    }

    @Generated
    public BarCodeConfig setWords(String words) {
        this.words = words;
        return this;
    }

    @Generated
    public BarCodeConfig setWordsColor(Color wordsColor) {
        this.wordsColor = wordsColor;
        return this;
    }

    @Generated
    public BarCodeConfig setWordsFamily(String wordsFamily) {
        this.wordsFamily = wordsFamily;
        return this;
    }

    @Generated
    public BarCodeConfig setWordsStyle(FontStyleUtil.FontStyle wordsStyle) {
        this.wordsStyle = wordsStyle;
        return this;
    }

    @Generated
    public BarCodeConfig setWordsSize(Integer wordsSize) {
        this.wordsSize = wordsSize;
        return this;
    }

    @Generated
    public BarCodeConfig setWordsOffsetX(Integer wordsOffsetX) {
        this.wordsOffsetX = wordsOffsetX;
        return this;
    }

    @Generated
    public BarCodeConfig setWordsOffsetY(Integer wordsOffsetY) {
        this.wordsOffsetY = wordsOffsetY;
        return this;
    }

    @Generated
    public BarCodeConfig setRadians(Double radians) {
        this.radians = radians;
        return this;
    }

    @Generated
    public BarCodeConfig setIsNoWhiteBorder(Boolean isNoWhiteBorder) {
        this.isNoWhiteBorder = isNoWhiteBorder;
        return this;
    }

    @Generated
    public BarCodeConfig setIsCache(Boolean isCache) {
        this.isCache = isCache;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BarCodeConfig)) {
            return false;
        }
        BarCodeConfig other = (BarCodeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$scaleRate = this.getScaleRate();
        Double other$scaleRate = other.getScaleRate();
        if (this$scaleRate == null ? other$scaleRate != null : !((Object)this$scaleRate).equals(other$scaleRate)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$codeMargin = this.getCodeMargin();
        Integer other$codeMargin = other.getCodeMargin();
        if (this$codeMargin == null ? other$codeMargin != null : !((Object)this$codeMargin).equals(other$codeMargin)) {
            return false;
        }
        Integer this$wordsSize = this.getWordsSize();
        Integer other$wordsSize = other.getWordsSize();
        if (this$wordsSize == null ? other$wordsSize != null : !((Object)this$wordsSize).equals(other$wordsSize)) {
            return false;
        }
        Integer this$wordsOffsetX = this.getWordsOffsetX();
        Integer other$wordsOffsetX = other.getWordsOffsetX();
        if (this$wordsOffsetX == null ? other$wordsOffsetX != null : !((Object)this$wordsOffsetX).equals(other$wordsOffsetX)) {
            return false;
        }
        Integer this$wordsOffsetY = this.getWordsOffsetY();
        Integer other$wordsOffsetY = other.getWordsOffsetY();
        if (this$wordsOffsetY == null ? other$wordsOffsetY != null : !((Object)this$wordsOffsetY).equals(other$wordsOffsetY)) {
            return false;
        }
        Double this$radians = this.getRadians();
        Double other$radians = other.getRadians();
        if (this$radians == null ? other$radians != null : !((Object)this$radians).equals(other$radians)) {
            return false;
        }
        Boolean this$isNoWhiteBorder = this.getIsNoWhiteBorder();
        Boolean other$isNoWhiteBorder = other.getIsNoWhiteBorder();
        if (this$isNoWhiteBorder == null ? other$isNoWhiteBorder != null : !((Object)this$isNoWhiteBorder).equals(other$isNoWhiteBorder)) {
            return false;
        }
        Boolean this$isCache = this.getIsCache();
        Boolean other$isCache = other.getIsCache();
        if (this$isCache == null ? other$isCache != null : !((Object)this$isCache).equals(other$isCache)) {
            return false;
        }
        BarcodeFormat this$type = this.getType();
        BarcodeFormat other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        ErrorCorrectionLevel this$errorLevel = this.getErrorLevel();
        ErrorCorrectionLevel other$errorLevel = other.getErrorLevel();
        if (this$errorLevel == null ? other$errorLevel != null : !this$errorLevel.equals(other$errorLevel)) {
            return false;
        }
        Color this$onColor = this.getOnColor();
        Color other$onColor = other.getOnColor();
        if (this$onColor == null ? other$onColor != null : !((Object)this$onColor).equals(other$onColor)) {
            return false;
        }
        Color this$offColor = this.getOffColor();
        Color other$offColor = other.getOffColor();
        if (this$offColor == null ? other$offColor != null : !((Object)this$offColor).equals(other$offColor)) {
            return false;
        }
        String this$words = this.getWords();
        String other$words = other.getWords();
        if (this$words == null ? other$words != null : !this$words.equals(other$words)) {
            return false;
        }
        Color this$wordsColor = this.getWordsColor();
        Color other$wordsColor = other.getWordsColor();
        if (this$wordsColor == null ? other$wordsColor != null : !((Object)this$wordsColor).equals(other$wordsColor)) {
            return false;
        }
        String this$wordsFamily = this.getWordsFamily();
        String other$wordsFamily = other.getWordsFamily();
        if (this$wordsFamily == null ? other$wordsFamily != null : !this$wordsFamily.equals(other$wordsFamily)) {
            return false;
        }
        FontStyleUtil.FontStyle this$wordsStyle = this.getWordsStyle();
        FontStyleUtil.FontStyle other$wordsStyle = other.getWordsStyle();
        if (this$wordsStyle == null ? other$wordsStyle != null : !((Object)((Object)this$wordsStyle)).equals((Object)other$wordsStyle)) {
            return false;
        }
        Map<EncodeHintType, Object> this$encodeHints = this.getEncodeHints();
        Map<EncodeHintType, Object> other$encodeHints = other.getEncodeHints();
        return !(this$encodeHints == null ? other$encodeHints != null : !((Object)this$encodeHints).equals(other$encodeHints));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BarCodeConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $scaleRate = this.getScaleRate();
        result = result * 59 + ($scaleRate == null ? 43 : ((Object)$scaleRate).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $codeMargin = this.getCodeMargin();
        result = result * 59 + ($codeMargin == null ? 43 : ((Object)$codeMargin).hashCode());
        Integer $wordsSize = this.getWordsSize();
        result = result * 59 + ($wordsSize == null ? 43 : ((Object)$wordsSize).hashCode());
        Integer $wordsOffsetX = this.getWordsOffsetX();
        result = result * 59 + ($wordsOffsetX == null ? 43 : ((Object)$wordsOffsetX).hashCode());
        Integer $wordsOffsetY = this.getWordsOffsetY();
        result = result * 59 + ($wordsOffsetY == null ? 43 : ((Object)$wordsOffsetY).hashCode());
        Double $radians = this.getRadians();
        result = result * 59 + ($radians == null ? 43 : ((Object)$radians).hashCode());
        Boolean $isNoWhiteBorder = this.getIsNoWhiteBorder();
        result = result * 59 + ($isNoWhiteBorder == null ? 43 : ((Object)$isNoWhiteBorder).hashCode());
        Boolean $isCache = this.getIsCache();
        result = result * 59 + ($isCache == null ? 43 : ((Object)$isCache).hashCode());
        BarcodeFormat $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        ErrorCorrectionLevel $errorLevel = this.getErrorLevel();
        result = result * 59 + ($errorLevel == null ? 43 : $errorLevel.hashCode());
        Color $onColor = this.getOnColor();
        result = result * 59 + ($onColor == null ? 43 : ((Object)$onColor).hashCode());
        Color $offColor = this.getOffColor();
        result = result * 59 + ($offColor == null ? 43 : ((Object)$offColor).hashCode());
        String $words = this.getWords();
        result = result * 59 + ($words == null ? 43 : $words.hashCode());
        Color $wordsColor = this.getWordsColor();
        result = result * 59 + ($wordsColor == null ? 43 : ((Object)$wordsColor).hashCode());
        String $wordsFamily = this.getWordsFamily();
        result = result * 59 + ($wordsFamily == null ? 43 : $wordsFamily.hashCode());
        FontStyleUtil.FontStyle $wordsStyle = this.getWordsStyle();
        result = result * 59 + ($wordsStyle == null ? 43 : ((Object)((Object)$wordsStyle)).hashCode());
        Map<EncodeHintType, Object> $encodeHints = this.getEncodeHints();
        result = result * 59 + ($encodeHints == null ? 43 : ((Object)$encodeHints).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BarCodeConfig(type=" + this.getType() + ", scaleRate=" + this.getScaleRate() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", content=" + this.getContent() + ", codeMargin=" + this.getCodeMargin() + ", errorLevel=" + this.getErrorLevel() + ", onColor=" + this.getOnColor() + ", offColor=" + this.getOffColor() + ", words=" + this.getWords() + ", wordsColor=" + this.getWordsColor() + ", wordsFamily=" + this.getWordsFamily() + ", wordsStyle=" + (Object)((Object)this.getWordsStyle()) + ", wordsSize=" + this.getWordsSize() + ", wordsOffsetX=" + this.getWordsOffsetX() + ", wordsOffsetY=" + this.getWordsOffsetY() + ", radians=" + this.getRadians() + ", isNoWhiteBorder=" + this.getIsNoWhiteBorder() + ", isCache=" + this.getIsCache() + ", encodeHints=" + this.getEncodeHints() + ")";
    }
}

