/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser.xref;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.xref.AbstractXReference;
import org.apache.pdfbox.pdfparser.xref.XReferenceType;

public class NormalXReference
extends AbstractXReference {
    private final COSObjectKey key;
    private final COSBase object;
    private final boolean objectStream;
    private long byteOffset;

    public NormalXReference(long byteOffset, COSObjectKey key, COSBase object) {
        super(XReferenceType.NORMAL);
        this.byteOffset = byteOffset;
        this.key = key;
        this.object = object;
        COSBase base = object instanceof COSObject ? ((COSObject)object).getObject() : object;
        this.objectStream = base instanceof COSStream ? COSName.OBJ_STM.equals((Object)((COSStream)base).getCOSName(COSName.TYPE)) : false;
    }

    public void setOffset(long byteOffset) {
        this.byteOffset = byteOffset;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public COSObjectKey getReferencedKey() {
        return this.key;
    }

    public COSBase getObject() {
        return this.object;
    }

    public boolean isObjectStream() {
        return this.objectStream;
    }

    public long getSecondColumnValue() {
        return this.getByteOffset();
    }

    public long getThirdColumnValue() {
        return this.getReferencedKey().getGeneration();
    }

    public String toString() {
        return (this.isObjectStream() ? "ObjectStreamParent{" : "NormalReference{") + " key=" + this.key + ", type=" + this.getType().getNumericValue() + ", byteOffset=" + this.byteOffset + " }";
    }
}

