/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.base.Cursor;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PageFooter;
import org.dromara.pdf.pdfbox.core.base.PageHeader;
import org.dromara.pdf.pdfbox.core.component.AbstractPageHeaderOrFooter;
import org.dromara.pdf.pdfbox.core.component.BorderInfo;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.ext.handler.AbstractTextHandler;
import org.dromara.pdf.pdfbox.core.info.CatalogInfo;
import org.dromara.pdf.pdfbox.handler.PdfHandler;

public class Context {
    protected Document document;
    protected Page page;
    protected Integer pageCount;
    protected ComponentType executingComponentType;
    protected PageHeader pageHeader;
    protected PageFooter pageFooter;
    protected Cursor cursor;
    protected Float offsetY;
    protected Float wrapBeginX;
    protected Float wrapWidth;
    protected Float height;
    protected Boolean isFirstComponent;
    protected Boolean isAlreadyPaging;
    protected Boolean isVirtualRender;
    protected Boolean isManualBreak;
    protected List<CatalogInfo> catalogs;
    protected BorderInfo borderInfo;
    protected Map<String, Object> customInfo;
    protected Map<String, PDFont> fontMap;
    protected AbstractTextHandler textHandler;

    public Context(Document document) {
        this.document = document;
        this.wrapBeginX = Float.valueOf(0.0f);
        this.offsetY = Float.valueOf(0.0f);
        this.cursor = new Cursor();
        this.isFirstComponent = Boolean.TRUE;
        this.isVirtualRender = Boolean.FALSE;
        this.isManualBreak = Boolean.FALSE;
        this.catalogs = new ArrayList<CatalogInfo>(16);
        this.customInfo = new HashMap<String, Object>(16);
        this.fontMap = new HashMap<String, PDFont>(16);
    }

    public void setTextHandler(AbstractTextHandler handler) {
        Objects.requireNonNull(handler, "the handler can not be null");
        this.textHandler = handler;
    }

    public PDDocument getTargetDocument() {
        return this.document.getTarget();
    }

    public PDPage getTargetPage() {
        return this.page.getTarget();
    }

    public PDFont getFont(String fontName) {
        PDFont font = this.fontMap.get(fontName);
        if (Objects.isNull(font)) {
            this.addFontCache(fontName);
            font = this.fontMap.get(fontName);
        }
        return font;
    }

    public boolean isEqualsComponent(ComponentType type) {
        return this.executingComponentType == type;
    }

    public boolean hasPageHeader() {
        return Objects.nonNull(this.pageHeader);
    }

    public boolean hasPageFooter() {
        return Objects.nonNull(this.pageFooter);
    }

    public float getPageHeaderHeight() {
        return Optional.ofNullable(this.pageHeader).map(AbstractPageHeaderOrFooter::getHeight).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float getPageFooterHeight() {
        return Optional.ofNullable(this.pageFooter).map(AbstractPageHeaderOrFooter::getHeight).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float getMaxBeginX() {
        return this.page.getWidth().floatValue() - this.page.getMarginRight().floatValue();
    }

    public float getMaxBeginY() {
        return this.page.getHeight().floatValue() - this.page.getMarginTop().floatValue() - this.getPageHeaderHeight();
    }

    public void addFontCache(String ... fontNames) {
        Objects.requireNonNull(fontNames, "the font names can not be null");
        for (String fontName : fontNames) {
            if (this.fontMap.containsKey(fontName)) continue;
            this.fontMap.put(fontName, PdfHandler.getFontHandler().getPDFont(this.getTargetDocument(), fontName, true));
        }
    }

    public void reset(Page page) {
        this.isAlreadyPaging = !page.getId().equals(Optional.ofNullable(this.page).map(Page::getId).orElse(null));
        if (this.isAlreadyPaging.booleanValue()) {
            this.pageCount = Optional.ofNullable(this.pageCount).orElse(0) + 1;
            this.page = page;
            this.setIsFirstComponent(true);
            this.resetHeight(this.height);
            this.resetCursor();
            this.resetWrapBeginX(this.page.getMarginLeft());
            this.resetWrapWidth(this.wrapWidth);
        }
    }

    public void resetCursor() {
        this.cursor.reset(this.page.getMarginLeft().floatValue(), this.page.getHeight().floatValue() - this.page.getMarginTop().floatValue());
    }

    public void resetCursor(Float beginX, Float beginY) {
        this.cursor.reset(beginX.floatValue(), beginY.floatValue());
    }

    public void resetCursorX(Float beginX) {
        this.cursor.setX(beginX);
    }

    public void resetCursorY(Float beginY) {
        this.cursor.setY(beginY);
    }

    public void resetWrapWidth(Float wrapWidth) {
        this.wrapWidth = Objects.isNull(wrapWidth) ? this.page.getWithoutMarginWidth() : wrapWidth;
    }

    public void resetHeight(Float height) {
        this.height = Objects.isNull(height) ? Float.valueOf(this.page.getWithoutMarginHeight().floatValue() - this.getPageHeaderHeight() - this.getPageFooterHeight()) : height;
    }

    public void resetWrapBeginX(Float wrapBeginX) {
        this.wrapBeginX = Objects.isNull(wrapBeginX) ? this.page.getMarginLeft() : wrapBeginX;
    }

    public void resetOffsetY(Float offsetY) {
        this.offsetY = Objects.isNull(offsetY) ? Float.valueOf(0.0f) : offsetY;
    }

    public void resetExecutingComponentType(ComponentType type) {
        if (type == this.executingComponentType) {
            this.executingComponentType = null;
        }
    }

    public void resetIsVirtualRender(Boolean isVirtualRender) {
        this.isVirtualRender = Objects.isNull(isVirtualRender) ? Boolean.FALSE : isVirtualRender;
    }

    public void clear() {
        this.document = null;
        this.page = null;
        this.pageHeader = null;
        this.pageFooter = null;
        this.borderInfo = null;
        this.fontMap.clear();
    }

    @Generated
    public Document getDocument() {
        return this.document;
    }

    @Generated
    public Page getPage() {
        return this.page;
    }

    @Generated
    public Integer getPageCount() {
        return this.pageCount;
    }

    @Generated
    public ComponentType getExecutingComponentType() {
        return this.executingComponentType;
    }

    @Generated
    public PageHeader getPageHeader() {
        return this.pageHeader;
    }

    @Generated
    public PageFooter getPageFooter() {
        return this.pageFooter;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public Float getOffsetY() {
        return this.offsetY;
    }

    @Generated
    public Float getWrapBeginX() {
        return this.wrapBeginX;
    }

    @Generated
    public Float getWrapWidth() {
        return this.wrapWidth;
    }

    @Generated
    public Float getHeight() {
        return this.height;
    }

    @Generated
    public Boolean getIsFirstComponent() {
        return this.isFirstComponent;
    }

    @Generated
    public Boolean getIsAlreadyPaging() {
        return this.isAlreadyPaging;
    }

    @Generated
    public Boolean getIsVirtualRender() {
        return this.isVirtualRender;
    }

    @Generated
    public Boolean getIsManualBreak() {
        return this.isManualBreak;
    }

    @Generated
    public List<CatalogInfo> getCatalogs() {
        return this.catalogs;
    }

    @Generated
    public BorderInfo getBorderInfo() {
        return this.borderInfo;
    }

    @Generated
    public Map<String, Object> getCustomInfo() {
        return this.customInfo;
    }

    @Generated
    public Map<String, PDFont> getFontMap() {
        return this.fontMap;
    }

    @Generated
    public AbstractTextHandler getTextHandler() {
        return this.textHandler;
    }

    @Generated
    public void setDocument(Document document) {
        this.document = document;
    }

    @Generated
    public void setPage(Page page) {
        this.page = page;
    }

    @Generated
    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    @Generated
    public void setExecutingComponentType(ComponentType executingComponentType) {
        this.executingComponentType = executingComponentType;
    }

    @Generated
    public void setPageHeader(PageHeader pageHeader) {
        this.pageHeader = pageHeader;
    }

    @Generated
    public void setPageFooter(PageFooter pageFooter) {
        this.pageFooter = pageFooter;
    }

    @Generated
    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    @Generated
    public void setOffsetY(Float offsetY) {
        this.offsetY = offsetY;
    }

    @Generated
    public void setWrapBeginX(Float wrapBeginX) {
        this.wrapBeginX = wrapBeginX;
    }

    @Generated
    public void setWrapWidth(Float wrapWidth) {
        this.wrapWidth = wrapWidth;
    }

    @Generated
    public void setHeight(Float height) {
        this.height = height;
    }

    @Generated
    public void setIsFirstComponent(Boolean isFirstComponent) {
        this.isFirstComponent = isFirstComponent;
    }

    @Generated
    public void setIsAlreadyPaging(Boolean isAlreadyPaging) {
        this.isAlreadyPaging = isAlreadyPaging;
    }

    @Generated
    public void setIsVirtualRender(Boolean isVirtualRender) {
        this.isVirtualRender = isVirtualRender;
    }

    @Generated
    public void setIsManualBreak(Boolean isManualBreak) {
        this.isManualBreak = isManualBreak;
    }

    @Generated
    public void setCatalogs(List<CatalogInfo> catalogs) {
        this.catalogs = catalogs;
    }

    @Generated
    public void setBorderInfo(BorderInfo borderInfo) {
        this.borderInfo = borderInfo;
    }

    @Generated
    public void setCustomInfo(Map<String, Object> customInfo) {
        this.customInfo = customInfo;
    }

    @Generated
    public void setFontMap(Map<String, PDFont> fontMap) {
        this.fontMap = fontMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context other = (Context)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageCount = this.getPageCount();
        Integer other$pageCount = other.getPageCount();
        if (this$pageCount == null ? other$pageCount != null : !((Object)this$pageCount).equals(other$pageCount)) {
            return false;
        }
        Float this$offsetY = this.getOffsetY();
        Float other$offsetY = other.getOffsetY();
        if (this$offsetY == null ? other$offsetY != null : !((Object)this$offsetY).equals(other$offsetY)) {
            return false;
        }
        Float this$wrapBeginX = this.getWrapBeginX();
        Float other$wrapBeginX = other.getWrapBeginX();
        if (this$wrapBeginX == null ? other$wrapBeginX != null : !((Object)this$wrapBeginX).equals(other$wrapBeginX)) {
            return false;
        }
        Float this$wrapWidth = this.getWrapWidth();
        Float other$wrapWidth = other.getWrapWidth();
        if (this$wrapWidth == null ? other$wrapWidth != null : !((Object)this$wrapWidth).equals(other$wrapWidth)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Boolean this$isFirstComponent = this.getIsFirstComponent();
        Boolean other$isFirstComponent = other.getIsFirstComponent();
        if (this$isFirstComponent == null ? other$isFirstComponent != null : !((Object)this$isFirstComponent).equals(other$isFirstComponent)) {
            return false;
        }
        Boolean this$isAlreadyPaging = this.getIsAlreadyPaging();
        Boolean other$isAlreadyPaging = other.getIsAlreadyPaging();
        if (this$isAlreadyPaging == null ? other$isAlreadyPaging != null : !((Object)this$isAlreadyPaging).equals(other$isAlreadyPaging)) {
            return false;
        }
        Boolean this$isVirtualRender = this.getIsVirtualRender();
        Boolean other$isVirtualRender = other.getIsVirtualRender();
        if (this$isVirtualRender == null ? other$isVirtualRender != null : !((Object)this$isVirtualRender).equals(other$isVirtualRender)) {
            return false;
        }
        Boolean this$isManualBreak = this.getIsManualBreak();
        Boolean other$isManualBreak = other.getIsManualBreak();
        if (this$isManualBreak == null ? other$isManualBreak != null : !((Object)this$isManualBreak).equals(other$isManualBreak)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
            return false;
        }
        Page this$page = this.getPage();
        Page other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        ComponentType this$executingComponentType = this.getExecutingComponentType();
        ComponentType other$executingComponentType = other.getExecutingComponentType();
        if (this$executingComponentType == null ? other$executingComponentType != null : !((Object)((Object)this$executingComponentType)).equals((Object)other$executingComponentType)) {
            return false;
        }
        PageHeader this$pageHeader = this.getPageHeader();
        PageHeader other$pageHeader = other.getPageHeader();
        if (this$pageHeader == null ? other$pageHeader != null : !((Object)this$pageHeader).equals(other$pageHeader)) {
            return false;
        }
        PageFooter this$pageFooter = this.getPageFooter();
        PageFooter other$pageFooter = other.getPageFooter();
        if (this$pageFooter == null ? other$pageFooter != null : !((Object)this$pageFooter).equals(other$pageFooter)) {
            return false;
        }
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !((Object)this$cursor).equals(other$cursor)) {
            return false;
        }
        List<CatalogInfo> this$catalogs = this.getCatalogs();
        List<CatalogInfo> other$catalogs = other.getCatalogs();
        if (this$catalogs == null ? other$catalogs != null : !((Object)this$catalogs).equals(other$catalogs)) {
            return false;
        }
        BorderInfo this$borderInfo = this.getBorderInfo();
        BorderInfo other$borderInfo = other.getBorderInfo();
        if (this$borderInfo == null ? other$borderInfo != null : !((Object)this$borderInfo).equals(other$borderInfo)) {
            return false;
        }
        Map<String, Object> this$customInfo = this.getCustomInfo();
        Map<String, Object> other$customInfo = other.getCustomInfo();
        if (this$customInfo == null ? other$customInfo != null : !((Object)this$customInfo).equals(other$customInfo)) {
            return false;
        }
        Map<String, PDFont> this$fontMap = this.getFontMap();
        Map<String, PDFont> other$fontMap = other.getFontMap();
        if (this$fontMap == null ? other$fontMap != null : !((Object)this$fontMap).equals(other$fontMap)) {
            return false;
        }
        AbstractTextHandler this$textHandler = this.getTextHandler();
        AbstractTextHandler other$textHandler = other.getTextHandler();
        return !(this$textHandler == null ? other$textHandler != null : !((Object)this$textHandler).equals(other$textHandler));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Context;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageCount = this.getPageCount();
        result = result * 59 + ($pageCount == null ? 43 : ((Object)$pageCount).hashCode());
        Float $offsetY = this.getOffsetY();
        result = result * 59 + ($offsetY == null ? 43 : ((Object)$offsetY).hashCode());
        Float $wrapBeginX = this.getWrapBeginX();
        result = result * 59 + ($wrapBeginX == null ? 43 : ((Object)$wrapBeginX).hashCode());
        Float $wrapWidth = this.getWrapWidth();
        result = result * 59 + ($wrapWidth == null ? 43 : ((Object)$wrapWidth).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Boolean $isFirstComponent = this.getIsFirstComponent();
        result = result * 59 + ($isFirstComponent == null ? 43 : ((Object)$isFirstComponent).hashCode());
        Boolean $isAlreadyPaging = this.getIsAlreadyPaging();
        result = result * 59 + ($isAlreadyPaging == null ? 43 : ((Object)$isAlreadyPaging).hashCode());
        Boolean $isVirtualRender = this.getIsVirtualRender();
        result = result * 59 + ($isVirtualRender == null ? 43 : ((Object)$isVirtualRender).hashCode());
        Boolean $isManualBreak = this.getIsManualBreak();
        result = result * 59 + ($isManualBreak == null ? 43 : ((Object)$isManualBreak).hashCode());
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
        Page $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        ComponentType $executingComponentType = this.getExecutingComponentType();
        result = result * 59 + ($executingComponentType == null ? 43 : ((Object)((Object)$executingComponentType)).hashCode());
        PageHeader $pageHeader = this.getPageHeader();
        result = result * 59 + ($pageHeader == null ? 43 : ((Object)$pageHeader).hashCode());
        PageFooter $pageFooter = this.getPageFooter();
        result = result * 59 + ($pageFooter == null ? 43 : ((Object)$pageFooter).hashCode());
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : ((Object)$cursor).hashCode());
        List<CatalogInfo> $catalogs = this.getCatalogs();
        result = result * 59 + ($catalogs == null ? 43 : ((Object)$catalogs).hashCode());
        BorderInfo $borderInfo = this.getBorderInfo();
        result = result * 59 + ($borderInfo == null ? 43 : ((Object)$borderInfo).hashCode());
        Map<String, Object> $customInfo = this.getCustomInfo();
        result = result * 59 + ($customInfo == null ? 43 : ((Object)$customInfo).hashCode());
        Map<String, PDFont> $fontMap = this.getFontMap();
        result = result * 59 + ($fontMap == null ? 43 : ((Object)$fontMap).hashCode());
        AbstractTextHandler $textHandler = this.getTextHandler();
        result = result * 59 + ($textHandler == null ? 43 : ((Object)$textHandler).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Context(document=" + this.getDocument() + ", page=" + this.getPage() + ", pageCount=" + this.getPageCount() + ", executingComponentType=" + (Object)((Object)this.getExecutingComponentType()) + ", pageHeader=" + this.getPageHeader() + ", pageFooter=" + this.getPageFooter() + ", cursor=" + this.getCursor() + ", offsetY=" + this.getOffsetY() + ", wrapBeginX=" + this.getWrapBeginX() + ", wrapWidth=" + this.getWrapWidth() + ", height=" + this.getHeight() + ", isFirstComponent=" + this.getIsFirstComponent() + ", isAlreadyPaging=" + this.getIsAlreadyPaging() + ", isVirtualRender=" + this.getIsVirtualRender() + ", isManualBreak=" + this.getIsManualBreak() + ", catalogs=" + this.getCatalogs() + ", borderInfo=" + this.getBorderInfo() + ", customInfo=" + this.getCustomInfo() + ", fontMap=" + this.getFontMap() + ", textHandler=" + this.getTextHandler() + ")";
    }
}

