/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.AbstractBase;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.base.config.BorderConfiguration;
import org.dromara.pdf.pdfbox.core.base.config.MarginConfiguration;
import org.dromara.pdf.pdfbox.core.component.Component;
import org.dromara.pdf.pdfbox.core.component.DefaultPageHeaderFooterPagingEvent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.LineCapStyle;
import org.dromara.pdf.pdfbox.core.enums.LineStyle;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public abstract class AbstractPageHeaderOrFooter
extends AbstractBase {
    protected MarginConfiguration marginConfiguration;
    protected BorderConfiguration borderConfiguration;
    protected PagingEvent pagingEvent;
    protected Color backgroundColor;
    protected Float width;
    protected Float height;
    protected Float beginX;
    protected Float beginY;
    protected List<Component> components;
    protected Boolean isAlreadyRendered;
    protected HorizontalAlignment contentHorizontalAlignment;
    protected VerticalAlignment contentVerticalAlignment;

    public AbstractPageHeaderOrFooter(Page page) {
        super.init(page);
        this.context.reset(page);
        this.marginConfiguration = new MarginConfiguration();
        this.borderConfiguration = new BorderConfiguration();
        this.pagingEvent = new DefaultPageHeaderFooterPagingEvent();
        this.backgroundColor = page.getBackgroundColor();
        this.isAlreadyRendered = Boolean.FALSE;
    }

    protected abstract void init();

    public abstract ComponentType getType();

    public abstract PagingEvent getPagingEvent();

    public void setMargin(float margin) {
        this.marginConfiguration.setMargin(margin);
    }

    public void setMarginTop(float margin) {
        this.marginConfiguration.setMarginTop(margin);
    }

    public void setMarginBottom(float margin) {
        this.marginConfiguration.setMarginBottom(margin);
    }

    public void setMarginLeft(float margin) {
        this.marginConfiguration.setMarginLeft(margin);
    }

    public void setMarginRight(float margin) {
        this.marginConfiguration.setMarginRight(margin);
    }

    public void setBorderLineStyle(LineStyle style) {
        this.borderConfiguration.setBorderLineStyle(style);
    }

    public void setBorderLineCapStyle(LineCapStyle style) {
        this.borderConfiguration.setBorderLineCapStyle(style);
    }

    public void setBorderLineLength(float length) {
        this.borderConfiguration.setBorderLineLength(length);
    }

    public void setBorderLineWidth(float width) {
        this.borderConfiguration.setBorderLineWidth(width);
    }

    public void setBorderDottedSpacing(float spacing) {
        this.borderConfiguration.setBorderDottedSpacing(spacing);
    }

    public void setBorderColor(Color color) {
        this.borderConfiguration.setBorderColor(color);
    }

    public void setBorderTopColor(Color color) {
        this.borderConfiguration.setBorderTopColor(color);
    }

    public void setBorderBottomColor(Color color) {
        this.borderConfiguration.setBorderBottomColor(color);
    }

    public void setBorderLeftColor(Color color) {
        this.borderConfiguration.setBorderLeftColor(color);
    }

    public void setBorderRightColor(Color color) {
        this.borderConfiguration.setBorderRightColor(color);
    }

    public void setBorderRightColor(boolean flag) {
        this.borderConfiguration.setIsBorderTop(flag);
    }

    public void setIsBorder(boolean flag) {
        this.borderConfiguration.setIsBorder(flag);
    }

    public void setIsBorderBottom(boolean flag) {
        this.borderConfiguration.setIsBorderBottom(flag);
    }

    public void setIsBorderLeft(boolean flag) {
        this.borderConfiguration.setIsBorderLeft(flag);
    }

    public void setIsBorderRight(boolean flag) {
        this.borderConfiguration.setIsBorderRight(flag);
    }

    public void setHeight(float height) {
        Objects.requireNonNull(Float.valueOf(height), "the height can not be null");
        if (height > this.getContext().getPage().getWithoutMarginHeight().floatValue()) {
            throw new IllegalArgumentException("the height can not be greater than the page height");
        }
        this.height = Float.valueOf(height);
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void setComponents(Component ... components) {
        if (Objects.nonNull(components)) {
            this.components = new ArrayList<Component>(components.length);
            Collections.addAll(this.components, components);
        } else {
            this.components = null;
        }
    }

    public Page getPage() {
        return this.getContext().getPage();
    }

    public Float getMarginTop() {
        return this.marginConfiguration.getMarginTop();
    }

    public Float getMarginBottom() {
        return this.marginConfiguration.getMarginBottom();
    }

    public Float getMarginLeft() {
        return this.marginConfiguration.getMarginLeft();
    }

    public Float getMarginRight() {
        return this.marginConfiguration.getMarginRight();
    }

    public LineStyle getBorderLineStyle() {
        return this.borderConfiguration.getBorderLineStyle();
    }

    public LineCapStyle getBorderLineCapStyle() {
        return this.borderConfiguration.getBorderLineCapStyle();
    }

    public Float getBorderLineLength() {
        return this.borderConfiguration.getBorderLineLength();
    }

    public Float getBorderLineWidth() {
        return this.borderConfiguration.getBorderLineWidth();
    }

    public Float getBorderDottedSpacing() {
        return this.borderConfiguration.getBorderDottedSpacing();
    }

    public Color getBorderTopColor() {
        return this.borderConfiguration.getBorderTopColor();
    }

    public Color getBorderBottomColor() {
        return this.borderConfiguration.getBorderBottomColor();
    }

    public Color getBorderLeftColor() {
        return this.borderConfiguration.getBorderLeftColor();
    }

    public Color getBorderRightColor() {
        return this.borderConfiguration.getBorderRightColor();
    }

    public Boolean getIsBorderTop() {
        return this.borderConfiguration.getIsBorderTop();
    }

    public Boolean getIsBorderBottom() {
        return this.borderConfiguration.getIsBorderBottom();
    }

    public Boolean getIsBorderLeft() {
        return this.borderConfiguration.getIsBorderLeft();
    }

    public Boolean getIsBorderRight() {
        return this.borderConfiguration.getIsBorderRight();
    }

    public void renderBefore() {
        this.getContext().setIsFirstComponent(true);
        if (Objects.nonNull(this.getBackgroundColor())) {
            PDRectangle rectangle = new PDRectangle(this.getBeginX().floatValue(), this.getBeginY().floatValue() - this.getHeight().floatValue(), this.getWidth().floatValue(), this.getHeight().floatValue());
            CommonUtil.addBackgroundColor(this.getContext(), this.getContentMode(), this.getIsResetContentStream(), rectangle, this.getBackgroundColor());
        }
    }

    public void virtualRender() {
        this.init();
        Optional.ofNullable(this.getComponents()).orElse(Collections.emptyList()).forEach(this::virtualRenderComponent);
        this.reset();
    }

    public void render() {
        if (!this.getIsAlreadyRendered().booleanValue()) {
            this.init();
            this.renderBefore();
            Optional.ofNullable(this.getComponents()).orElse(Collections.emptyList()).forEach(this::renderComponent);
            this.renderAfter();
            this.reset();
        }
    }

    public void renderAfter() {
        if (this.getBorderConfiguration().hasBorder()) {
            BorderData borderData = new BorderData(this, this.getBorderConfiguration());
            PDRectangle rectangle = new PDRectangle(this.getBeginX().floatValue(), this.getBeginY().floatValue() - this.getHeight().floatValue(), this.getWidth().floatValue(), this.getHeight().floatValue());
            BorderUtil.drawBorderWithData(borderData, rectangle);
        }
        this.setIsAlreadyRendered(true);
    }

    public void virtualRenderComponent(Component component) {
        component.getContext().setExecutingComponentType(this.getType());
        component.setHorizontalAlignment(this.getContentHorizontalAlignment());
        component.setVerticalAlignment(this.getContentVerticalAlignment());
        this.getContext().setWrapBeginX(this.getBeginX());
        this.getContext().resetWrapWidth(Float.valueOf(this.getWidth().floatValue() - this.getMarginLeft().floatValue() - this.getMarginRight().floatValue()));
        component.virtualRender();
    }

    public void renderComponent(Component component) {
        component.getContext().setExecutingComponentType(this.getType());
        this.getContext().resetWrapBeginX(this.getBeginX());
        this.getContext().resetWrapWidth(Float.valueOf(this.getWidth().floatValue() - this.getMarginLeft().floatValue() - this.getMarginRight().floatValue()));
        this.getContext().resetHeight(this.getHeight());
        component.render();
    }

    public void reset() {
        this.getContext().getCursor().reset(this.getBeginX().floatValue(), this.getBeginY().floatValue() - this.getHeight().floatValue());
        this.getContext().setIsFirstComponent(!this.getContext().hasPageHeader());
        this.getContext().resetExecutingComponentType(this.getType());
        this.getContext().resetWrapBeginX(null);
        this.getContext().resetWrapWidth(null);
    }

    protected void initBackgroundColor(float beginX, float beginY) {
        if (Objects.equals(this.backgroundColor, Color.WHITE)) {
            PDRectangle rectangle = new PDRectangle(beginX, beginY - this.getHeight().floatValue(), this.getWidth().floatValue() - this.getMarginLeft().floatValue() - this.getMarginRight().floatValue(), this.getHeight().floatValue());
            CommonUtil.addBackgroundColor(this.getContext(), this.getContentMode(), this.getIsResetContentStream(), rectangle, this.getBackgroundColor());
        }
    }

    protected void initWidth() {
        this.width = this.getContext().getPage().getWithoutMarginWidth();
    }

    protected void setWidth(float width) {
    }

    @Generated
    public MarginConfiguration getMarginConfiguration() {
        return this.marginConfiguration;
    }

    @Generated
    public BorderConfiguration getBorderConfiguration() {
        return this.borderConfiguration;
    }

    @Generated
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public Float getWidth() {
        return this.width;
    }

    @Generated
    public Float getHeight() {
        return this.height;
    }

    @Generated
    public Float getBeginX() {
        return this.beginX;
    }

    @Generated
    public Float getBeginY() {
        return this.beginY;
    }

    @Generated
    public List<Component> getComponents() {
        return this.components;
    }

    @Generated
    public Boolean getIsAlreadyRendered() {
        return this.isAlreadyRendered;
    }

    @Generated
    public HorizontalAlignment getContentHorizontalAlignment() {
        return this.contentHorizontalAlignment;
    }

    @Generated
    public VerticalAlignment getContentVerticalAlignment() {
        return this.contentVerticalAlignment;
    }

    @Generated
    public void setMarginConfiguration(MarginConfiguration marginConfiguration) {
        this.marginConfiguration = marginConfiguration;
    }

    @Generated
    public void setBorderConfiguration(BorderConfiguration borderConfiguration) {
        this.borderConfiguration = borderConfiguration;
    }

    @Generated
    public void setPagingEvent(PagingEvent pagingEvent) {
        this.pagingEvent = pagingEvent;
    }

    @Generated
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Generated
    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    @Generated
    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    @Generated
    public void setIsAlreadyRendered(Boolean isAlreadyRendered) {
        this.isAlreadyRendered = isAlreadyRendered;
    }

    @Generated
    public void setContentHorizontalAlignment(HorizontalAlignment contentHorizontalAlignment) {
        this.contentHorizontalAlignment = contentHorizontalAlignment;
    }

    @Generated
    public void setContentVerticalAlignment(VerticalAlignment contentVerticalAlignment) {
        this.contentVerticalAlignment = contentVerticalAlignment;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractPageHeaderOrFooter(marginConfiguration=" + this.getMarginConfiguration() + ", borderConfiguration=" + this.getBorderConfiguration() + ", pagingEvent=" + this.getPagingEvent() + ", backgroundColor=" + this.getBackgroundColor() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", components=" + this.getComponents() + ", isAlreadyRendered=" + this.getIsAlreadyRendered() + ", contentHorizontalAlignment=" + (Object)((Object)this.getContentHorizontalAlignment()) + ", contentVerticalAlignment=" + (Object)((Object)this.getContentVerticalAlignment()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPageHeaderOrFooter)) {
            return false;
        }
        AbstractPageHeaderOrFooter other = (AbstractPageHeaderOrFooter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Boolean this$isAlreadyRendered = this.getIsAlreadyRendered();
        Boolean other$isAlreadyRendered = other.getIsAlreadyRendered();
        if (this$isAlreadyRendered == null ? other$isAlreadyRendered != null : !((Object)this$isAlreadyRendered).equals(other$isAlreadyRendered)) {
            return false;
        }
        MarginConfiguration this$marginConfiguration = this.getMarginConfiguration();
        MarginConfiguration other$marginConfiguration = other.getMarginConfiguration();
        if (this$marginConfiguration == null ? other$marginConfiguration != null : !((Object)this$marginConfiguration).equals(other$marginConfiguration)) {
            return false;
        }
        BorderConfiguration this$borderConfiguration = this.getBorderConfiguration();
        BorderConfiguration other$borderConfiguration = other.getBorderConfiguration();
        if (this$borderConfiguration == null ? other$borderConfiguration != null : !((Object)this$borderConfiguration).equals(other$borderConfiguration)) {
            return false;
        }
        PagingEvent this$pagingEvent = this.getPagingEvent();
        PagingEvent other$pagingEvent = other.getPagingEvent();
        if (this$pagingEvent == null ? other$pagingEvent != null : !this$pagingEvent.equals(other$pagingEvent)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        HorizontalAlignment this$contentHorizontalAlignment = this.getContentHorizontalAlignment();
        HorizontalAlignment other$contentHorizontalAlignment = other.getContentHorizontalAlignment();
        if (this$contentHorizontalAlignment == null ? other$contentHorizontalAlignment != null : !((Object)((Object)this$contentHorizontalAlignment)).equals((Object)other$contentHorizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$contentVerticalAlignment = this.getContentVerticalAlignment();
        VerticalAlignment other$contentVerticalAlignment = other.getContentVerticalAlignment();
        return !(this$contentVerticalAlignment == null ? other$contentVerticalAlignment != null : !((Object)((Object)this$contentVerticalAlignment)).equals((Object)other$contentVerticalAlignment));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractPageHeaderOrFooter;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Boolean $isAlreadyRendered = this.getIsAlreadyRendered();
        result = result * 59 + ($isAlreadyRendered == null ? 43 : ((Object)$isAlreadyRendered).hashCode());
        MarginConfiguration $marginConfiguration = this.getMarginConfiguration();
        result = result * 59 + ($marginConfiguration == null ? 43 : ((Object)$marginConfiguration).hashCode());
        BorderConfiguration $borderConfiguration = this.getBorderConfiguration();
        result = result * 59 + ($borderConfiguration == null ? 43 : ((Object)$borderConfiguration).hashCode());
        PagingEvent $pagingEvent = this.getPagingEvent();
        result = result * 59 + ($pagingEvent == null ? 43 : $pagingEvent.hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        HorizontalAlignment $contentHorizontalAlignment = this.getContentHorizontalAlignment();
        result = result * 59 + ($contentHorizontalAlignment == null ? 43 : ((Object)((Object)$contentHorizontalAlignment)).hashCode());
        VerticalAlignment $contentVerticalAlignment = this.getContentVerticalAlignment();
        result = result * 59 + ($contentVerticalAlignment == null ? 43 : ((Object)((Object)$contentVerticalAlignment)).hashCode());
        return result;
    }
}

