/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.component.AbstractPageHeaderOrFooter;
import org.dromara.pdf.pdfbox.core.component.AbstractPagingEvent;
import org.dromara.pdf.pdfbox.core.component.BorderInfo;
import org.dromara.pdf.pdfbox.core.component.Component;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class DefaultContainerPagingEvent
extends AbstractPagingEvent {
    @Override
    public void before(Component component) {
        Context context = component.getContext();
        BorderInfo info = context.getBorderInfo();
        Float beginY = info.getBeginY();
        if (!info.getIsAlreadyRendered().booleanValue()) {
            Float height = info.getHeight();
            float bottom = context.getPageFooterHeight() + context.getPage().getMarginBottom().floatValue();
            info.setHeight(Float.valueOf(Math.abs(beginY.floatValue() - bottom)));
            Boolean isBorderTop = info.getIsBorderTop();
            Boolean isBorderBottom = info.getIsBorderBottom();
            if (info.getIsPagingBorder().booleanValue()) {
                info.setIsBorderTop(Boolean.TRUE);
                info.setIsBorderBottom(Boolean.TRUE);
            } else {
                if (info.isPaging()) {
                    info.setIsBorderTop(Boolean.FALSE);
                }
                info.setIsBorderBottom(Boolean.FALSE);
            }
            PDRectangle rectangle = new PDRectangle(info.getBeginX().floatValue(), beginY.floatValue() - info.getHeight().floatValue(), info.getWidth().floatValue(), info.getHeight().floatValue());
            if (!context.getIsVirtualRender().booleanValue()) {
                switch (context.getExecutingComponentType()) {
                    case CONTAINER: 
                    case TABLE: {
                        CommonUtil.addBackgroundColor(info.getContext(), info.getContentMode(), info.getIsResetContentStream(), rectangle, info.getBackgroundColor());
                        break;
                    }
                }
                BorderUtil.drawBorderWithData(info, rectangle);
            }
            info.setIsBorderTop(isBorderTop);
            info.setIsBorderBottom(isBorderBottom);
            info.setHeight(Float.valueOf(height.floatValue() - info.getHeight().floatValue()));
            info.pagingCount();
        }
        context.setIsAlreadyPaging(false);
    }

    @Override
    public void after(Component component) {
        Context context = component.getContext();
        context.resetCursor();
        BorderInfo borderInfo = context.getBorderInfo();
        borderInfo.setBeginY(Float.valueOf(context.getCursor().getY().floatValue() - Optional.ofNullable(context.getPageHeader()).map(AbstractPageHeaderOrFooter::getHeight).orElse(Float.valueOf(0.0f)).floatValue()));
        borderInfo.setIsAlreadyRendered(false);
        context.setIsAlreadyPaging(true);
    }

    @Generated
    public DefaultContainerPagingEvent() {
    }

    @Generated
    public String toString() {
        return "DefaultContainerPagingEvent()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultContainerPagingEvent)) {
            return false;
        }
        DefaultContainerPagingEvent other = (DefaultContainerPagingEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultContainerPagingEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

