/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.dromara.pdf.pdfbox.core.base.AbstractBase;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.Watermark;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class ImageWatermark
extends AbstractBase
implements Watermark {
    protected Float beginX;
    protected Float beginY;
    protected PDImageXObject image;
    protected Integer width;
    protected Integer height;
    protected Integer lines;
    protected Integer countOfLine;
    protected Float leading;
    protected Float spacingOfLine;
    protected Float alpha;

    public ImageWatermark(Document document) {
        super.setContext(document.getContext());
    }

    public void setWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("the width can not be less than 1");
        }
        this.width = width;
    }

    public void setHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("the height can not be less than 1");
        }
        this.height = height;
    }

    public void setImage(File file) {
        Objects.requireNonNull(file, "the image file can not be null");
        this.setImage(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public void setImage(BufferedImage image) {
        Objects.requireNonNull(image, "the image can not be null");
        this.setImage(ImageUtil.toBytes(image, ImageType.PNG.getType()));
    }

    public void setImage(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "the image input stream can not be null");
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)outputStream);
            this.setImage(outputStream.toByteArray());
        }
    }

    public void setImage(byte[] bytes) {
        Objects.requireNonNull(bytes, "the image bytes can not be null");
        this.image = PDImageXObject.createFromByteArray((PDDocument)this.getContext().getTargetDocument(), (byte[])ImageUtil.resetBytes(bytes), (String)"unknown");
    }

    @Override
    public ComponentType getType() {
        return ComponentType.WATERMARK;
    }

    @Override
    public void render(Page page) {
        Objects.requireNonNull(page, "the page can not be null");
        this.init(page);
        this.renderImage(page);
    }

    @Override
    public void render(Document document) {
        Objects.requireNonNull(document, "the document can not be null");
        document.getPages().forEach(this::render);
    }

    protected void init(Page page) {
        Objects.requireNonNull(this.image, "the image can not be null");
        super.init(page);
        if (Objects.isNull((Object)this.getContext().getExecutingComponentType())) {
            this.getContext().setExecutingComponentType(this.getType());
        }
        if (Objects.isNull(this.width)) {
            this.width = this.image.getWidth();
        }
        if (Objects.isNull(this.height)) {
            this.height = this.image.getHeight();
        }
        if (Objects.isNull(this.lines)) {
            this.lines = 1;
        }
        if (Objects.isNull(this.countOfLine)) {
            this.countOfLine = 1;
        }
        if (Objects.isNull(this.leading)) {
            this.leading = Float.valueOf(this.height.intValue());
        }
        if (Objects.isNull(this.spacingOfLine)) {
            this.spacingOfLine = Float.valueOf(this.width.intValue());
        }
        if (Objects.isNull(this.alpha)) {
            this.alpha = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.beginX)) {
            this.beginX = Float.valueOf((float)(-this.width.intValue()) / 2.0f);
        }
        if (Objects.isNull(this.beginY)) {
            this.beginY = Float.valueOf(page.getHeight().floatValue() - (float)(this.height / 2));
        }
    }

    protected void renderImage(Page page) {
        float beginX = this.getBeginX().floatValue();
        float beginY = this.getBeginY().floatValue();
        for (int i = 0; i < this.getLines(); ++i) {
            for (int j = 0; j < this.getCountOfLine(); ++j) {
                this.writeImage(page, beginX, beginY);
                beginX = beginX + (float)this.getWidth().intValue() + this.getSpacingOfLine().floatValue();
            }
            beginX = this.getBeginX().floatValue();
            beginY = beginY - (float)this.getHeight().intValue() - this.getLeading().floatValue();
        }
    }

    protected void writeImage(Page page, float beginX, float beginY) {
        PDPageContentStream stream = new PDPageContentStream(this.getContext().getTargetDocument(), page.getTarget(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
        PDExtendedGraphicsState state = new PDExtendedGraphicsState();
        state.setNonStrokingAlphaConstant(this.getAlpha());
        stream.setGraphicsStateParameters(state);
        stream.drawImage(this.getImage(), beginX, beginY, (float)this.getWidth().intValue(), (float)this.getHeight().intValue());
        stream.close();
    }

    @Generated
    public Float getBeginX() {
        return this.beginX;
    }

    @Generated
    public Float getBeginY() {
        return this.beginY;
    }

    @Generated
    public PDImageXObject getImage() {
        return this.image;
    }

    @Generated
    public Integer getWidth() {
        return this.width;
    }

    @Generated
    public Integer getHeight() {
        return this.height;
    }

    @Generated
    public Integer getLines() {
        return this.lines;
    }

    @Generated
    public Integer getCountOfLine() {
        return this.countOfLine;
    }

    @Generated
    public Float getLeading() {
        return this.leading;
    }

    @Generated
    public Float getSpacingOfLine() {
        return this.spacingOfLine;
    }

    @Generated
    public Float getAlpha() {
        return this.alpha;
    }

    @Generated
    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    @Generated
    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    @Generated
    public void setLines(Integer lines) {
        this.lines = lines;
    }

    @Generated
    public void setCountOfLine(Integer countOfLine) {
        this.countOfLine = countOfLine;
    }

    @Generated
    public void setLeading(Float leading) {
        this.leading = leading;
    }

    @Generated
    public void setSpacingOfLine(Float spacingOfLine) {
        this.spacingOfLine = spacingOfLine;
    }

    @Generated
    public void setAlpha(Float alpha) {
        this.alpha = alpha;
    }

    @Override
    @Generated
    public String toString() {
        return "ImageWatermark(beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", image=" + this.getImage() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", lines=" + this.getLines() + ", countOfLine=" + this.getCountOfLine() + ", leading=" + this.getLeading() + ", spacingOfLine=" + this.getSpacingOfLine() + ", alpha=" + this.getAlpha() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageWatermark)) {
            return false;
        }
        ImageWatermark other = (ImageWatermark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$lines = this.getLines();
        Integer other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        Integer this$countOfLine = this.getCountOfLine();
        Integer other$countOfLine = other.getCountOfLine();
        if (this$countOfLine == null ? other$countOfLine != null : !((Object)this$countOfLine).equals(other$countOfLine)) {
            return false;
        }
        Float this$leading = this.getLeading();
        Float other$leading = other.getLeading();
        if (this$leading == null ? other$leading != null : !((Object)this$leading).equals(other$leading)) {
            return false;
        }
        Float this$spacingOfLine = this.getSpacingOfLine();
        Float other$spacingOfLine = other.getSpacingOfLine();
        if (this$spacingOfLine == null ? other$spacingOfLine != null : !((Object)this$spacingOfLine).equals(other$spacingOfLine)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        PDImageXObject this$image = this.getImage();
        PDImageXObject other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImageWatermark;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        Integer $countOfLine = this.getCountOfLine();
        result = result * 59 + ($countOfLine == null ? 43 : ((Object)$countOfLine).hashCode());
        Float $leading = this.getLeading();
        result = result * 59 + ($leading == null ? 43 : ((Object)$leading).hashCode());
        Float $spacingOfLine = this.getSpacingOfLine();
        result = result * 59 + ($spacingOfLine == null ? 43 : ((Object)$spacingOfLine).hashCode());
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        PDImageXObject $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }
}

