/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.base.config.BorderConfiguration;
import org.dromara.pdf.pdfbox.core.component.AbstractTableHeaderOrFooter;
import org.dromara.pdf.pdfbox.core.component.Table;
import org.dromara.pdf.pdfbox.core.component.TableCell;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;

public class TableRow
extends BorderData {
    protected Color backgroundColor;
    protected Table table;
    protected Page page;
    protected Integer index;
    protected TableRow previous;
    protected TableRow next;
    protected List<TableCell> cells;
    protected Float height;
    protected Float beginX;
    protected Float beginY;
    protected Boolean isBreak;
    protected Boolean isTogether;
    protected Boolean isPagingBorder;
    protected Float contentMarginTop;
    protected Float contentMarginBottom;
    protected Float contentMarginLeft;
    protected Float contentMarginRight;
    protected HorizontalAlignment contentHorizontalAlignment;
    protected VerticalAlignment contentVerticalAlignment;

    public TableRow(Table table) {
        this.table = table;
        this.borderConfiguration = new BorderConfiguration(false);
    }

    public void setContentMargin(float margin) {
        this.contentMarginTop = Float.valueOf(margin);
        this.contentMarginBottom = Float.valueOf(margin);
        this.contentMarginLeft = Float.valueOf(margin);
        this.contentMarginRight = Float.valueOf(margin);
    }

    public void setHeight(float height) {
        if (height <= 0.0f) {
            throw new IllegalArgumentException("height must be positive");
        }
        this.height = Float.valueOf(height);
    }

    public void setCells(List<TableCell> cells) {
        this.cells = cells;
    }

    public void setCells(TableCell ... cells) {
        if (Objects.nonNull(cells)) {
            this.cells = new ArrayList<TableCell>(cells.length);
            Collections.addAll(this.cells, cells);
        } else {
            this.cells = null;
        }
    }

    public void addCells(List<TableCell> cells) {
        if (Objects.nonNull(cells)) {
            if (Objects.isNull(this.cells)) {
                this.cells = new ArrayList<TableCell>(cells);
            } else {
                this.cells.addAll(cells);
            }
        }
    }

    public void addCells(TableCell ... cells) {
        if (Objects.nonNull(cells)) {
            if (Objects.isNull(this.cells)) {
                this.cells = new ArrayList<TableCell>(Math.max(cells.length, 8));
            }
            Collections.addAll(this.cells, cells);
        }
    }

    public Float getWidth() {
        if (Objects.isNull(this.cells)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)this.cells.stream().mapToDouble(TableCell::getWidth).sum());
    }

    protected void virtualRender(Page page, Float beginX, Float beginY) {
        this.init(page, beginX, beginY);
        if (Objects.nonNull(this.getCells())) {
            List<Float> cellWidths = this.getTable().getCellWidths();
            int index = 0;
            for (TableCell tableCell : this.getCells()) {
                if (Objects.nonNull(tableCell)) {
                    tableCell.virtualRender(beginX, beginY);
                }
                beginX = Float.valueOf(beginX.floatValue() + cellWidths.get(index).floatValue());
                ++index;
            }
        }
    }

    protected void render(Page page, Float beginX, Float beginY) {
        this.init(page, beginX, beginY);
        if (Objects.nonNull(this.getCells())) {
            List<Float> cellWidths = this.getTable().getCellWidths();
            int index = 0;
            for (TableCell tableCell : this.getCells()) {
                if (Objects.nonNull(tableCell)) {
                    tableCell.render(beginX, this.getBeginY());
                }
                beginX = Float.valueOf(beginX.floatValue() + cellWidths.get(index).floatValue());
                ++index;
            }
        }
    }

    protected PagingEvent getPagingEvent() {
        return this.table.getPagingEvent();
    }

    protected void init(Page page, Float beginX, Float beginY) {
        Objects.requireNonNull(this.height, "the row height can not be null");
        this.page = page;
        this.beginX = beginX;
        this.beginY = beginY;
        if (Objects.isNull(this.backgroundColor)) {
            this.backgroundColor = this.table.getBackgroundColor();
        }
        if (Objects.isNull(this.isBreak)) {
            this.isBreak = Boolean.FALSE;
        }
        if (Objects.isNull(this.isTogether)) {
            this.isTogether = this.table.getIsTogether();
        }
        if (Objects.isNull(this.isPagingBorder)) {
            this.isPagingBorder = this.table.getIsPagingBorder();
        }
        if (Objects.isNull(this.contentMarginTop)) {
            this.contentMarginTop = this.table.getContentMarginTop();
        }
        if (Objects.isNull(this.contentMarginBottom)) {
            this.contentMarginBottom = this.table.getContentMarginBottom();
        }
        if (Objects.isNull(this.contentMarginLeft)) {
            this.contentMarginLeft = this.table.getContentMarginLeft();
        }
        if (Objects.isNull(this.contentMarginRight)) {
            this.contentMarginRight = this.table.getContentMarginRight();
        }
        if (Objects.isNull((Object)this.contentHorizontalAlignment)) {
            this.contentHorizontalAlignment = this.table.getContentHorizontalAlignment();
        }
        if (Objects.isNull((Object)this.contentVerticalAlignment)) {
            this.contentVerticalAlignment = this.table.getContentVerticalAlignment();
        }
        this.initBorder();
        this.initCells();
        this.checkTogether();
        this.checkBreak();
    }

    protected void initForHeaderOrFooter(AbstractTableHeaderOrFooter headerOrFooter) {
        if (Objects.isNull(this.backgroundColor)) {
            this.backgroundColor = headerOrFooter.getBackgroundColor();
        }
        if (Objects.isNull(this.isBreak)) {
            this.isBreak = headerOrFooter.getIsBreak();
        }
        if (Objects.isNull(this.isTogether)) {
            this.isTogether = headerOrFooter.getIsTogether();
        }
        if (Objects.isNull(this.isPagingBorder)) {
            this.isPagingBorder = headerOrFooter.getIsPagingBorder();
        }
        if (Objects.isNull(this.contentMarginTop)) {
            this.contentMarginTop = headerOrFooter.getContentMarginTop();
        }
        if (Objects.isNull(this.contentMarginBottom)) {
            this.contentMarginBottom = headerOrFooter.getContentMarginBottom();
        }
        if (Objects.isNull(this.contentMarginLeft)) {
            this.contentMarginLeft = headerOrFooter.getContentMarginLeft();
        }
        if (Objects.isNull(this.contentMarginRight)) {
            this.contentMarginRight = headerOrFooter.getContentMarginRight();
        }
        if (Objects.isNull((Object)this.contentHorizontalAlignment)) {
            this.contentHorizontalAlignment = headerOrFooter.getContentHorizontalAlignment();
        }
        if (Objects.isNull((Object)this.contentVerticalAlignment)) {
            this.contentVerticalAlignment = headerOrFooter.getContentVerticalAlignment();
        }
        super.init(this.table, headerOrFooter.getBorderConfiguration());
    }

    protected void initBorder() {
        super.init(this.table, this.table.getBorderConfiguration());
    }

    protected void initCells() {
        if (Objects.nonNull(this.cells)) {
            int index = 0;
            for (TableCell tableCell : this.cells) {
                if (Objects.nonNull(tableCell)) {
                    tableCell.setIndex(index);
                } else {
                    this.isTogether = false;
                }
                ++index;
            }
        }
    }

    protected void checkTogether() {
        if (this.isTogether.booleanValue() && !this.isBreak.booleanValue()) {
            this.isBreak = this.beginY.floatValue() - this.height.floatValue() < this.table.getBottom();
        }
    }

    protected void checkBreak() {
        if (this.isBreak.booleanValue()) {
            this.getContext().setIsAlreadyPaging(false);
            this.getContext().setIsManualBreak(true);
            this.table.processBreak();
            this.getContext().setIsManualBreak(false);
            this.page = this.getContext().getPage();
            this.beginY = this.getContext().getCursor().getY();
        }
    }

    @Generated
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public Table getTable() {
        return this.table;
    }

    @Generated
    public Page getPage() {
        return this.page;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public TableRow getPrevious() {
        return this.previous;
    }

    @Generated
    public TableRow getNext() {
        return this.next;
    }

    @Generated
    public List<TableCell> getCells() {
        return this.cells;
    }

    @Generated
    public Float getHeight() {
        return this.height;
    }

    @Generated
    public Float getBeginX() {
        return this.beginX;
    }

    @Generated
    public Float getBeginY() {
        return this.beginY;
    }

    @Generated
    public Boolean getIsBreak() {
        return this.isBreak;
    }

    @Generated
    public Boolean getIsTogether() {
        return this.isTogether;
    }

    @Generated
    public Boolean getIsPagingBorder() {
        return this.isPagingBorder;
    }

    @Generated
    public Float getContentMarginTop() {
        return this.contentMarginTop;
    }

    @Generated
    public Float getContentMarginBottom() {
        return this.contentMarginBottom;
    }

    @Generated
    public Float getContentMarginLeft() {
        return this.contentMarginLeft;
    }

    @Generated
    public Float getContentMarginRight() {
        return this.contentMarginRight;
    }

    @Generated
    public HorizontalAlignment getContentHorizontalAlignment() {
        return this.contentHorizontalAlignment;
    }

    @Generated
    public VerticalAlignment getContentVerticalAlignment() {
        return this.contentVerticalAlignment;
    }

    @Generated
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Generated
    public void setTable(Table table) {
        this.table = table;
    }

    @Generated
    public void setPage(Page page) {
        this.page = page;
    }

    @Generated
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Generated
    public void setPrevious(TableRow previous) {
        this.previous = previous;
    }

    @Generated
    public void setNext(TableRow next) {
        this.next = next;
    }

    @Generated
    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    @Generated
    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    @Generated
    public void setIsBreak(Boolean isBreak) {
        this.isBreak = isBreak;
    }

    @Generated
    public void setIsTogether(Boolean isTogether) {
        this.isTogether = isTogether;
    }

    @Generated
    public void setIsPagingBorder(Boolean isPagingBorder) {
        this.isPagingBorder = isPagingBorder;
    }

    @Generated
    public void setContentMarginTop(Float contentMarginTop) {
        this.contentMarginTop = contentMarginTop;
    }

    @Generated
    public void setContentMarginBottom(Float contentMarginBottom) {
        this.contentMarginBottom = contentMarginBottom;
    }

    @Generated
    public void setContentMarginLeft(Float contentMarginLeft) {
        this.contentMarginLeft = contentMarginLeft;
    }

    @Generated
    public void setContentMarginRight(Float contentMarginRight) {
        this.contentMarginRight = contentMarginRight;
    }

    @Generated
    public void setContentHorizontalAlignment(HorizontalAlignment contentHorizontalAlignment) {
        this.contentHorizontalAlignment = contentHorizontalAlignment;
    }

    @Generated
    public void setContentVerticalAlignment(VerticalAlignment contentVerticalAlignment) {
        this.contentVerticalAlignment = contentVerticalAlignment;
    }

    @Override
    @Generated
    public String toString() {
        return "TableRow(backgroundColor=" + this.getBackgroundColor() + ", table=" + this.getTable() + ", page=" + this.getPage() + ", index=" + this.getIndex() + ", previous=" + this.getPrevious() + ", next=" + this.getNext() + ", cells=" + this.getCells() + ", height=" + this.getHeight() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", isBreak=" + this.getIsBreak() + ", isTogether=" + this.getIsTogether() + ", isPagingBorder=" + this.getIsPagingBorder() + ", contentMarginTop=" + this.getContentMarginTop() + ", contentMarginBottom=" + this.getContentMarginBottom() + ", contentMarginLeft=" + this.getContentMarginLeft() + ", contentMarginRight=" + this.getContentMarginRight() + ", contentHorizontalAlignment=" + (Object)((Object)this.getContentHorizontalAlignment()) + ", contentVerticalAlignment=" + (Object)((Object)this.getContentVerticalAlignment()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableRow)) {
            return false;
        }
        TableRow other = (TableRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Boolean this$isBreak = this.getIsBreak();
        Boolean other$isBreak = other.getIsBreak();
        if (this$isBreak == null ? other$isBreak != null : !((Object)this$isBreak).equals(other$isBreak)) {
            return false;
        }
        Boolean this$isTogether = this.getIsTogether();
        Boolean other$isTogether = other.getIsTogether();
        if (this$isTogether == null ? other$isTogether != null : !((Object)this$isTogether).equals(other$isTogether)) {
            return false;
        }
        Boolean this$isPagingBorder = this.getIsPagingBorder();
        Boolean other$isPagingBorder = other.getIsPagingBorder();
        if (this$isPagingBorder == null ? other$isPagingBorder != null : !((Object)this$isPagingBorder).equals(other$isPagingBorder)) {
            return false;
        }
        Float this$contentMarginTop = this.getContentMarginTop();
        Float other$contentMarginTop = other.getContentMarginTop();
        if (this$contentMarginTop == null ? other$contentMarginTop != null : !((Object)this$contentMarginTop).equals(other$contentMarginTop)) {
            return false;
        }
        Float this$contentMarginBottom = this.getContentMarginBottom();
        Float other$contentMarginBottom = other.getContentMarginBottom();
        if (this$contentMarginBottom == null ? other$contentMarginBottom != null : !((Object)this$contentMarginBottom).equals(other$contentMarginBottom)) {
            return false;
        }
        Float this$contentMarginLeft = this.getContentMarginLeft();
        Float other$contentMarginLeft = other.getContentMarginLeft();
        if (this$contentMarginLeft == null ? other$contentMarginLeft != null : !((Object)this$contentMarginLeft).equals(other$contentMarginLeft)) {
            return false;
        }
        Float this$contentMarginRight = this.getContentMarginRight();
        Float other$contentMarginRight = other.getContentMarginRight();
        if (this$contentMarginRight == null ? other$contentMarginRight != null : !((Object)this$contentMarginRight).equals(other$contentMarginRight)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Table this$table = this.getTable();
        Table other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        Page this$page = this.getPage();
        Page other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        TableRow this$previous = this.getPrevious();
        TableRow other$previous = other.getPrevious();
        if (this$previous == null ? other$previous != null : !((Object)this$previous).equals(other$previous)) {
            return false;
        }
        TableRow this$next = this.getNext();
        TableRow other$next = other.getNext();
        if (this$next == null ? other$next != null : !((Object)this$next).equals(other$next)) {
            return false;
        }
        List<TableCell> this$cells = this.getCells();
        List<TableCell> other$cells = other.getCells();
        if (this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells)) {
            return false;
        }
        HorizontalAlignment this$contentHorizontalAlignment = this.getContentHorizontalAlignment();
        HorizontalAlignment other$contentHorizontalAlignment = other.getContentHorizontalAlignment();
        if (this$contentHorizontalAlignment == null ? other$contentHorizontalAlignment != null : !((Object)((Object)this$contentHorizontalAlignment)).equals((Object)other$contentHorizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$contentVerticalAlignment = this.getContentVerticalAlignment();
        VerticalAlignment other$contentVerticalAlignment = other.getContentVerticalAlignment();
        return !(this$contentVerticalAlignment == null ? other$contentVerticalAlignment != null : !((Object)((Object)this$contentVerticalAlignment)).equals((Object)other$contentVerticalAlignment));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableRow;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Boolean $isBreak = this.getIsBreak();
        result = result * 59 + ($isBreak == null ? 43 : ((Object)$isBreak).hashCode());
        Boolean $isTogether = this.getIsTogether();
        result = result * 59 + ($isTogether == null ? 43 : ((Object)$isTogether).hashCode());
        Boolean $isPagingBorder = this.getIsPagingBorder();
        result = result * 59 + ($isPagingBorder == null ? 43 : ((Object)$isPagingBorder).hashCode());
        Float $contentMarginTop = this.getContentMarginTop();
        result = result * 59 + ($contentMarginTop == null ? 43 : ((Object)$contentMarginTop).hashCode());
        Float $contentMarginBottom = this.getContentMarginBottom();
        result = result * 59 + ($contentMarginBottom == null ? 43 : ((Object)$contentMarginBottom).hashCode());
        Float $contentMarginLeft = this.getContentMarginLeft();
        result = result * 59 + ($contentMarginLeft == null ? 43 : ((Object)$contentMarginLeft).hashCode());
        Float $contentMarginRight = this.getContentMarginRight();
        result = result * 59 + ($contentMarginRight == null ? 43 : ((Object)$contentMarginRight).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Table $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        Page $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        TableRow $previous = this.getPrevious();
        result = result * 59 + ($previous == null ? 43 : ((Object)$previous).hashCode());
        TableRow $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        List<TableCell> $cells = this.getCells();
        result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
        HorizontalAlignment $contentHorizontalAlignment = this.getContentHorizontalAlignment();
        result = result * 59 + ($contentHorizontalAlignment == null ? 43 : ((Object)((Object)$contentHorizontalAlignment)).hashCode());
        VerticalAlignment $contentVerticalAlignment = this.getContentVerticalAlignment();
        result = result * 59 + ($contentVerticalAlignment == null ? 43 : ((Object)((Object)$contentVerticalAlignment)).hashCode());
        return result;
    }
}

