/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.analyzer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitRectangleDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractAnalyzer;
import org.dromara.pdf.pdfbox.core.info.BookmarkInfo;
import org.dromara.pdf.pdfbox.util.ColorUtil;

public abstract class AbstractBookmarkAnalyzer
extends AbstractAnalyzer {
    protected final Set<BookmarkInfo> infoSet = new HashSet<BookmarkInfo>(16);

    public AbstractBookmarkAnalyzer(Document document) {
        super(document);
    }

    public abstract void processOutlineItem(int ... var1);

    protected List<PDOutlineItem> toOutlineItemList(Iterable<PDOutlineItem> itemIterable) {
        ArrayList<PDOutlineItem> list = new ArrayList<PDOutlineItem>(16);
        if (Objects.nonNull(itemIterable)) {
            itemIterable.forEach(list::add);
        }
        return list;
    }

    protected void processOutlineItem(Set<BookmarkInfo> set, PDDocumentCatalog documentCatalog, PDOutlineItem outlineItem) {
        if (Objects.isNull(outlineItem)) {
            return;
        }
        PDDestination destination = this.processDestination(outlineItem);
        if (Objects.isNull(destination)) {
            return;
        }
        BookmarkInfo bookmarkInfo = this.processPageDestination(outlineItem, destination);
        if (Objects.isNull(bookmarkInfo)) {
            return;
        }
        bookmarkInfo.setChildren(this.processOutlineItemChildren(documentCatalog, outlineItem));
        set.add(bookmarkInfo);
        bookmarkInfo = this.processNamedDestination(documentCatalog, destination);
        if (Objects.isNull(bookmarkInfo)) {
            return;
        }
        bookmarkInfo.setChildren(this.processOutlineItemChildren(documentCatalog, outlineItem));
        set.add(bookmarkInfo);
        this.processBookmarkInfo(set);
    }

    protected Set<BookmarkInfo> processOutlineItemChildren(PDDocumentCatalog documentCatalog, PDOutlineItem outlineItem) {
        if (outlineItem.hasChildren()) {
            HashSet<BookmarkInfo> children = new HashSet<BookmarkInfo>(64);
            Iterable items = outlineItem.children();
            for (PDOutlineItem item : items) {
                this.processOutlineItem(children, documentCatalog, item);
            }
            return children;
        }
        return null;
    }

    protected PDDestination processDestination(PDOutlineItem outlineItem) {
        PDAction action;
        PDDestination destination = outlineItem.getDestination();
        if (Objects.isNull(destination) && (action = outlineItem.getAction()) instanceof PDActionGoTo) {
            destination = ((PDActionGoTo)action).getDestination();
        }
        return destination;
    }

    protected BookmarkInfo processPageDestination(PDOutlineItem outlineItem, PDDestination destination) {
        if (destination instanceof PDPageDestination) {
            BookmarkInfo info = BookmarkInfo.builder().build();
            if (destination instanceof PDPageXYZDestination) {
                PDPageXYZDestination xyzDestination = (PDPageXYZDestination)destination;
                info.setTitle(outlineItem.getTitle());
                info.setColor(ColorUtil.toColor(outlineItem.getTextColor()));
                info.setIsBold(outlineItem.isBold());
                info.setIsItalic(outlineItem.isItalic());
                info.setIsOpen(outlineItem.isNodeOpen());
                info.setBeginPageIndex(xyzDestination.retrievePageNumber());
                info.setBeginPageTopY(xyzDestination.getTop());
                return info;
            }
            if (destination instanceof PDPageFitWidthDestination) {
                PDPageFitWidthDestination xyzDestination = (PDPageFitWidthDestination)destination;
                info.setBeginPageIndex(xyzDestination.retrievePageNumber());
                info.setBeginPageTopY(xyzDestination.getTop());
                return info;
            }
            if (destination instanceof PDPageFitRectangleDestination) {
                PDPageFitRectangleDestination xyzDestination = (PDPageFitRectangleDestination)destination;
                info.setBeginPageIndex(xyzDestination.retrievePageNumber());
                info.setBeginPageTopY(xyzDestination.getTop());
                return info;
            }
            return info;
        }
        return null;
    }

    protected BookmarkInfo processNamedDestination(PDDocumentCatalog documentCatalog, PDDestination destination) {
        if (destination instanceof PDNamedDestination) {
            BookmarkInfo info = BookmarkInfo.builder().build();
            PDPageDestination pageDestination = documentCatalog.findNamedDestinationPage((PDNamedDestination)destination);
            if (Objects.nonNull(pageDestination)) {
                info.setBeginPageIndex(pageDestination.retrievePageNumber());
            }
            return info;
        }
        return null;
    }

    protected void processBookmarkInfo(Set<BookmarkInfo> set) {
        ArrayList<BookmarkInfo> list = new ArrayList<BookmarkInfo>(set);
        if (!list.isEmpty()) {
            PDPageTree pages = this.getDocument().getPages();
            int maxIndex = list.size() - 1;
            if (maxIndex == 0) {
                BookmarkInfo bookmarkInfo = (BookmarkInfo)list.get(0);
                bookmarkInfo.setEndPageIndex(0);
                bookmarkInfo.setBeginPageTopY((int)pages.get(bookmarkInfo.getBeginPageIndex().intValue()).getMediaBox().getHeight());
                bookmarkInfo.setBeginPageBottomY(0);
                bookmarkInfo.setEndPageTopY(bookmarkInfo.getBeginPageTopY());
                bookmarkInfo.setEndPageBottomY(0);
            } else {
                for (int i = 0; i <= maxIndex; ++i) {
                    BookmarkInfo current = (BookmarkInfo)list.get(i);
                    if (i == maxIndex) {
                        current.setBeginPageBottomY(0);
                        current.setEndPageIndex(pages.getCount() - 1);
                        current.setEndPageTopY((int)pages.get(current.getEndPageIndex().intValue()).getMediaBox().getHeight());
                        current.setEndPageBottomY(0);
                    } else {
                        BookmarkInfo next = (BookmarkInfo)list.get(i + 1);
                        if (current.getBeginPageIndex().equals(next.getBeginPageIndex())) {
                            current.setBeginPageBottomY(next.getBeginPageTopY());
                            current.setEndPageIndex(current.getBeginPageIndex());
                            current.setEndPageTopY(current.getBeginPageTopY());
                            current.setEndPageBottomY(current.getBeginPageBottomY());
                        } else {
                            current.setBeginPageBottomY(0);
                            current.setEndPageIndex(next.getBeginPageIndex());
                            current.setEndPageTopY((int)pages.get(current.getEndPageIndex().intValue()).getMediaBox().getHeight());
                            current.setEndPageBottomY(next.getBeginPageTopY());
                        }
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("\n********************************************ANALYZE BOOKMARK BEGIN********************************************\ntitle: " + current.getTitle() + "\ncolor: " + current.getColor() + "\nbold: " + current.getIsBold() + "\nitalic: " + current.getIsItalic() + "\nopen: " + current.getIsOpen() + "\nbegin page index: " + current.getBeginPageIndex() + "\nend page index: " + current.getEndPageIndex() + "\nbegin page top y: " + current.getBeginPageTopY() + "\nbegin page bottom y: " + current.getBeginPageBottomY() + "\nend page top y: " + current.getEndPageTopY() + "\nend page bottom y: " + current.getEndPageBottomY() + "\n*********************************************ANALYZE BOOKMARK END*********************************************"));
                }
            }
        }
    }

    @Generated
    public Set<BookmarkInfo> getInfoSet() {
        return this.infoSet;
    }
}

