/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.analyzer;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFreeText;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractAnalyzer;
import org.dromara.pdf.pdfbox.core.info.CommentInfo;

public abstract class AbstractCommentAnalyzer
extends AbstractAnalyzer {
    protected final Set<CommentInfo> infoSet = new HashSet<CommentInfo>(64);

    public AbstractCommentAnalyzer(Document document) {
        super(document);
    }

    public abstract void processComment(int var1, PDPage var2);

    protected void processComment(int pageIndex, PDPage page, PDAnnotation annotation) {
        String content;
        if ((annotation instanceof PDAnnotationText || annotation instanceof PDAnnotationFreeText) && Objects.nonNull(content = annotation.getContents()) && !content.trim().isEmpty()) {
            PDRectangle pageRectangle = page.getMediaBox();
            PDRectangle commentRectangle = annotation.getRectangle();
            String[] fontInfo = this.getFontInfo(annotation);
            String fontName = fontInfo[1];
            String fontSize = fontInfo[2];
            CommentInfo info = CommentInfo.builder().pageIndex(pageIndex).pageWidth(Float.valueOf(pageRectangle.getWidth())).pageHeight(Float.valueOf(pageRectangle.getHeight())).fontName(fontName).fontSize(Float.valueOf(fontSize.substring(0, fontSize.indexOf("pt")))).textContent(content).textBeginPosition(commentRectangle.getLowerLeftX() + "," + commentRectangle.getLowerLeftY()).textEndPosition(commentRectangle.getUpperRightX() + "," + commentRectangle.getUpperRightY()).textWidth(Float.valueOf(commentRectangle.getWidth())).textHeight(Float.valueOf(commentRectangle.getHeight())).isHidden(annotation.isHidden()).isInvisible(annotation.isInvisible()).isLocked(annotation.isLocked()).isLockedContents(annotation.isLockedContents()).isNoRotate(annotation.isNoRotate()).isNoView(annotation.isNoView()).isNoZoom(annotation.isNoZoom()).isPrinted(annotation.isPrinted()).isReadOnly(annotation.isReadOnly()).isToggleNoView(annotation.isToggleNoView()).build();
            this.infoSet.add(info);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\n********************************************ANALYZE COMMENT BEGIN********************************************\npage index: " + info.getPageIndex() + "\npage width: " + info.getPageWidth() + "\npage height: " + info.getPageHeight() + "\ncomment font name: " + info.getFontName() + "\ncomment font size: " + info.getFontSize() + "\ncomment content: " + info.getTextContent() + "\ncomment begin position: " + info.getTextBeginPosition() + "\ncomment end position: " + info.getTextEndPosition() + "\ncomment width: " + info.getTextWidth() + "\ncomment height: " + info.getTextHeight() + "\ncomment is hidden: " + info.getIsHidden() + "\ncomment is invisible: " + info.getIsInvisible() + "\ncomment is locked: " + info.getIsLocked() + "\ncomment is locked contents: " + info.getIsLockedContents() + "\ncomment is no rotate: " + info.getIsNoRotate() + "\ncomment is no view: " + info.getIsNoView() + "\ncomment is no zoom: " + info.getIsNoZoom() + "\ncomment is printed: " + info.getIsPrinted() + "\ncomment is readOnly: " + info.getIsReadOnly() + "\n*********************************************ANALYZE COMMENT END*********************************************"));
            }
        }
    }

    protected String[] getFontInfo(PDAnnotation annotation) {
        return annotation.getCOSObject().getString(COSName.DS).split(";")[0].split(" ");
    }

    @Generated
    public Set<CommentInfo> getInfoSet() {
        return this.infoSet;
    }
}

