/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.convertor;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IConverter;
import com.documents4j.conversion.msoffice.MicrosoftPowerpointBridge;
import com.documents4j.job.LocalConverter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.AbstractExpander;
import org.dromara.pdf.pdfbox.handler.PdfHandler;

public abstract class AbstractConvertor
extends AbstractExpander {
    protected static final IConverter CONVERTER = LocalConverter.builder().enable(MicrosoftPowerpointBridge.class).processTimeout(60L, TimeUnit.SECONDS).build();

    public AbstractConvertor(Document document) {
        super(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document toPdf(DocumentType type, String source) {
        Document document;
        Objects.requireNonNull(source, "the source can not be null");
        InputStream inputStream = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(source);
            if (Objects.isNull(inputStream)) {
                inputStream = Files.newInputStream(Paths.get(source, new String[0]), new OpenOption[0]);
            }
            document = this.toPdf(type, inputStream);
        }
        catch (Throwable throwable) {
            if (Objects.nonNull(inputStream)) {
                inputStream.close();
            }
            throw throwable;
        }
        if (Objects.nonNull(inputStream)) {
            inputStream.close();
        }
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document toPdf(DocumentType type, InputStream source) {
        Objects.requireNonNull(type, "the type can not be null");
        Objects.requireNonNull(source, "the source can not be null");
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            boolean executed = CONVERTER.convert(source).as(type).to((OutputStream)outputStream).as(DocumentType.PDF).execute();
            if (executed) {
                Document document = PdfHandler.getDocumentHandler().load(outputStream.toByteArray());
                return document;
            }
            throw new RuntimeException("convert fail");
        }
    }

    protected boolean toFile(DocumentType type, OutputStream output) {
        Objects.requireNonNull(type, "the type can not be null");
        Objects.requireNonNull(output, "the output can not be null");
        File tempFile = this.document.getTempFile();
        boolean executed = CONVERTER.convert(tempFile).as(DocumentType.PDF).to(output).as(type).execute();
        if (Objects.nonNull(tempFile)) {
            tempFile.delete();
        }
        return executed;
    }
}

