/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.handler;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.component.TextLineInfo;
import org.dromara.pdf.pdfbox.core.ext.AbstractExpander;
import org.dromara.pdf.pdfbox.support.Constants;

public abstract class AbstractTextHandler
extends AbstractExpander {
    public AbstractTextHandler(Document document) {
        super(document);
    }

    public abstract void writeText(FontConfiguration var1, PDPageContentStream var2, TextLineInfo var3);

    public TextLineInfo splitText(FontConfiguration fontConfiguration, String text, float lineWidth) {
        if (Objects.isNull(text) || text.isEmpty() || this.getTextWidth(fontConfiguration, String.valueOf(text.charAt(0))) > lineWidth) {
            return null;
        }
        float lastWidth = 0.0f;
        float width = 0.0f;
        int fontCount = Math.max(1, (int)(lineWidth / (fontConfiguration.getFontSize().floatValue() + fontConfiguration.getCharacterSpacing().floatValue())));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            String tempText = text.substring(beginIndex, i);
            width = this.getTextWidth(fontConfiguration, tempText);
            if (width > lineWidth) {
                return new TextLineInfo(text.substring(beginIndex, i - 1), Float.valueOf(lastWidth));
            }
            lastWidth = width;
        }
        if (width == 0.0f) {
            width = this.getTextWidth(fontConfiguration, text);
        }
        return new TextLineInfo(text, Float.valueOf(width));
    }

    public List<TextLineInfo> splitLines(FontConfiguration fontConfiguration, String text, float lineWidth) {
        String tempText;
        if (Objects.isNull(text) || text.isEmpty() || this.getTextWidth(fontConfiguration, String.valueOf(text.charAt(0))) > lineWidth) {
            return new ArrayList<TextLineInfo>(0);
        }
        LinkedList<TextLineInfo> lineList = new LinkedList<TextLineInfo>();
        float lastWidth = 0.0f;
        float width = 0.0f;
        int fontCount = Math.max(1, (int)(lineWidth / (fontConfiguration.getFontSize().floatValue() + fontConfiguration.getCharacterSpacing().floatValue())));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            tempText = text.substring(beginIndex, i);
            width = this.getTextWidth(fontConfiguration, tempText);
            if (width > lineWidth) {
                lineList.add(new TextLineInfo(text.substring(beginIndex, i - 1), Float.valueOf(lastWidth)));
                beginIndex = i - 1;
                i = i + fontCount - 1;
                if (i < len) continue;
                lineList.add(new TextLineInfo(text.substring(beginIndex), Float.valueOf(width)));
                continue;
            }
            lastWidth = width;
        }
        if (beginIndex + fontCount < text.length() || lineList.isEmpty()) {
            tempText = text.substring(beginIndex);
            if (width == 0.0f) {
                width = this.getTextWidth(fontConfiguration, tempText);
            }
            lineList.add(new TextLineInfo(tempText, Float.valueOf(width)));
        }
        return lineList;
    }

    public float getTextWidth(FontConfiguration fontConfiguration, String text) {
        if (Objects.isNull(text)) {
            return 0.0f;
        }
        List<String> specialFontNames = fontConfiguration.getSpecialFontNames();
        PDFont font = this.getContext().getFont(fontConfiguration.getFontName());
        Float fontSize = fontConfiguration.getFontSize();
        Float characterSpacing = fontConfiguration.getCharacterSpacing();
        float width = 0.0f;
        char[] charArray = text.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char character = charArray[i];
            try {
                width += font.getCharacterWidth(Character.valueOf(character));
                continue;
            }
            catch (Exception e) {
                boolean flag = true;
                if (Objects.nonNull(specialFontNames)) {
                    for (String specialFontName : specialFontNames) {
                        try {
                            width += this.getContext().getFont(specialFontName).getCharacterWidth(Character.valueOf(character));
                            flag = false;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                    if (flag && i + 1 < charArray.length) {
                        char next = charArray[i + 1];
                        String str = String.valueOf(new char[]{character, next});
                        for (String specialFontName : specialFontNames) {
                            try {
                                width += this.getContext().getFont(specialFontName).getStringWidth(str);
                                flag = false;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                        if (!flag) {
                            ++i;
                        }
                    }
                }
                if (!flag) continue;
                width += this.getContext().getFont("HarmonyOS Sans SC").getCharacterWidth(Constants.DEFAULT_UNKNOWN_CHARACTER);
            }
        }
        return width == 0.0f ? 0.0f : fontSize.floatValue() * width / 1000.0f + (float)(text.length() - 1) * characterSpacing.floatValue();
    }

    public float getTextHeight(FontConfiguration fontConfiguration, int rowCount) {
        if (rowCount == 0) {
            return 0.0f;
        }
        if (rowCount == 1) {
            return fontConfiguration.getFontSize().floatValue();
        }
        int leadingCount = rowCount - 1;
        return (float)rowCount * fontConfiguration.getFontSize().floatValue() + (float)leadingCount * fontConfiguration.getLeading().floatValue();
    }

    protected Context getContext() {
        return this.document.getContext();
    }

    @Generated
    public String toString() {
        return "AbstractTextHandler()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTextHandler)) {
            return false;
        }
        AbstractTextHandler other = (AbstractTextHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTextHandler;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

