/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.parser.ai;

import com.alibaba.fastjson2.JSONObject;
import java.security.MessageDigest;
import java.util.List;
import okhttp3.Headers;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.parser.ai.AIParseInfo;
import org.dromara.pdf.pdfbox.core.ext.parser.ai.AbstractAIParser;

public class KunLunWanWeiAIParser
extends AbstractAIParser {
    private static final MessageDigest DIGEST = KunLunWanWeiAIParser.initDigest();

    public KunLunWanWeiAIParser(Document document, String ak, String sk, boolean isJsonResponse) {
        super(document, ak, sk, isJsonResponse);
        this.config.setTextUrl("https://api-maas.singularity-ai.com/sky-work/api/v1/chat");
    }

    private static MessageDigest initDigest() {
        return MessageDigest.getInstance("MD5");
    }

    @Override
    public AIParseInfo parsePageWithImage(String prompt, int pageIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AIParseInfo parseImageWithPage(String prompt, int pageIndex, int imageIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Headers getRequestHeaders() {
        long timestamp = System.currentTimeMillis() / 1000L;
        return new Headers.Builder().add("app_key", this.config.getAk()).add("sign", this.getSign(timestamp)).add("timestamp", String.valueOf(timestamp)).build();
    }

    @Override
    protected JSONObject getRequestBody(String model, List<AbstractAIParser.Message> messages) {
        JSONObject jsonBody = JSONObject.of((String)"messages", messages).fluentPut("intent", (Object)"chat");
        if (this.config.isJsonResponse()) {
            jsonBody.fluentPut("response_format ", (Object)JSONObject.of((String)"type", (Object)"json_object"));
        }
        return jsonBody;
    }

    @Override
    protected JSONObject getResponse(String url, String model, List<AbstractAIParser.Message> messages) {
        JSONObject response = super.getResponse(url, model, messages);
        if (response.containsKey("code")) {
            throw new RuntimeException(response.toString());
        }
        return response;
    }

    protected String getSign(long timestamp) {
        String data = this.config.getAk() + this.config.getSk() + timestamp;
        byte[] messageDigest = DIGEST.digest(data.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : messageDigest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

