/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.core.info.ReplaceInfo;
import org.dromara.pdf.pdfbox.util.ImageUtil;
import org.dromara.pdf.pdfbox.util.TextTokenUtil;

public class ReplaceProcessor
extends AbstractProcessor {
    public ReplaceProcessor(Document document) {
        super(document);
    }

    public void replaceText(PDFont font, Map<String, String> replaceMap, int ... pageIndexes) {
        Objects.requireNonNull(font, "the font can not be null");
        Objects.requireNonNull(replaceMap, "the replace map not be null");
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes)) {
            for (int pageIndex : pageIndexes) {
                this.replaceText(pageTree.get(pageIndex), font, replaceMap);
            }
        } else {
            for (PDPage page : pageTree) {
                this.replaceText(page, font, replaceMap);
            }
        }
    }

    public void replaceText(List<ReplaceInfo> replaceList, int ... pageIndexes) {
        Objects.requireNonNull(replaceList, "the replace list can not be null");
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes)) {
            for (int pageIndex : pageIndexes) {
                this.replaceText(pageTree.get(pageIndex), replaceList);
            }
        } else {
            for (PDPage page : pageTree) {
                this.replaceText(page, replaceList);
            }
        }
    }

    public void replaceComment(Map<String, String> replaceMap, int ... pageIndexes) {
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes)) {
            for (int pageIndex : pageIndexes) {
                this.replaceComment(pageTree.get(pageIndex), replaceMap);
            }
        } else {
            for (PDPage page : pageTree) {
                this.replaceComment(page, replaceMap);
            }
        }
    }

    public void replaceImage(BufferedImage image, List<Integer> pageIndexes, int ... imageIndexes) {
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes)) {
            for (int pageIndex : pageIndexes) {
                this.replaceImage(pageTree.get(pageIndex), image, imageIndexes);
            }
        } else {
            for (PDPage page : pageTree) {
                this.replaceImage(page, image, imageIndexes);
            }
        }
    }

    public void replaceBookmark(Map<String, String> replaceMap, int ... bookmarkIndexes) {
        block7: {
            PDDocumentCatalog documentCatalog = this.getDocument().getDocumentCatalog();
            PDDocumentOutline documentOutline = documentCatalog.getDocumentOutline();
            if (!Objects.nonNull(documentOutline)) break block7;
            int index = 0;
            Iterable items = documentOutline.children();
            if (Objects.nonNull(bookmarkIndexes) && bookmarkIndexes.length > 0) {
                PrimitiveIterator.OfInt iterator = Arrays.stream(bookmarkIndexes).sorted().iterator();
                int bookmarkIndex = 0;
                for (PDOutlineItem outlineItem : items) {
                    if (index < bookmarkIndex) {
                        ++index;
                        continue;
                    }
                    if (iterator.hasNext()) {
                        bookmarkIndex = iterator.next();
                        if (index == bookmarkIndex) {
                            this.replaceBookmark(outlineItem, replaceMap);
                        }
                        ++index;
                        continue;
                    }
                    break;
                }
            } else {
                for (PDOutlineItem outlineItem : items) {
                    this.replaceBookmark(outlineItem, replaceMap);
                    ++index;
                }
            }
        }
    }

    protected void replaceText(PDPage page, PDFont font, Map<String, String> replaceMap) {
        PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
        List tokens = parser.parse();
        if (TextTokenUtil.replaceTextForToken(this.log, this.getDocument(), page.getResources(), (List<Object>)tokens, font, replaceMap)) {
            this.updateContents(page, tokens);
        }
    }

    protected void replaceText(PDPage page, List<ReplaceInfo> replaceList) {
        HashMap<Character, Integer> replaceIndexMap = new HashMap<Character, Integer>(replaceList.size());
        replaceList.forEach(info -> replaceIndexMap.put(info.getOriginal(), 0));
        PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
        List tokens = parser.parse();
        if (TextTokenUtil.replaceTextForToken(this.log, this.getDocument(), page.getResources(), (List<Object>)tokens, replaceList, replaceIndexMap)) {
            this.updateContents(page, tokens);
        }
    }

    protected void replaceComment(PDPage page, Map<String, String> replaceMap) {
        List pdAnnotations = page.getAnnotations();
        for (PDAnnotation annotation : pdAnnotations) {
            PDAnnotationText text;
            String comment;
            String replaceString;
            if (!(annotation instanceof PDAnnotationText) || Objects.equals(replaceString = this.getReplaceString(comment = (text = (PDAnnotationText)annotation).getContents(), replaceMap), comment)) continue;
            text.setContents(replaceString);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Replaced comment: original [\"" + comment + "\"], now [\"" + replaceString + "\"]"));
        }
    }

    protected void replaceImage(PDPage page, BufferedImage image, int ... imageIndexes) {
        block8: {
            PDImageXObject imageObject = null;
            if (Objects.nonNull(image)) {
                imageObject = PDImageXObject.createFromByteArray((PDDocument)this.getDocument(), (byte[])ImageUtil.toBytes(image, ImageType.PNG.getType()), (String)ImageType.PNG.getType());
            }
            PDResources resources = page.getResources();
            Iterable objectNames = resources.getXObjectNames();
            if (Objects.isNull(imageIndexes) || imageIndexes.length == 0) {
                for (COSName cosName : objectNames) {
                    if (!(resources.getXObject(cosName) instanceof PDImage)) continue;
                    resources.put(cosName, (PDXObject)imageObject);
                }
                break block8;
            }
            PrimitiveIterator.OfInt iterator = Arrays.stream(imageIndexes).sorted().iterator();
            int index = 0;
            int replaceIndex = (Integer)iterator.next();
            for (COSName cosName : objectNames) {
                if (!(resources.getXObject(cosName) instanceof PDImage)) continue;
                if (index == replaceIndex) {
                    resources.put(cosName, (PDXObject)imageObject);
                    if (!iterator.hasNext()) break;
                    replaceIndex = (Integer)iterator.next();
                }
                ++index;
            }
        }
    }

    protected void replaceBookmark(PDOutlineItem outlineItem, Map<String, String> replaceMap) {
        String title = this.getReplaceString(outlineItem.getTitle(), replaceMap);
        if (Objects.nonNull(title)) {
            outlineItem.setTitle(title);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Replaced bookmark: original [\"" + outlineItem.getTitle() + "\"], now [\"" + title + "\"]"));
            }
        }
        Iterable children = outlineItem.children();
        for (PDOutlineItem child : children) {
            this.replaceBookmark(child, replaceMap);
        }
    }

    protected String getReplaceString(String content, Map<String, String> replaceMap) {
        if (Objects.isNull(content)) {
            return null;
        }
        if (!content.trim().isEmpty()) {
            for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                Matcher matcher = Pattern.compile(entry.getKey(), 16).matcher(content);
                if (!matcher.find()) continue;
                content = matcher.replaceAll(entry.getValue());
            }
        }
        return content;
    }

    protected void updateContents(PDPage page, List<Object> tokens) {
        PDStream updatedStream = new PDStream(this.getDocument());
        try (OutputStream outputStream = updatedStream.createOutputStream(COSName.FLATE_DECODE);){
            ContentStreamWriter tokenWriter = new ContentStreamWriter(outputStream);
            tokenWriter.writeTokens(tokens);
            page.setContents(updatedStream);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceProcessor)) {
            return false;
        }
        ReplaceProcessor other = (ReplaceProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReplaceProcessor;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

