/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.form;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.Size;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;

public abstract class AbstractFormFieldBuilder {
    protected Document document;
    protected Page page;
    protected Size size;
    protected HorizontalAlignment alignment;
    protected String name;
    protected Boolean isReadonly;
    protected Boolean isRequired;
    protected Boolean isNoExport;

    public AbstractFormFieldBuilder(Document document, Page page, Size size) {
        Objects.requireNonNull(document, "the document can not be null");
        Objects.requireNonNull(page, "the page can not be null");
        Objects.requireNonNull(size, "the size can not be null");
        this.document = document;
        this.page = page;
        this.size = size;
    }

    public abstract PDField build(PDAcroForm var1);

    protected void initProperties(PDField field) {
        Objects.requireNonNull(this.name, "the name can not be null");
        field.setPartialName(this.name);
        Optional.ofNullable(this.isReadonly).ifPresent(arg_0 -> ((PDField)field).setReadOnly(arg_0));
        Optional.ofNullable(this.isRequired).ifPresent(arg_0 -> ((PDField)field).setRequired(arg_0));
        Optional.ofNullable(this.isNoExport).ifPresent(arg_0 -> ((PDField)field).setNoExport(arg_0));
    }

    protected void initSize(PDField field) {
        PDAnnotationWidget widget = (PDAnnotationWidget)field.getWidgets().get(0);
        widget.setRectangle(this.size.getRectangle());
        widget.setPage(this.page.getTarget());
        widget.setPrinted(true);
        this.page.getTarget().getAnnotations().add(widget);
    }

    @Generated
    public void setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setIsReadonly(Boolean isReadonly) {
        this.isReadonly = isReadonly;
    }

    @Generated
    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Generated
    public void setIsNoExport(Boolean isNoExport) {
        this.isNoExport = isNoExport;
    }
}

