/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.sign;

import java.awt.image.BufferedImage;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;

public class VisualOptions {
    private BufferedImage image;
    private Float imageMarginLeft;
    private Float imageMarginTop;
    private Float imageScalePercent;

    protected void initVisualOptions(PDDocument document, PDSignature signature, SignatureOptions signatureOptions) {
        PDVisibleSigProperties signatureProperty = new PDVisibleSigProperties();
        PDVisibleSignDesigner designer = new PDVisibleSignDesigner(document, this.image, signatureOptions.getPage() + 1);
        designer.zoom(this.imageScalePercent.floatValue());
        designer.xAxis(this.imageMarginLeft.floatValue());
        designer.yAxis(this.imageMarginTop.floatValue());
        designer.adjustForRotation();
        signatureProperty.signerName(signature.getName()).signerLocation(signature.getLocation()).signatureReason(signature.getReason()).page(signatureOptions.getPage() + 1).visualSignEnabled(true).setPdVisibleSignature(designer).buildSignature();
        signatureOptions.setVisualSignature(signatureProperty);
    }

    @Generated
    VisualOptions(BufferedImage image, Float imageMarginLeft, Float imageMarginTop, Float imageScalePercent) {
        this.image = image;
        this.imageMarginLeft = imageMarginLeft;
        this.imageMarginTop = imageMarginTop;
        this.imageScalePercent = imageScalePercent;
    }

    @Generated
    public static VisualOptionsBuilder builder() {
        return new VisualOptionsBuilder();
    }

    @Generated
    public BufferedImage getImage() {
        return this.image;
    }

    @Generated
    public Float getImageMarginLeft() {
        return this.imageMarginLeft;
    }

    @Generated
    public Float getImageMarginTop() {
        return this.imageMarginTop;
    }

    @Generated
    public Float getImageScalePercent() {
        return this.imageScalePercent;
    }

    @Generated
    public void setImage(BufferedImage image) {
        this.image = image;
    }

    @Generated
    public void setImageMarginLeft(Float imageMarginLeft) {
        this.imageMarginLeft = imageMarginLeft;
    }

    @Generated
    public void setImageMarginTop(Float imageMarginTop) {
        this.imageMarginTop = imageMarginTop;
    }

    @Generated
    public void setImageScalePercent(Float imageScalePercent) {
        this.imageScalePercent = imageScalePercent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VisualOptions)) {
            return false;
        }
        VisualOptions other = (VisualOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$imageMarginLeft = this.getImageMarginLeft();
        Float other$imageMarginLeft = other.getImageMarginLeft();
        if (this$imageMarginLeft == null ? other$imageMarginLeft != null : !((Object)this$imageMarginLeft).equals(other$imageMarginLeft)) {
            return false;
        }
        Float this$imageMarginTop = this.getImageMarginTop();
        Float other$imageMarginTop = other.getImageMarginTop();
        if (this$imageMarginTop == null ? other$imageMarginTop != null : !((Object)this$imageMarginTop).equals(other$imageMarginTop)) {
            return false;
        }
        Float this$imageScalePercent = this.getImageScalePercent();
        Float other$imageScalePercent = other.getImageScalePercent();
        if (this$imageScalePercent == null ? other$imageScalePercent != null : !((Object)this$imageScalePercent).equals(other$imageScalePercent)) {
            return false;
        }
        BufferedImage this$image = this.getImage();
        BufferedImage other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VisualOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $imageMarginLeft = this.getImageMarginLeft();
        result = result * 59 + ($imageMarginLeft == null ? 43 : ((Object)$imageMarginLeft).hashCode());
        Float $imageMarginTop = this.getImageMarginTop();
        result = result * 59 + ($imageMarginTop == null ? 43 : ((Object)$imageMarginTop).hashCode());
        Float $imageScalePercent = this.getImageScalePercent();
        result = result * 59 + ($imageScalePercent == null ? 43 : ((Object)$imageScalePercent).hashCode());
        BufferedImage $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "VisualOptions(image=" + this.getImage() + ", imageMarginLeft=" + this.getImageMarginLeft() + ", imageMarginTop=" + this.getImageMarginTop() + ", imageScalePercent=" + this.getImageScalePercent() + ")";
    }

    @Generated
    public static class VisualOptionsBuilder {
        @Generated
        private BufferedImage image;
        @Generated
        private Float imageMarginLeft;
        @Generated
        private Float imageMarginTop;
        @Generated
        private Float imageScalePercent;

        @Generated
        VisualOptionsBuilder() {
        }

        @Generated
        public VisualOptionsBuilder image(BufferedImage image) {
            this.image = image;
            return this;
        }

        @Generated
        public VisualOptionsBuilder imageMarginLeft(Float imageMarginLeft) {
            this.imageMarginLeft = imageMarginLeft;
            return this;
        }

        @Generated
        public VisualOptionsBuilder imageMarginTop(Float imageMarginTop) {
            this.imageMarginTop = imageMarginTop;
            return this;
        }

        @Generated
        public VisualOptionsBuilder imageScalePercent(Float imageScalePercent) {
            this.imageScalePercent = imageScalePercent;
            return this;
        }

        @Generated
        public VisualOptions build() {
            return new VisualOptions(this.image, this.imageMarginLeft, this.imageMarginTop, this.imageScalePercent);
        }

        @Generated
        public String toString() {
            return "VisualOptions.VisualOptionsBuilder(image=" + this.image + ", imageMarginLeft=" + this.imageMarginLeft + ", imageMarginTop=" + this.imageMarginTop + ", imageScalePercent=" + this.imageScalePercent + ")";
        }
    }
}

