/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.pdfbox.support.linearizer.BitWriter;
import org.dromara.pdf.pdfbox.support.linearizer.CHPageOffset;
import org.dromara.pdf.pdfbox.support.linearizer.IO;
import org.dromara.pdf.pdfbox.support.linearizer.ObjUser;
import org.dromara.pdf.pdfbox.support.linearizer.PDFObjectQueue;
import org.dromara.pdf.pdfbox.support.linearizer.StructuredPDFInfo;

class HPageOffset {
    final List<HPageOffsetEntry> entries = new ArrayList<HPageOffsetEntry>();
    int min_nobjects = 0;
    long first_page_offset = 0L;
    int nbits_delta_nobjects = 0;
    int min_page_length = 0;
    int nbits_delta_page_length = 0;
    int min_content_offset = 0;
    int nbits_delta_content_offset = 0;
    int min_content_length = 0;
    int nbits_delta_content_length = 0;
    int nbits_nshared_objects = 0;
    int nbits_shared_identifier = 0;
    int nbits_shared_numerator = 0;
    int shared_denominator = 0;

    private HPageOffset(int pages) {
        for (int i = 0; i < pages; ++i) {
            this.entries.add(new HPageOffsetEntry());
        }
    }

    static HPageOffset filledPageOffsetHints(StructuredPDFInfo info, PDFObjectQueue queue, long lin_dict_offset, int pageCount) {
        int i;
        int min_nobjects = Integer.MAX_VALUE;
        int max_nobjects = Integer.MIN_VALUE;
        long min_length = Integer.MAX_VALUE;
        long max_length = Integer.MIN_VALUE;
        int max_shared = Integer.MIN_VALUE;
        HPageOffset pageOffsetHints = new HPageOffset(pageCount);
        for (i = 0; i < pageCount; ++i) {
            ObjUser ou = new ObjUser(ObjUser.user_e.ou_page, i);
            long length = 0L;
            List<COSBase> ogs = info.userObjectMap.getT1ValuesForKey(ou);
            for (COSBase cOSBase : ogs) {
                length += queue.get((COSBase)cOSBase).objLength;
            }
            CHPageOffset.CHPageOffsetEntry entry = info.pageOffsetData.entries.get(i);
            if (entry.nshared_objects > 0) {
                for (int sharedObjId : entry.shared_identifiers) {
                    length -= queue.get((COSBase)info.indexObjectMap.getValueForT1((Integer)Integer.valueOf((int)sharedObjId))).objLength;
                }
            }
            int n = entry.nobjects;
            int nshared = entry.nshared_objects;
            min_nobjects = Math.min(min_nobjects, n);
            max_nobjects = Math.max(max_nobjects, n);
            min_length = Math.min(min_length, length);
            max_length = Math.max(max_length, length);
            max_shared = Math.max(max_shared, nshared);
            pageOffsetHints.entries.get((int)i).delta_nobjects = n;
            pageOffsetHints.entries.get((int)i).delta_page_length = length;
            pageOffsetHints.entries.get((int)i).nshared_objects = nshared;
        }
        pageOffsetHints.min_nobjects = min_nobjects;
        pageOffsetHints.first_page_offset = lin_dict_offset;
        pageOffsetHints.nbits_delta_nobjects = IO.nbits(max_nobjects - min_nobjects);
        pageOffsetHints.min_page_length = (int)min_length;
        pageOffsetHints.nbits_delta_page_length = IO.nbits((int)max_length - (int)min_length);
        pageOffsetHints.nbits_nshared_objects = IO.nbits(max_shared);
        pageOffsetHints.nbits_shared_identifier = IO.nbits(info.sharedObjectData.nshared_total);
        pageOffsetHints.shared_denominator = 4;
        pageOffsetHints.nbits_delta_content_length = pageOffsetHints.nbits_delta_page_length;
        pageOffsetHints.min_content_length = pageOffsetHints.min_page_length;
        for (i = 0; i < pageCount; ++i) {
            pageOffsetHints.entries.get((int)i).delta_nobjects -= min_nobjects;
            pageOffsetHints.entries.get((int)i).delta_page_length -= min_length;
            pageOffsetHints.entries.get((int)i).delta_content_length = pageOffsetHints.entries.get((int)i).delta_page_length;
            CHPageOffset.CHPageOffsetEntry entry = info.pageOffsetData.entries.get(i);
            for (int j = 0; j < entry.nshared_objects; ++j) {
                pageOffsetHints.entries.get((int)i).shared_identifiers.add(entry.shared_identifiers.get(j));
                pageOffsetHints.entries.get((int)i).shared_numerators.add(0);
            }
        }
        return pageOffsetHints;
    }

    void writeHPageOffset(BitWriter w) throws IOException {
        w.writeBits(this.min_nobjects, 32);
        w.writeBits(this.first_page_offset, 32);
        w.writeBits(this.nbits_delta_nobjects, 16);
        w.writeBits(this.min_page_length, 32);
        w.writeBits(this.nbits_delta_page_length, 16);
        w.writeBits(this.min_content_offset, 32);
        w.writeBits(this.nbits_delta_content_offset, 16);
        w.writeBits(this.min_content_length, 32);
        w.writeBits(this.nbits_delta_content_length, 16);
        w.writeBits(this.nbits_nshared_objects, 16);
        w.writeBits(this.nbits_shared_identifier, 16);
        w.writeBits(this.nbits_shared_numerator, 16);
        w.writeBits(this.shared_denominator, 16);
        for (HPageOffsetEntry en : this.entries) {
            w.writeBits(en.delta_nobjects, this.nbits_delta_nobjects);
        }
        w.flush();
        for (HPageOffsetEntry en : this.entries) {
            w.writeBits(en.delta_page_length, this.nbits_delta_page_length);
        }
        w.flush();
        for (HPageOffsetEntry en : this.entries) {
            w.writeBits(en.nshared_objects, this.nbits_nshared_objects);
        }
        w.flush();
        for (HPageOffsetEntry en : this.entries) {
            for (Integer ele : en.shared_identifiers) {
                w.writeBits(ele.intValue(), this.nbits_shared_identifier);
            }
        }
        w.flush();
        for (HPageOffsetEntry en : this.entries) {
            for (Integer ele : en.shared_numerators) {
                w.writeBits(ele.intValue(), this.nbits_shared_numerator);
            }
        }
        w.flush();
        for (HPageOffsetEntry en : this.entries) {
            w.writeBits(en.delta_content_offset, this.nbits_delta_content_offset);
        }
        w.flush();
        for (HPageOffsetEntry en : this.entries) {
            w.writeBits(en.delta_content_length, this.nbits_delta_content_length);
        }
        w.flush();
    }

    class HPageOffsetEntry {
        int delta_nobjects = 0;
        long delta_page_length = 0L;
        int nshared_objects = 0;
        List<Integer> shared_identifiers = new ArrayList<Integer>();
        List<Integer> shared_numerators = new ArrayList<Integer>();
        long delta_content_offset = 0L;
        long delta_content_length = 0L;

        private HPageOffsetEntry() {
        }
    }
}

