/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import com.alibaba.fastjson2.JSONObject;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpUtil {
    public static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    public static final OkHttpClient CLIENT = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).callTimeout(60L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject request(OkHttpClient client, String url, Headers headers, String jsonBody) {
        Request request = new Request.Builder().url(url).headers(headers).post(RequestBody.create((String)jsonBody, (MediaType)MEDIA_TYPE)).build();
        try (Response response = client.newCall(request).execute();){
            ResponseBody body = response.body();
            if (Objects.nonNull(body)) {
                JSONObject jSONObject = JSONObject.parseObject((String)body.string());
                return jSONObject;
            }
            throw new RuntimeException("ai request fail");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject request(OkHttpClient client, String url, Headers headers, RequestBody formBody) {
        Request request = new Request.Builder().url(url).headers(headers).post(formBody).build();
        try (Response response = client.newCall(request).execute();){
            ResponseBody body = response.body();
            if (Objects.nonNull(body)) {
                JSONObject jSONObject = JSONObject.parseObject((String)body.string());
                return jSONObject;
            }
            throw new RuntimeException("ai request fail");
        }
    }
}

