/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.info.ReplaceInfo;
import org.dromara.pdf.pdfbox.core.info.TextTokenInfo;
import org.dromara.pdf.pdfbox.handler.PdfHandler;

public class TextTokenUtil {
    public static final Map<Character, Boolean> EN_CHARACTERS = TextTokenUtil.initEnCharacters();

    public static boolean replaceTextForToken(Log log, PDDocument document, PDResources resources, List<Object> tokens, List<ReplaceInfo> replaceList, Map<Character, Integer> replaceIndexMap) {
        boolean result = false;
        List<TextTokenInfo> infoList = TextTokenUtil.initTextTokenInfoListForCharacter(log, resources, tokens, replaceList, replaceIndexMap);
        for (TextTokenInfo info : infoList) {
            if (!info.getIsReplace().booleanValue()) continue;
            PDFont font = info.getReplaceFont();
            for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), textValue.getValue());
            }
            tokens.set(info.getFontIndex(), COSName.getPDFName((String)font.getName()));
            result = true;
        }
        return result;
    }

    public static boolean replaceTextForToken(Log log, PDDocument document, PDResources resources, List<Object> tokens, PDFont font, Map<String, String> replaceMap) {
        boolean normalResult = TextTokenUtil.tryReplaceTextForNormal(log, document, resources, tokens, font, replaceMap);
        boolean specialResult = TextTokenUtil.tryReplaceTextForSpecial(log, document, resources, tokens, font, replaceMap);
        return normalResult || specialResult;
    }

    public static boolean tryReplaceTextForNormal(Log log, PDDocument document, PDResources resources, List<Object> tokens, PDFont font, Map<String, String> replaceMap) {
        boolean result = false;
        boolean processFlag = false;
        List<TextTokenInfo> infoList = TextTokenUtil.initTextTokenInfoListForString(resources, tokens);
        for (TextTokenInfo info : infoList) {
            block3: for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                String originalText = textValue.getReplaceValue();
                if (Objects.isNull(originalText)) continue;
                String replaceText = originalText;
                for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                    if (!replaceText.contains(entry.getKey())) continue;
                    replaceText = replaceText.replace(entry.getKey(), entry.getValue());
                    TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), replaceText);
                    textValue.setIsEmbedSubset(true);
                    if (Objects.nonNull(textValue.getChildren())) {
                        for (TextTokenInfo.TextValue child : textValue.getChildren()) {
                            TextTokenUtil.processReplaceText(document, resources, font, child.getToken(), "");
                            child.setIsEmbedSubset(true);
                        }
                    }
                    result = true;
                    processFlag = true;
                    if (!log.isDebugEnabled()) continue block3;
                    log.debug((Object)("Replaced normal text: original [\"" + originalText + "\"], now [\"" + replaceText + "\"]"));
                    continue block3;
                }
            }
            if (!processFlag) continue;
            for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                if (!Objects.isNull(textValue.getIsEmbedSubset())) continue;
                TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), textValue.getValue());
            }
            tokens.set(info.getFontIndex(), COSName.getPDFName((String)font.getName()));
        }
        return result;
    }

    public static boolean tryReplaceTextForSpecial(Log log, PDDocument document, PDResources resources, List<Object> tokens, PDFont font, Map<String, String> replaceMap) {
        boolean result = false;
        List<TextTokenInfo> infoList = TextTokenUtil.initTextTokenInfoListForString(resources, tokens);
        for (TextTokenInfo info : infoList) {
            String allText;
            boolean isReplace = false;
            String replaceText = allText = TextTokenUtil.getTextForTokenInfo(info);
            for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                if (!replaceText.contains(entry.getKey())) continue;
                replaceText = replaceText.replace(entry.getKey(), entry.getValue());
                isReplace = true;
                result = true;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Replaced special text: original [\"" + allText + "\"], now [\"" + replaceText + "\"]"));
            }
            if (!isReplace) continue;
            if (info.getTokens().size() == 1) {
                TextTokenUtil.processReplaceText(document, resources, font, info.getTokens().get(0).getToken(), replaceText);
            } else {
                TextTokenUtil.processReplaceText(document, resources, font, tokens, info, replaceText);
            }
            tokens.set(info.getFontIndex(), COSName.getPDFName((String)font.getName()));
        }
        return result;
    }

    public static void processReplaceText(PDDocument document, PDResources resources, PDFont font, List<Object> tokens, TextTokenInfo info, String replaceText) {
        String blank = "";
        if (Objects.equals(replaceText, "")) {
            for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), "");
            }
        } else {
            char[] charArray = replaceText.toCharArray();
            int totalIndex = charArray.length - 1;
            float lastX = -1.0f;
            float lastY = -1.0f;
            int index = 0;
            boolean isFinish = false;
            boolean isEnglish = true;
            for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                Object token;
                if (isFinish) {
                    TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), "");
                    continue;
                }
                char chars = charArray[index];
                TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), String.valueOf(chars));
                boolean bl = isFinish = index == totalIndex;
                if (index == 0) {
                    isEnglish = EN_CHARACTERS.containsKey(Character.valueOf(chars));
                } else if (lastY == textValue.getY().floatValue() && (token = tokens.get(textValue.getIndex() - 1)) instanceof Operator) {
                    Operator operator = (Operator)token;
                    if (operator.getName().equals("TD") || operator.getName().equals("Td")) {
                        float offsetX = ((COSNumber)tokens.get(textValue.getIndex() - 3)).floatValue();
                        if (EN_CHARACTERS.containsKey(Character.valueOf(textValue.getValue().charAt(0)))) {
                            if (EN_CHARACTERS.containsKey(Character.valueOf(chars))) {
                                if (!isEnglish) {
                                    tokens.set(textValue.getIndex() - 3, new COSFloat(offsetX + info.getFontSize().floatValue() * 10.0f));
                                }
                                isEnglish = true;
                            } else {
                                if (isEnglish) {
                                    tokens.set(textValue.getIndex() - 3, new COSFloat(offsetX - info.getFontSize().floatValue()));
                                } else {
                                    tokens.set(textValue.getIndex() - 3, new COSFloat(offsetX + info.getFontSize().floatValue() * 10.0f));
                                }
                                isEnglish = false;
                            }
                        } else if (EN_CHARACTERS.containsKey(Character.valueOf(chars))) {
                            tokens.set(textValue.getIndex() - 3, new COSFloat(offsetX - info.getFontSize().floatValue() * 10.0f));
                        } else {
                            tokens.set(textValue.getIndex() - 3, new COSFloat(offsetX + info.getFontSize().floatValue() * 10.0f));
                        }
                    } else if (operator.getName().equals("Tm")) {
                        float minX;
                        if (EN_CHARACTERS.containsKey(Character.valueOf(chars))) {
                            minX = isEnglish ? lastX + font.getCharacterWidth(Character.valueOf(chars)) * info.getFontSize().floatValue() / 1000.0f : lastX + font.getCharacterWidth(Character.valueOf(chars)) * info.getFontSize().floatValue() / 500.0f;
                            isEnglish = true;
                        } else {
                            minX = isEnglish ? lastX + font.getCharacterWidth(Character.valueOf(chars)) * info.getFontSize().floatValue() / 2000.0f : lastX + font.getCharacterWidth(Character.valueOf(chars)) * info.getFontSize().floatValue() / 1000.0f;
                            isEnglish = false;
                        }
                        if (minX > textValue.getX().floatValue()) {
                            textValue.setX(Float.valueOf(minX));
                            tokens.set(textValue.getMatrixIndex() - 2, new COSFloat(minX));
                        }
                    }
                }
                lastX = textValue.getX().floatValue();
                lastY = textValue.getY().floatValue();
                ++index;
            }
            if (!isFinish) {
                TextTokenUtil.processReplaceText(document, resources, font, info.getTokens().get(info.getTokens().size() - 1).getToken(), replaceText.substring(index - 1));
            }
        }
    }

    public static void processReplaceText(PDDocument document, PDResources resources, PDFont font, Object token, String value) {
        PdfHandler.getFontHandler().addToSubset(document, font, value);
        if (token instanceof COSArray) {
            COSArray array = (COSArray)token;
            array.clear();
            array.add((COSBase)new COSString(font.encode(value)));
        } else {
            COSString cosString = (COSString)token;
            cosString.setValue(font.encode(value));
        }
        COSName replaceFontName = COSName.getPDFName((String)font.getName());
        if (Objects.isNull(resources.getFont(replaceFontName))) {
            resources.put(replaceFontName, font);
        }
    }

    public static List<TextTokenInfo> initTextTokenInfoListForCharacter(Log log, PDResources resources, List<Object> tokens, List<ReplaceInfo> replaceList, Map<Character, Integer> replaceIndexMap) {
        Map<COSName, PDFont> resourceFontMap = TextTokenUtil.initResourceFontMap(resources);
        int matrixIndex = 0;
        float x = 0.0f;
        float y = 0.0f;
        TextTokenInfo tokenInfo = null;
        ArrayList<TextTokenInfo> infoList = new ArrayList<TextTokenInfo>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            Object token = tokens.get(i);
            if (token instanceof Operator) {
                Operator operator = (Operator)token;
                if (operator.getName().equals("Tf")) {
                    int fontIndex = i - 2;
                    float fontSize = ((COSNumber)tokens.get(i - 1)).floatValue() / 20.0f;
                    PDFont resourceFont = resourceFontMap.get(tokens.get(fontIndex));
                    if (!Objects.nonNull(resourceFont)) continue;
                    tokenInfo = new TextTokenInfo(fontIndex, resourceFont, resourceFont, Float.valueOf(fontSize), false, new ArrayList<TextTokenInfo.TextValue>(16));
                    infoList.add(tokenInfo);
                    continue;
                }
                if (!operator.getName().equals("Tm")) continue;
                matrixIndex = i;
                x = ((COSNumber)tokens.get(i - 2)).floatValue();
                y = ((COSNumber)tokens.get(i - 1)).floatValue();
                continue;
            }
            if (!(token instanceof COSArray) && !(token instanceof COSString)) continue;
            TextTokenUtil.initTextTokenInfoTextValue(log, tokenInfo, token, i, matrixIndex, x, y, replaceList, replaceIndexMap);
        }
        return infoList;
    }

    public static List<TextTokenInfo> initTextTokenInfoListForString(PDResources resources, List<Object> tokens) {
        Map<COSName, PDFont> resourceFontMap = TextTokenUtil.initResourceFontMap(resources);
        int matrixIndex = 0;
        float x = 0.0f;
        float y = 0.0f;
        TextTokenInfo tokenInfo = null;
        ArrayList<TextTokenInfo> infoList = new ArrayList<TextTokenInfo>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            Object token = tokens.get(i);
            if (token instanceof Operator) {
                Operator operator = (Operator)token;
                if (operator.getName().equals("Tf")) {
                    int fontIndex = i - 2;
                    float fontSize = ((COSNumber)tokens.get(i - 1)).floatValue() / 20.0f;
                    PDFont resourceFont = resourceFontMap.get(tokens.get(fontIndex));
                    if (!Objects.nonNull(resourceFont)) continue;
                    tokenInfo = new TextTokenInfo(fontIndex, resourceFont, resourceFont, Float.valueOf(fontSize), false, new ArrayList<TextTokenInfo.TextValue>(16));
                    infoList.add(tokenInfo);
                    continue;
                }
                if (!operator.getName().equals("Tm")) continue;
                matrixIndex = i;
                x = ((COSNumber)tokens.get(i - 2)).floatValue();
                y = ((COSNumber)tokens.get(i - 1)).floatValue();
                continue;
            }
            if (!(token instanceof COSArray) && !(token instanceof COSString)) continue;
            String source = TextTokenUtil.getTextForToken(token, tokenInfo.getFont());
            tokenInfo.getTokens().add(new TextTokenInfo.TextValue(i, matrixIndex, Float.valueOf(x), Float.valueOf(y), token, source));
        }
        return infoList;
    }

    public static void initTextTokenInfoTextValue(Log log, TextTokenInfo tokenInfo, Object token, int tokenIndex, int matrixIndex, float x, float y, List<ReplaceInfo> replaceList, Map<Character, Integer> replaceIndexMap) {
        if (Objects.nonNull(tokenInfo)) {
            String source = TextTokenUtil.getTextForToken(token, tokenInfo.getFont());
            StringBuilder newValue = new StringBuilder();
            if (Objects.nonNull(source)) {
                char[] characters;
                boolean blank = false;
                for (char character : characters = source.toCharArray()) {
                    Integer index = replaceIndexMap.get(Character.valueOf(character));
                    if (Objects.nonNull(index)) {
                        for (ReplaceInfo info : replaceList) {
                            if (!Objects.equals(Character.valueOf(character), info.getOriginal())) continue;
                            Set<Integer> indexes = info.getIndexes();
                            if (Objects.nonNull(indexes)) {
                                boolean replaced = false;
                                for (Integer replaceIndex : indexes) {
                                    if (!Objects.equals(index, replaceIndex)) continue;
                                    replaced = true;
                                    tokenInfo.setIsReplace(replaced);
                                    tokenInfo.setReplaceFont(info.getFont());
                                    if (!Objects.equals(Character.valueOf('\u0000'), info.getValue())) {
                                        newValue.append(info.getValue());
                                    }
                                    if (!log.isDebugEnabled()) break;
                                    log.debug((Object)("Replaced character: original ['" + character + "'], now ['" + info.getValue() + "'], index ['" + index + "']"));
                                    break;
                                }
                                if (replaced) continue;
                                newValue.append(character);
                                continue;
                            }
                            tokenInfo.setIsReplace(true);
                            tokenInfo.setReplaceFont(info.getFont());
                            if (!Objects.equals(Character.valueOf('\u0000'), info.getValue())) {
                                newValue.append(info.getValue());
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Replaced character: original ['" + character + "'], now ['" + info.getValue() + "'], index ['" + index + "']"));
                        }
                        replaceIndexMap.put(Character.valueOf(character), index + 1);
                    } else {
                        newValue.append(character);
                    }
                    TextTokenInfo.TextValue tokenValue = new TextTokenInfo.TextValue(tokenIndex, matrixIndex, Float.valueOf(x), Float.valueOf(y), token, newValue.toString());
                    tokenInfo.getTokens().add(tokenValue);
                }
            }
        }
    }

    public static String getTextForToken(Object token, PDFont font) {
        StringBuilder builder = new StringBuilder();
        if (token instanceof COSArray) {
            COSArray array = (COSArray)token;
            for (COSBase cosBase : array) {
                if (cosBase instanceof COSInteger) {
                    COSInteger cosInteger = (COSInteger)cosBase;
                    if (cosInteger.intValue() > -199) continue;
                    builder.append(' ');
                    continue;
                }
                if (cosBase instanceof COSArray) {
                    String value = TextTokenUtil.getTextForToken(cosBase, font);
                    if (!Objects.nonNull(value)) continue;
                    builder.append(value);
                    continue;
                }
                TextTokenUtil.joinString(builder, cosBase, font);
            }
        } else {
            TextTokenUtil.joinString(builder, token, font);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    public static String getTextForTokenInfo(TextTokenInfo info) {
        StringBuilder builder = new StringBuilder();
        for (TextTokenInfo.TextValue textValue : info.getTokens()) {
            String value = textValue.getValue();
            if (!Objects.nonNull(value)) continue;
            builder.append(value);
        }
        return builder.toString();
    }

    public static Map<COSName, PDFont> initResourceFontMap(PDResources resources) {
        HashMap<COSName, PDFont> resourceFontMap = new HashMap<COSName, PDFont>(16);
        if (Objects.nonNull(resources)) {
            for (COSName cosName : resources.getFontNames()) {
                resourceFontMap.put(cosName, resources.getFont(cosName));
            }
        }
        return resourceFontMap;
    }

    public static void joinString(StringBuilder builder, Object token, PDFont font) {
        block15: {
            if (!(token instanceof COSString)) break block15;
            COSString cosString = (COSString)token;
            try (ByteArrayInputStream in = new ByteArrayInputStream(cosString.getBytes());){
                while (((InputStream)in).available() > 0) {
                    String unicode = font.toUnicode(font.readCode(in));
                    if (!Objects.nonNull(unicode)) continue;
                    builder.append(unicode);
                }
            }
        }
    }

    protected static Map<Character, Boolean> initEnCharacters() {
        char[] characters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '+', '-', '*', '/', '=', '_', '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '`', ',', '.', '\'', ';', '[', ']', '{', '}', ':', '\"', '<', '>', '?'};
        HashMap<Character, Boolean> map = new HashMap<Character, Boolean>(characters.length);
        for (char c : characters) {
            map.put(Character.valueOf(c), true);
        }
        return map;
    }
}

