/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class TextUtil {
    public static String splitText(Context context, String text, float lineWidth, PDFont font, float fontSize, float characterSpacing, List<String> specialFontNames) {
        if (TextUtil.isBlank(text) || lineWidth - fontSize < 0.0f) {
            return null;
        }
        int fontCount = Math.max(1, (int)(lineWidth / (fontSize + characterSpacing)));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            String tempText = text.substring(beginIndex, i);
            float lineRealWidth = TextUtil.getTextRealWidth(context, tempText, font, fontSize, characterSpacing, specialFontNames);
            if (!(lineRealWidth > lineWidth)) continue;
            return text.substring(beginIndex, i - 1);
        }
        return text;
    }

    public static List<String> splitLines(Context context, String text, float lineWidth, PDFont font, float fontSize, float characterSpacing, List<String> specialFontNames) {
        if (TextUtil.isBlank(text) || lineWidth - fontSize < 0.0f) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> lineList = new ArrayList<String>(1024);
        int fontCount = Math.max(1, (int)(lineWidth / (fontSize + characterSpacing)));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            String tempText = text.substring(beginIndex, i);
            float lineRealWidth = TextUtil.getTextRealWidth(context, tempText, font, fontSize, characterSpacing, specialFontNames);
            if (!(lineRealWidth > lineWidth)) continue;
            lineList.add(text.substring(beginIndex, i - 1));
            beginIndex = i - 1;
            i = i + fontCount - 1;
            if (i < len) continue;
            lineList.add(text.substring(beginIndex));
        }
        if (beginIndex + fontCount < text.length() || lineList.isEmpty()) {
            lineList.add(text.substring(beginIndex));
        }
        return lineList;
    }

    public static float getTextRealWidth(Context context, String text, PDFont font, float fontSize, float characterSpacing, List<String> specialFontNames) {
        if (Objects.isNull(text)) {
            return 0.0f;
        }
        float width = 0.0f;
        Iterator<Character> iterator = CommonUtil.toCharacterList(text.toCharArray()).iterator();
        while (iterator.hasNext()) {
            Character character = iterator.next();
            String str = String.valueOf(character);
            try {
                width += font.getStringWidth(str);
            }
            catch (Exception e) {
                boolean flag = true;
                if (Objects.nonNull(specialFontNames)) {
                    for (String specialFontName : specialFontNames) {
                        try {
                            width += context.getFont(specialFontName).getStringWidth(str);
                            flag = false;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                    if (flag && iterator.hasNext()) {
                        Character next = iterator.next();
                        char[] array = new char[]{character.charValue(), next.charValue()};
                        str = String.valueOf(array);
                        for (String specialFontName : specialFontNames) {
                            try {
                                width += context.getFont(specialFontName).getStringWidth(str);
                                flag = false;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                }
                if (!flag) continue;
                throw new IllegalArgumentException(e);
            }
        }
        return width == 0.0f ? 0.0f : fontSize * width / 1000.0f + (float)(text.length() - 1) * characterSpacing;
    }

    public static float getTextRealHeight(int rowCount, float fontSize, float leading) {
        if (rowCount == 0) {
            return 0.0f;
        }
        if (rowCount == 1) {
            return fontSize;
        }
        int leadingCount = rowCount - 1;
        return (float)rowCount * fontSize + (float)leadingCount * leading;
    }

    public static String escapeForRegex(String text) {
        char[] charArray;
        if (TextUtil.isBlank(text)) {
            return "";
        }
        char[] escapeChars = new char[]{'$', '(', ')', '*', '+', '.', '[', ']', '?', '\\', '^', '{', '}', '|'};
        StringBuilder builder = new StringBuilder();
        for (char c : charArray = text.toCharArray()) {
            for (char escapeChar : escapeChars) {
                if (escapeChar != c) continue;
                builder.append('\\');
                break;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String filterAll(String text) {
        return text.replaceAll("[\r\b\f]", "");
    }

    public static String replaceAll(String text, Map<String, String> replaceMap) {
        if (TextUtil.isBlank(text)) {
            return "";
        }
        if (Objects.isNull(replaceMap) || replaceMap.isEmpty()) {
            return text;
        }
        String temp = text;
        Set<Map.Entry<String, String>> entrySet = replaceMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            temp = temp.replaceAll(entry.getKey(), entry.getValue());
        }
        return temp;
    }

    public static boolean isBlank(String text) {
        return !TextUtil.isNotBlank(text);
    }

    public static boolean isNotBlank(String text) {
        return Objects.nonNull(text) && !text.trim().isEmpty();
    }

    public static String spacing(int size) {
        int space = 32;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    public static String replaceTab(String text, int size) {
        int tab = 9;
        char[] charArray = TextUtil.filterAll(text).toCharArray();
        StringBuilder builder = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        for (char c : charArray) {
            if (c == '\t') {
                temp.append(TextUtil.spacing(size));
                continue;
            }
            temp.append(c);
        }
        return builder.append((CharSequence)temp).toString();
    }

    public static void writeText(Context context, PDPageContentStream contentStream, String text, List<String> specialFontNames, PDFont font, Float fontSize) throws Exception {
        boolean flag = false;
        Exception exception = null;
        Iterator<Character> iterator = CommonUtil.toCharacterList(text.toCharArray()).iterator();
        block6: while (iterator.hasNext()) {
            Character character = iterator.next();
            try {
                contentStream.showCharacter(character);
            }
            catch (Exception e) {
                flag = true;
                exception = e;
                if (Objects.nonNull(specialFontNames)) {
                    for (String specialFontName : specialFontNames) {
                        try {
                            contentStream.setFont(context.getFont(specialFontName), fontSize.floatValue());
                            contentStream.showCharacter(character);
                            contentStream.setFont(font, fontSize.floatValue());
                            flag = false;
                            break;
                        }
                        catch (Exception exception2) {
                        }
                    }
                }
                if (!flag || !iterator.hasNext()) continue;
                Character next = iterator.next();
                char[] array = new char[]{character.charValue(), next.charValue()};
                if (!Objects.nonNull(specialFontNames)) continue;
                for (String specialFontName : specialFontNames) {
                    try {
                        contentStream.setFont(context.getFont(specialFontName), fontSize.floatValue());
                        contentStream.showText(String.valueOf(array));
                        contentStream.setFont(font, fontSize.floatValue());
                        flag = false;
                        continue block6;
                    }
                    catch (Exception exception3) {
                    }
                }
            }
        }
        if (flag) {
            throw exception;
        }
    }
}

