/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.COSUpdateInfo;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.PDFXRefStream;
import org.apache.pdfbox.pdfparser.xref.FreeXReference;
import org.apache.pdfbox.pdfparser.xref.NormalXReference;
import org.apache.pdfbox.pdfparser.xref.ObjectStreamXReference;
import org.apache.pdfbox.pdfparser.xref.XReferenceEntry;
import org.apache.pdfbox.pdfwriter.COSStandardOutputStream;
import org.apache.pdfbox.pdfwriter.compress.COSWriterCompressionPool;
import org.apache.pdfbox.pdfwriter.compress.COSWriterObjectStream;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.COSFilterInputStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.util.Hex;

public class COSWriter
implements ICOSVisitor {
    public static final byte[] DICT_OPEN = "<<".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] DICT_CLOSE = ">>".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] COMMENT = new byte[]{37};
    public static final byte[] VERSION = "PDF-1.4".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] GARBAGE = new byte[]{-10, -28, -4, -33};
    public static final byte[] EOF = "%%EOF".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] REFERENCE = "R".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] XREF = "xref".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] XREF_FREE = "f".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] XREF_USED = "n".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] TRAILER = "trailer".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] STARTXREF = "startxref".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] OBJ = "obj".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ENDOBJ = "endobj".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ARRAY_OPEN = "[".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ARRAY_CLOSE = "]".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] STREAM = "stream".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ENDSTREAM = "endstream".getBytes(StandardCharsets.US_ASCII);
    private static final NumberFormat formatXrefOffset = new DecimalFormat("0000000000", DecimalFormatSymbols.getInstance(Locale.US));
    private static final NumberFormat formatXrefGeneration = new DecimalFormat("00000", DecimalFormatSymbols.getInstance(Locale.US));
    private final List<XReferenceEntry> xRefEntries = new ArrayList<XReferenceEntry>();
    private final CompressParameters compressParameters;
    private OutputStream output;
    private COSStandardOutputStream standardOutput;
    private long startxref = 0L;
    private long number = 0L;
    private COSObjectKey currentObjectKey = null;
    protected PDDocument pdDocument = null;
    protected FDFDocument fdfDocument = null;
    protected boolean willEncrypt = false;
    private boolean incrementalUpdate = false;
    private boolean reachedSignature = false;
    private long signatureOffset;
    private long signatureLength;
    private long byteRangeOffset;
    private long byteRangeLength;
    private RandomAccessRead incrementalInput;
    private OutputStream incrementalOutput;
    private SignatureInterface signatureInterface;
    private byte[] incrementPart;
    private COSArray byteRangeArray;

    public COSWriter(OutputStream outputStream) {
        this(outputStream, (CompressParameters)null);
    }

    public COSWriter(OutputStream outputStream, CompressParameters compressParameters) {
        this.setOutput(outputStream);
        this.setStandardOutput(new COSStandardOutputStream(this.output));
        this.compressParameters = compressParameters;
    }

    public COSWriter(OutputStream outputStream, RandomAccessRead inputData) throws IOException {
        this.setOutput(new ByteArrayOutputStream());
        this.setStandardOutput(new COSStandardOutputStream(this.output, inputData.length()));
        this.compressParameters = CompressParameters.DEFAULT_COMPRESSION;
        this.incrementalInput = inputData;
        this.incrementalOutput = outputStream;
        this.incrementalUpdate = true;
    }

    public COSWriter(OutputStream outputStream, RandomAccessRead inputData, Set<COSDictionary> objectsToWrite) throws IOException {
        this(outputStream, inputData);
    }

    public static void writeString(COSString string, OutputStream output) throws IOException {
        COSWriter.writeString(string.getBytes(), string.getForceHexForm(), output);
    }

    public static void writeString(byte[] bytes, OutputStream output) throws IOException {
        COSWriter.writeString(bytes, false, output);
    }

    private static void writeString(byte[] bytes, boolean forceHex, OutputStream output) throws IOException {
        boolean isASCII = true;
        if (!forceHex) {
            for (byte b : bytes) {
                if (b < 0) {
                    isASCII = false;
                    break;
                }
                if (b != 13 && b != 10) continue;
                isASCII = false;
                break;
            }
        }
        if (isASCII && !forceHex) {
            output.write(40);
            block4: for (byte b : bytes) {
                switch (b) {
                    case 40: 
                    case 41: 
                    case 92: {
                        output.write(92);
                        output.write(b);
                        continue block4;
                    }
                    default: {
                        output.write(b);
                    }
                }
            }
            output.write(41);
        } else {
            output.write(60);
            Hex.writeHexBytes((byte[])bytes, (OutputStream)output);
            output.write(62);
        }
    }

    public boolean isCompress() {
        return this.compressParameters != null && this.compressParameters.isCompress();
    }

    private void prepareIncrement() {
        COSDocument cosDoc = this.pdDocument.getDocument();
        Set<COSObjectKey> keySet = cosDoc.getXrefTable().keySet();
        for (COSObjectKey cosObjectKey : keySet) {
            COSBase object;
            if (cosObjectKey == null || (object = cosDoc.getObjectFromPool(cosObjectKey).getObject()) == null || object instanceof COSNumber) continue;
            object.setVisit(true);
        }
    }

    protected void addXRefEntry(XReferenceEntry entry) {
        this.getXRefEntries().add(entry);
    }

    protected OutputStream getOutput() {
        return this.output;
    }

    protected void setOutput(OutputStream newOutput) {
        this.output = newOutput;
    }

    protected COSStandardOutputStream getStandardOutput() {
        return this.standardOutput;
    }

    protected void setStandardOutput(COSStandardOutputStream newStandardOutput) {
        this.standardOutput = newStandardOutput;
    }

    protected long getStartxref() {
        return this.startxref;
    }

    protected void setStartxref(long newStartxref) {
        this.startxref = newStartxref;
    }

    protected List<XReferenceEntry> getXRefEntries() {
        return this.xRefEntries;
    }

    private void doWriteBodyCompressed(COSDocument document) throws IOException {
        COSDictionary trailer = document.getTrailer();
        COSDictionary encrypt = trailer.getCOSDictionary(COSName.ENCRYPT);
        boolean bl = this.willEncrypt = encrypt != null;
        if (trailer.containsKey(COSName.ROOT)) {
            COSWriterCompressionPool compressionPool = new COSWriterCompressionPool(this.pdDocument, this.compressParameters);
            this.number = compressionPool.getHighestXRefObjectNumber();
            List<COSObjectKey> topLevelObjects = compressionPool.getTopLevelObjects();
            Iterator<COSObjectKey> iterator = topLevelObjects.iterator();
            while (iterator.hasNext()) {
                COSObjectKey cOSObjectKey;
                this.currentObjectKey = cOSObjectKey = iterator.next();
                this.doWriteObject(cOSObjectKey, compressionPool.getObject(cOSObjectKey));
            }
            topLevelObjects.clear();
            List<COSWriterObjectStream> objectStreams = compressionPool.createObjectStreams();
            for (COSWriterObjectStream finalizedObjectStream : objectStreams) {
                COSStream stream = finalizedObjectStream.writeObjectsToStream(document.createTempCOSStream());
                COSObjectKey objectStreamKey = new COSObjectKey(++this.number, 0);
                COSObject objectStream = new COSObject((COSBase)((Object)stream), objectStreamKey);
                int i = 0;
                for (COSObjectKey key : finalizedObjectStream.getPreparedKeys()) {
                    COSBase object = compressionPool.getObject(key);
                    this.addXRefEntry((XReferenceEntry)new ObjectStreamXReference(i, key, object, objectStreamKey));
                    ++i;
                }
                this.currentObjectKey = objectStreamKey;
                this.doWriteObject(objectStreamKey, (COSBase)objectStream);
                stream.close();
            }
            objectStreams.clear();
            this.willEncrypt = false;
            if (encrypt != null) {
                COSObjectKey cOSObjectKey;
                this.currentObjectKey = cOSObjectKey = new COSObjectKey(++this.number, 0);
                encrypt.setVisit(true);
                this.doWriteObject(cOSObjectKey, (COSBase)encrypt);
            }
        }
    }

    public void doWriteObject(COSObjectKey key, COSBase obj) throws IOException {
        if (obj == null || obj.isWritten() || obj instanceof COSObject && ((COSObject)obj).getObject() == null) {
            return;
        }
        obj.setKey(key);
        this.addXRefEntry((XReferenceEntry)new NormalXReference(this.getStandardOutput().getPos(), key, obj));
        this.getStandardOutput().write(String.valueOf(key.getNumber()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(OBJ);
        this.getStandardOutput().writeEOL();
        obj.accept(this);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(ENDOBJ);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().flush();
        obj.setWritten(true);
    }

    private boolean isNeedToBeUpdated(COSBase base) {
        if (base instanceof COSUpdateInfo) {
            return ((COSUpdateInfo)base).isNeedToBeUpdated();
        }
        return false;
    }

    public void doWriteObject(COSBase obj) throws IOException {
        this.currentObjectKey = this.getObjectKey(obj);
        this.doWriteObject(this.currentObjectKey, obj);
    }

    protected void doWriteHeader(COSDocument doc) throws IOException {
        if (this.isCompress()) {
            this.pdDocument.setVersion(Math.max(this.pdDocument.getVersion(), 1.6f));
            doc.setVersion(Math.max(doc.getVersion(), 1.6f));
        }
        String headerString = this.fdfDocument != null ? "%FDF-" + doc.getVersion() : "%PDF-" + doc.getVersion();
        this.getStandardOutput().write(headerString.getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(COMMENT);
        this.getStandardOutput().write(GARBAGE);
        this.getStandardOutput().writeEOL();
    }

    protected void doWriteTrailer(COSDocument doc) throws IOException {
        this.getStandardOutput().write(TRAILER);
        this.getStandardOutput().writeEOL();
        COSDictionary trailer = doc.getTrailer();
        Collections.sort(this.getXRefEntries());
        XReferenceEntry lastEntry = this.getXRefEntries().get(this.getXRefEntries().size() - 1);
        trailer.setLong(COSName.SIZE, lastEntry.getReferencedKey().getNumber() + 1L);
        if (!this.incrementalUpdate) {
            trailer.removeItem(COSName.PREV);
        }
        if (!doc.isXRefStream()) {
            trailer.removeItem(COSName.XREF_STM);
        }
        trailer.removeItem(COSName.DOC_CHECKSUM);
        COSArray idArray = trailer.getCOSArray(COSName.ID);
        if (idArray != null) {
            idArray.setDirect(true);
        }
        trailer.accept((ICOSVisitor)this);
    }

    private void doWriteXRefInc(COSDocument doc) throws IOException {
        if (!doc.isXRefStream() || doc.hasHybridXRef() && this.incrementalUpdate) {
            COSDictionary trailer = doc.getTrailer();
            trailer.setLong(COSName.PREV, doc.getStartXref());
            this.doWriteXRefTable();
            this.doWriteTrailer(doc);
        } else {
            PDFXRefStream pdfxRefStream = new PDFXRefStream(doc);
            this.getXRefEntries().forEach(arg_0 -> ((PDFXRefStream)pdfxRefStream).addEntry(arg_0));
            COSDictionary trailer = doc.getTrailer();
            if (this.incrementalUpdate) {
                trailer.setLong(COSName.PREV, doc.getStartXref());
            } else {
                trailer.removeItem(COSName.PREV);
            }
            pdfxRefStream.addTrailerInfo(trailer);
            pdfxRefStream.setSize(this.number + 2L);
            this.setStartxref(this.getStandardOutput().getPos());
            this.doWriteObject((COSBase)((Object)pdfxRefStream.getStream()));
        }
    }

    private void doWriteXRefTable() throws IOException {
        if (!this.incrementalUpdate) {
            this.fillGapsWithFreeEntries();
        } else {
            this.addXRefEntry((XReferenceEntry)FreeXReference.NULL_ENTRY);
        }
        List<XReferenceEntry> tmpXRefEntries = this.getXRefEntries().stream().filter(e -> e instanceof NormalXReference || e instanceof FreeXReference).sorted().collect(Collectors.toList());
        this.setStartxref(this.getStandardOutput().getPos());
        this.getStandardOutput().write(XREF);
        this.getStandardOutput().writeEOL();
        Long[] xRefRanges = this.getXRefRanges(tmpXRefEntries);
        int xRefLength = xRefRanges.length;
        int j = 0;
        if (xRefLength % 2 == 0) {
            for (int x = 0; x < xRefLength; x += 2) {
                long xRefRangeX1 = xRefRanges[x + 1];
                this.writeXrefRange(xRefRanges[x], xRefRangeX1);
                int i = 0;
                while ((long)i < xRefRangeX1) {
                    this.writeXrefEntry(tmpXRefEntries.get(j++));
                    ++i;
                }
            }
        }
    }

    private void fillGapsWithFreeEntries() {
        List normalXReferences = this.getXRefEntries().stream().filter(e -> e instanceof NormalXReference).map(NormalXReference.class::cast).sorted().collect(Collectors.toList());
        long last = 0L;
        ArrayList<Long> freeNumbers = new ArrayList<Long>();
        for (NormalXReference entry : normalXReferences) {
            long nr = entry.getReferencedKey().getNumber();
            if (nr != last) {
                for (long i = last; i < nr; ++i) {
                    freeNumbers.add(i);
                }
            }
            last = nr + 1L;
        }
        int numberOfFreeNumbers = freeNumbers.size();
        if (numberOfFreeNumbers == 0) {
            this.addXRefEntry((XReferenceEntry)FreeXReference.NULL_ENTRY);
            return;
        }
        for (int i = 0; i < numberOfFreeNumbers - 1; ++i) {
            this.addXRefEntry((XReferenceEntry)new FreeXReference(new COSObjectKey(((Long)freeNumbers.get(i)).longValue(), 65535), ((Long)freeNumbers.get(i + 1)).longValue()));
        }
        this.addXRefEntry((XReferenceEntry)new FreeXReference(new COSObjectKey(((Long)freeNumbers.get(numberOfFreeNumbers - 1)).longValue(), 65535), 0L));
        long firstObjectNumber = (Long)freeNumbers.get(0);
        if (firstObjectNumber > 0L) {
            this.addXRefEntry((XReferenceEntry)new FreeXReference(new COSObjectKey(0L, 65535), firstObjectNumber));
        }
    }

    private void doWriteIncrement() throws IOException {
        try (RandomAccessInputStream input = new RandomAccessInputStream(this.incrementalInput);){
            IOUtils.copy((InputStream)input, (OutputStream)this.incrementalOutput);
            this.incrementalOutput.write(((ByteArrayOutputStream)this.output).toByteArray());
        }
    }

    private void doWriteSignature() throws IOException {
        long inLength = this.incrementalInput.length();
        long beforeLength = this.signatureOffset;
        long afterOffset = this.signatureOffset + this.signatureLength;
        long afterLength = this.getStandardOutput().getPos() - (inLength + this.signatureLength) - (this.signatureOffset - inLength);
        String byteRange = "0 " + beforeLength + " " + afterOffset + " " + afterLength + "]";
        this.byteRangeArray.set(0, (COSBase)COSInteger.ZERO);
        this.byteRangeArray.set(1, (COSBase)COSInteger.get((long)beforeLength));
        this.byteRangeArray.set(2, (COSBase)COSInteger.get((long)afterOffset));
        this.byteRangeArray.set(3, (COSBase)COSInteger.get((long)afterLength));
        if ((long)byteRange.length() > this.byteRangeLength) {
            throw new IOException("Can't write new byteRange '" + byteRange + "' not enough space: byteRange.length(): " + byteRange.length() + ", byteRangeLength: " + this.byteRangeLength + ", byteRangeOffset: " + this.byteRangeOffset);
        }
        ByteArrayOutputStream byteOut = (ByteArrayOutputStream)this.output;
        byteOut.flush();
        this.incrementPart = byteOut.toByteArray();
        byte[] byteRangeBytes = byteRange.getBytes(StandardCharsets.ISO_8859_1);
        int i = 0;
        while ((long)i < this.byteRangeLength) {
            this.incrementPart[(int)(this.byteRangeOffset + (long)i - inLength)] = i >= byteRangeBytes.length ? 32 : byteRangeBytes[i];
            ++i;
        }
        if (this.signatureInterface != null) {
            InputStream dataToSign = this.getDataToSign();
            byte[] signatureBytes = this.signatureInterface.sign(dataToSign);
            this.writeExternalSignature(signatureBytes);
        }
    }

    public InputStream getDataToSign() throws IOException {
        if (this.incrementPart == null || this.incrementalInput == null) {
            throw new IllegalStateException("PDF not prepared for signing");
        }
        int incPartSigOffset = (int)(this.signatureOffset - this.incrementalInput.length());
        int afterSigOffset = incPartSigOffset + (int)this.signatureLength;
        int[] range = new int[]{0, incPartSigOffset, afterSigOffset, this.incrementPart.length - afterSigOffset};
        return new SequenceInputStream((InputStream)new RandomAccessInputStream(this.incrementalInput), (InputStream)new COSFilterInputStream(this.incrementPart, range));
    }

    public void writeExternalSignature(byte[] cmsSignature) throws IOException {
        if (this.incrementPart == null || this.incrementalInput == null) {
            throw new IllegalStateException("PDF not prepared for setting signature");
        }
        byte[] signatureBytes = Hex.getBytes((byte[])cmsSignature);
        if ((long)signatureBytes.length > this.signatureLength - 2L) {
            throw new IOException("Can't write signature, not enough space; adjust it with SignatureOptions.setPreferredSignatureSize");
        }
        int incPartSigOffset = (int)(this.signatureOffset - this.incrementalInput.length());
        System.arraycopy(signatureBytes, 0, this.incrementPart, incPartSigOffset + 1, signatureBytes.length);
        IOUtils.copy((InputStream)new RandomAccessInputStream(this.incrementalInput), (OutputStream)this.incrementalOutput);
        this.incrementalOutput.write(this.incrementPart);
        this.incrementPart = null;
    }

    private void writeXrefRange(long x, long y) throws IOException {
        this.getStandardOutput().write(String.valueOf(x).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(y).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().writeEOL();
    }

    private void writeXrefEntry(XReferenceEntry entry) throws IOException {
        String offset = formatXrefOffset.format(entry.getSecondColumnValue());
        String generation = formatXrefGeneration.format(entry.getThirdColumnValue());
        this.getStandardOutput().write(offset.getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(generation.getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(entry instanceof FreeXReference ? XREF_FREE : XREF_USED);
        this.getStandardOutput().writeCRLF();
    }

    protected Long[] getXRefRanges(List<XReferenceEntry> xRefEntriesList) {
        long last = -2L;
        long count = 1L;
        ArrayList<Long> list = new ArrayList<Long>();
        for (XReferenceEntry entry : xRefEntriesList) {
            long nr = entry.getReferencedKey().getNumber();
            if (nr == last + 1L) {
                ++count;
                last = nr;
                continue;
            }
            if (last == -2L) {
                last = nr;
                continue;
            }
            list.add(last - count + 1L);
            list.add(count);
            last = nr;
            count = 1L;
        }
        if (!xRefEntriesList.isEmpty()) {
            list.add(last - count + 1L);
            list.add(count);
        }
        return list.toArray(new Long[list.size()]);
    }

    private COSObjectKey getObjectKey(COSBase obj) {
        COSBase actual;
        COSObjectKey key = obj.getKey();
        if (obj instanceof COSObject) {
            actual = ((COSObject)obj).getObject();
            if (actual == null) {
                if (key == null) {
                    key = new COSObjectKey(++this.number, 0);
                }
                obj.setVisit(true);
                return key;
            }
        } else {
            actual = obj;
        }
        if (key == null || !actual.isVisit()) {
            key = new COSObjectKey(++this.number, 0);
            actual.setKey(key);
            if (obj instanceof COSObject) {
                obj.setKey(key);
                obj.setVisit(true);
            }
        }
        return key;
    }

    public void visitFromArray(COSArray array) throws IOException {
        int count = 0;
        this.getStandardOutput().write(ARRAY_OPEN);
        Iterator<COSBase> i = array.iterator();
        while (i.hasNext()) {
            COSBase current = i.next();
            if (current instanceof COSDictionary) {
                this.writeDictionary((COSDictionary)current);
            } else if (current instanceof COSArray) {
                this.writeArray((COSArray)current);
            } else if (current instanceof COSObject) {
                this.writeReference(current);
            } else if (current == null) {
                COSNull.NULL.accept((ICOSVisitor)this);
            } else {
                current.accept(this);
            }
            ++count;
            if (!i.hasNext()) continue;
            if (count % 10 == 0) {
                this.getStandardOutput().writeEOL();
                continue;
            }
            this.getStandardOutput().write(SPACE);
        }
        this.getStandardOutput().write(ARRAY_CLOSE);
        this.getStandardOutput().writeEOL();
    }

    private void writeArray(COSArray array) throws IOException {
        if (array.isDirect()) {
            this.visitFromArray(array);
        } else {
            this.writeReference(array);
        }
    }

    private void writeDictionary(COSDictionary dictionary) throws IOException {
        if (dictionary.isDirect()) {
            this.visitFromDictionary(dictionary);
        } else {
            this.writeReference((COSBase)dictionary);
        }
    }

    public void visitFromBoolean(COSBoolean obj) throws IOException {
        obj.writePDF((OutputStream)this.getStandardOutput());
    }

    public void visitFromDictionary(COSDictionary obj) throws IOException {
        this.detectPossibleSignature(obj);
        this.getStandardOutput().write(DICT_OPEN);
        this.getStandardOutput().writeEOL();
        for (Map.Entry entry : obj.entrySet()) {
            COSBase value = (COSBase)entry.getValue();
            if (value == null) continue;
            ((COSName)entry.getKey()).accept((ICOSVisitor)this);
            this.getStandardOutput().write(SPACE);
            if (value instanceof COSDictionary) {
                COSDictionary dict = (COSDictionary)value;
                if (!this.incrementalUpdate) {
                    COSBase item = dict.getItem(COSName.XOBJECT);
                    if (item != null && !COSName.XOBJECT.equals(entry.getKey())) {
                        item.setDirect(true);
                    }
                    if ((item = dict.getItem(COSName.RESOURCES)) != null && !COSName.RESOURCES.equals(entry.getKey())) {
                        item.setDirect(true);
                    }
                }
                this.writeDictionary(dict);
            } else if (value instanceof COSObject) {
                this.writeReference(value);
            } else if (this.reachedSignature && COSName.CONTENTS.equals(entry.getKey())) {
                this.signatureOffset = this.getStandardOutput().getPos();
                value.accept(this);
                this.signatureLength = this.getStandardOutput().getPos() - this.signatureOffset;
            } else if (this.reachedSignature && COSName.BYTERANGE.equals(entry.getKey())) {
                this.byteRangeArray = (COSArray)entry.getValue();
                this.byteRangeOffset = this.getStandardOutput().getPos() + 1L;
                value.accept(this);
                this.byteRangeLength = this.getStandardOutput().getPos() - 1L - this.byteRangeOffset;
                this.reachedSignature = false;
            } else if (value instanceof COSArray) {
                this.writeArray((COSArray)value);
            } else {
                value.accept(this);
            }
            this.getStandardOutput().writeEOL();
        }
        this.getStandardOutput().write(DICT_CLOSE);
        this.getStandardOutput().writeEOL();
    }

    private void detectPossibleSignature(COSDictionary obj) throws IOException {
        COSArray byteRange;
        COSBase itemType;
        if (!this.reachedSignature && this.incrementalUpdate && (COSName.SIG.equals((Object)(itemType = obj.getItem(COSName.TYPE))) || COSName.DOC_TIME_STAMP.equals((Object)itemType)) && (byteRange = obj.getCOSArray(COSName.BYTERANGE)) != null && byteRange.size() == 4) {
            long br3;
            long br2;
            COSBase base2 = byteRange.get(2);
            COSBase base3 = byteRange.get(3);
            if (base2 instanceof COSInteger && base3 instanceof COSInteger && (br2 = ((COSInteger)base2).longValue()) + (br3 = ((COSInteger)base3).longValue()) > this.incrementalInput.length()) {
                this.reachedSignature = true;
            }
        }
    }

    public void visitFromDocument(COSDocument doc) throws IOException {
        if (!this.incrementalUpdate) {
            this.doWriteHeader(doc);
        } else {
            this.getStandardOutput().writeCRLF();
        }
        this.doWriteBodyCompressed(doc);
        if (this.incrementalUpdate || doc.isXRefStream()) {
            this.doWriteXRefInc(doc);
        } else {
            this.doWriteXRefTable();
            this.doWriteTrailer(doc);
        }
        this.getStandardOutput().write(STARTXREF);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(String.valueOf(this.getStartxref()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(EOF);
        this.getStandardOutput().writeEOL();
        if (this.incrementalUpdate) {
            if (this.signatureOffset == 0L || this.byteRangeOffset == 0L) {
                this.doWriteIncrement();
            } else {
                this.doWriteSignature();
            }
        }
    }

    public void visitFromFloat(COSFloat obj) throws IOException {
        obj.writePDF((OutputStream)this.getStandardOutput());
    }

    public void visitFromInt(COSInteger obj) throws IOException {
        obj.writePDF((OutputStream)this.getStandardOutput());
    }

    public void visitFromName(COSName obj) throws IOException {
        obj.writePDF((OutputStream)this.getStandardOutput());
    }

    public void visitFromNull(COSNull obj) throws IOException {
        obj.writePDF((OutputStream)this.getStandardOutput());
    }

    public void writeReference(COSBase obj) throws IOException {
        COSObjectKey key = this.getObjectKey(obj);
        this.getStandardOutput().write(String.valueOf(key.getNumber()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(REFERENCE);
    }

    public void visitFromStream(COSStream obj) throws IOException {
        if (obj.isWritten()) {
            return;
        }
        if (this.willEncrypt) {
            this.pdDocument.getEncryption().getSecurityHandler().encryptStream(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
        }
        this.visitFromDictionary(obj);
        this.getStandardOutput().write(STREAM);
        this.getStandardOutput().writeCRLF();
        if (obj.hasData()) {
            IOUtils.copy((InputStream)obj.createRawInputStream(), (OutputStream)this.getStandardOutput());
            obj.close();
        }
        this.getStandardOutput().writeCRLF();
        this.getStandardOutput().write(ENDSTREAM);
        this.getStandardOutput().writeEOL();
    }

    public void visitFromString(COSString obj) throws IOException {
        if (this.willEncrypt) {
            this.pdDocument.getEncryption().getSecurityHandler().encryptString(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
        }
        COSWriter.writeString(obj, (OutputStream)this.getStandardOutput());
    }

    public void write(COSDocument doc) throws IOException {
        this.write(new PDDocument(doc));
    }

    public void write(PDDocument doc) throws IOException {
        this.write(doc, null);
    }

    public void write(PDDocument doc, SignatureInterface signInterface) throws IOException {
        COSArray idArray;
        this.pdDocument = doc;
        COSDocument cosDoc = this.pdDocument.getDocument();
        COSDictionary trailer = cosDoc.getTrailer();
        this.signatureInterface = signInterface;
        this.number = this.pdDocument.getDocument().getHighestXRefObjectNumber();
        if (this.incrementalUpdate) {
            this.prepareIncrement();
        }
        if (doc.isAllSecurityToBeRemoved()) {
            this.willEncrypt = false;
            trailer.removeItem(COSName.ENCRYPT);
        } else if (this.pdDocument.getEncryption() != null) {
            if (!this.incrementalUpdate) {
                SecurityHandler securityHandler = this.pdDocument.getEncryption().getSecurityHandler();
                if (!securityHandler.hasProtectionPolicy()) {
                    throw new IllegalStateException("PDF contains an encryption dictionary, please remove it with setAllSecurityToBeRemoved() or set a protection policy with protect()");
                }
                securityHandler.prepareDocumentForEncryption(this.pdDocument);
            }
            this.willEncrypt = true;
        } else {
            this.willEncrypt = false;
        }
        boolean missingID = true;
        COSBase base = trailer.getDictionaryObject(COSName.ID);
        if (base instanceof COSArray) {
            idArray = (COSArray)base;
            if (idArray.size() == 2) {
                missingID = false;
            }
        } else {
            idArray = new COSArray();
        }
        if (missingID || this.incrementalUpdate) {
            MessageDigest sha256;
            try {
                sha256 = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            long idTime = this.pdDocument.getDocumentId() == null ? System.currentTimeMillis() : this.pdDocument.getDocumentId();
            sha256.update(Long.toString(idTime).getBytes(StandardCharsets.ISO_8859_1));
            COSDictionary info = trailer.getCOSDictionary(COSName.INFO);
            if (info != null) {
                for (COSBase cosBase : info.getValues()) {
                    sha256.update(cosBase.toString().getBytes(StandardCharsets.ISO_8859_1));
                }
            }
            COSString firstID = missingID ? new COSString(sha256.digest()) : (COSString)idArray.get(0);
            COSString secondID = missingID ? firstID : new COSString(sha256.digest());
            idArray = new COSArray();
            idArray.add((COSBase)firstID);
            idArray.add((COSBase)secondID);
            trailer.setItem(COSName.ID, (COSBase)idArray);
        }
        cosDoc.accept(this);
        if (!this.incrementalUpdate) {
            cosDoc.setHighestXRefObjectNumber(this.number);
        }
    }

    public void write(FDFDocument doc) throws IOException {
        this.fdfDocument = doc;
        COSDocument cosDoc = this.fdfDocument.getDocument();
        this.willEncrypt = false;
        cosDoc.accept(this);
    }
}

