/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter.compress;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdfwriter.compress.COSWriterCompressionPool;

public class COSWriterObjectStream {
    private static final Log LOG = LogFactory.getLog(COSWriterObjectStream.class);
    private final COSWriterCompressionPool compressionPool;
    private final List<COSObjectKey> preparedKeys = new ArrayList<COSObjectKey>();
    private final List<COSBase> preparedObjects = new ArrayList<COSBase>();

    public COSWriterObjectStream(COSWriterCompressionPool compressionPool) {
        this.compressionPool = compressionPool;
    }

    public void prepareStreamObject(COSObjectKey key, COSBase object) {
        if (key != null && object != null) {
            this.preparedKeys.add(key);
            this.preparedObjects.add(object instanceof COSObject ? ((COSObject)object).getObject() : object);
        }
    }

    public List<COSObjectKey> getPreparedKeys() {
        return Collections.unmodifiableList(this.preparedKeys);
    }

    public COSStream writeObjectsToStream(COSStream stream) throws IOException {
        int objectCount = this.preparedKeys.size();
        stream.setItem(COSName.TYPE, (COSBase)COSName.OBJ_STM);
        stream.setInt(COSName.N, objectCount);
        try (OutputStream output = stream.createOutputStream((COSBase)COSName.FLATE_DECODE);
             ByteArrayOutputStream partialOutput = new ByteArrayOutputStream(8192);){
            for (int i = 0; i < objectCount; ++i) {
                output.write(String.valueOf(this.preparedKeys.get(i).getNumber()).getBytes(StandardCharsets.ISO_8859_1));
                output.write(COSWriter.SPACE);
                output.write(String.valueOf(partialOutput.size()).getBytes(StandardCharsets.ISO_8859_1));
                output.write(COSWriter.SPACE);
                this.writeObject(partialOutput, this.preparedObjects.get(i), true);
            }
            stream.setInt(COSName.FIRST, (int)stream.getDataLength());
            output.write(partialOutput.toByteArray());
        }
        return stream;
    }

    private void writeObject(OutputStream output, COSBase object, boolean topLevel) throws IOException {
        COSBase base;
        if (object == null) {
            return;
        }
        if (!(object instanceof COSBase)) {
            throw new IOException("Error: Unknown type in object stream:" + object);
        }
        if (object instanceof COSObject) {
            COSObjectKey actualKey;
            if (!topLevel && (actualKey = object.getKey()) != null) {
                this.writeObjectReference(output, actualKey);
                return;
            }
            base = ((COSObject)object).getObject();
            if (base == null) {
                LOG.debug((Object)("Can't dereference indirect object, writing COSNull instead " + object));
                this.writeCOSNull(output);
                return;
            }
        } else {
            base = object;
        }
        if (!topLevel && this.compressionPool.contains(base)) {
            COSObjectKey key = this.compressionPool.getKey(base);
            if (key == null) {
                throw new IOException("Error: Adding unknown object reference to object stream:" + object);
            }
            this.writeObjectReference(output, key);
            return;
        }
        if (base instanceof COSString) {
            this.writeCOSString(output, (COSString)base);
        } else if (base instanceof COSFloat) {
            this.writeCOSFloat(output, (COSFloat)base);
        } else if (base instanceof COSInteger) {
            this.writeCOSInteger(output, (COSInteger)base);
        } else if (base instanceof COSBoolean) {
            this.writeCOSBoolean(output, (COSBoolean)base);
        } else if (base instanceof COSName) {
            this.writeCOSName(output, (COSName)base);
        } else if (base instanceof COSArray) {
            this.writeCOSArray(output, (COSArray)base);
        } else if (base instanceof COSDictionary) {
            this.writeCOSDictionary(output, (COSDictionary)base);
        } else if (base instanceof COSNull) {
            this.writeCOSNull(output);
        } else {
            throw new IOException("Error: Unknown type in object stream:" + object);
        }
    }

    private void writeCOSString(OutputStream output, COSString cosString) throws IOException {
        COSWriter.writeString(cosString, output);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSFloat(OutputStream output, COSFloat cosFloat) throws IOException {
        cosFloat.writePDF(output);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSInteger(OutputStream output, COSInteger cosInteger) throws IOException {
        cosInteger.writePDF(output);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSBoolean(OutputStream output, COSBoolean cosBoolean) throws IOException {
        cosBoolean.writePDF(output);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSName(OutputStream output, COSName cosName) throws IOException {
        cosName.writePDF(output);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSArray(OutputStream output, COSArray cosArray) throws IOException {
        output.write(COSWriter.ARRAY_OPEN);
        for (COSBase cOSBase : cosArray.toList()) {
            if (cOSBase == null) {
                this.writeCOSNull(output);
                continue;
            }
            this.writeObject(output, cOSBase, false);
        }
        output.write(COSWriter.ARRAY_CLOSE);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSDictionary(OutputStream output, COSDictionary cosDictionary) throws IOException {
        output.write(COSWriter.DICT_OPEN);
        for (Map.Entry entry : cosDictionary.entrySet()) {
            if (entry.getValue() == null) continue;
            this.writeObject(output, (COSBase)entry.getKey(), true);
            this.writeObject(output, (COSBase)entry.getValue(), false);
        }
        output.write(COSWriter.DICT_CLOSE);
        output.write(COSWriter.SPACE);
    }

    private void writeObjectReference(OutputStream output, COSObjectKey indirectReference) throws IOException {
        output.write(String.valueOf(indirectReference.getNumber()).getBytes(StandardCharsets.ISO_8859_1));
        output.write(COSWriter.SPACE);
        output.write(String.valueOf(indirectReference.getGeneration()).getBytes(StandardCharsets.ISO_8859_1));
        output.write(COSWriter.SPACE);
        output.write(COSWriter.REFERENCE);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSNull(OutputStream output) throws IOException {
        output.write("null".getBytes(StandardCharsets.ISO_8859_1));
        output.write(COSWriter.SPACE);
    }
}

