/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base.config;

import java.awt.Color;
import java.util.Objects;
import lombok.Generated;
import org.dromara.pdf.pdfbox.core.enums.LineCapStyle;
import org.dromara.pdf.pdfbox.core.enums.LineStyle;

public class BorderConfiguration {
    protected LineStyle borderLineStyle;
    protected LineCapStyle borderLineCapStyle;
    protected Float borderRadius;
    protected Float borderLineLength;
    protected Float borderLineWidth;
    protected Float borderDottedSpacing;
    protected Color borderTopColor;
    protected Color borderBottomColor;
    protected Color borderLeftColor;
    protected Color borderRightColor;
    protected Boolean isBorderTop;
    protected Boolean isBorderBottom;
    protected Boolean isBorderLeft;
    protected Boolean isBorderRight;

    public BorderConfiguration() {
        this(true);
    }

    public BorderConfiguration(boolean isInit) {
        if (isInit) {
            this.init();
        }
    }

    public BorderConfiguration(BorderConfiguration configuration) {
        this.init(configuration);
    }

    public void setIsBorder(boolean flag) {
        this.isBorderTop = flag;
        this.isBorderBottom = flag;
        this.isBorderLeft = flag;
        this.isBorderRight = flag;
    }

    public void setBorderColor(Color color) {
        this.borderTopColor = color;
        this.borderBottomColor = color;
        this.borderLeftColor = color;
        this.borderRightColor = color;
    }

    public void setBorderLineWidth(float width) {
        if (width <= 0.0f) {
            throw new IllegalArgumentException("the border line width must be greater than 0");
        }
        this.borderLineWidth = Float.valueOf(width);
    }

    public void setBorderLineLength(float length) {
        if (length <= 0.0f) {
            throw new IllegalArgumentException("the border line length must be greater than 0");
        }
        this.borderLineLength = Float.valueOf(length);
    }

    public void setBorderDottedSpacing(float spacing) {
        if (spacing < 0.0f) {
            throw new IllegalArgumentException("the border dotted spacing must be greater than 0");
        }
        this.borderDottedSpacing = Float.valueOf(spacing);
    }

    public boolean hasBorder() {
        return this.isBorderTop != false || this.isBorderBottom != false || this.isBorderLeft != false || this.isBorderRight != false;
    }

    public boolean hasAllBorder() {
        return this.isBorderTop != false && this.isBorderBottom != false && this.isBorderLeft != false && this.isBorderRight != false;
    }

    public void init() {
        if (Objects.isNull((Object)this.borderLineStyle)) {
            this.borderLineStyle = LineStyle.SOLID;
        }
        if (Objects.isNull((Object)this.borderLineCapStyle)) {
            this.borderLineCapStyle = LineCapStyle.SQUARE;
        }
        if (Objects.isNull(this.borderRadius)) {
            this.borderRadius = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.borderLineWidth)) {
            this.borderLineWidth = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.borderDottedSpacing)) {
            this.borderDottedSpacing = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.borderTopColor)) {
            this.borderTopColor = Color.GRAY;
        }
        if (Objects.isNull(this.borderBottomColor)) {
            this.borderBottomColor = Color.GRAY;
        }
        if (Objects.isNull(this.borderLeftColor)) {
            this.borderLeftColor = Color.GRAY;
        }
        if (Objects.isNull(this.borderRightColor)) {
            this.borderRightColor = Color.GRAY;
        }
        if (Objects.isNull(this.isBorderTop)) {
            this.isBorderTop = Boolean.FALSE;
        }
        if (Objects.isNull(this.isBorderBottom)) {
            this.isBorderBottom = Boolean.FALSE;
        }
        if (Objects.isNull(this.isBorderLeft)) {
            this.isBorderLeft = Boolean.FALSE;
        }
        if (Objects.isNull(this.isBorderRight)) {
            this.isBorderRight = Boolean.FALSE;
        }
    }

    public void init(BorderConfiguration base) {
        if (Objects.isNull((Object)this.borderLineStyle)) {
            this.borderLineStyle = base.borderLineStyle;
        }
        if (Objects.isNull((Object)this.borderLineCapStyle)) {
            this.borderLineCapStyle = base.borderLineCapStyle;
        }
        if (Objects.isNull(this.borderRadius)) {
            this.borderRadius = base.borderRadius;
        }
        if (Objects.isNull(this.borderLineLength)) {
            this.borderLineLength = base.borderLineLength;
        }
        if (Objects.isNull(this.borderLineWidth)) {
            this.borderLineWidth = base.borderLineWidth;
        }
        if (Objects.isNull(this.borderDottedSpacing)) {
            this.borderDottedSpacing = base.borderDottedSpacing;
        }
        if (Objects.isNull(this.borderTopColor)) {
            this.borderTopColor = base.borderTopColor;
        }
        if (Objects.isNull(this.borderBottomColor)) {
            this.borderBottomColor = base.borderBottomColor;
        }
        if (Objects.isNull(this.borderLeftColor)) {
            this.borderLeftColor = base.borderLeftColor;
        }
        if (Objects.isNull(this.borderRightColor)) {
            this.borderRightColor = base.borderRightColor;
        }
        if (Objects.isNull(this.isBorderTop)) {
            this.isBorderTop = base.isBorderTop;
        }
        if (Objects.isNull(this.isBorderBottom)) {
            this.isBorderBottom = base.isBorderBottom;
        }
        if (Objects.isNull(this.isBorderLeft)) {
            this.isBorderLeft = base.isBorderLeft;
        }
        if (Objects.isNull(this.isBorderRight)) {
            this.isBorderRight = base.isBorderRight;
        }
    }

    @Generated
    public LineStyle getBorderLineStyle() {
        return this.borderLineStyle;
    }

    @Generated
    public LineCapStyle getBorderLineCapStyle() {
        return this.borderLineCapStyle;
    }

    @Generated
    public Float getBorderRadius() {
        return this.borderRadius;
    }

    @Generated
    public Float getBorderLineLength() {
        return this.borderLineLength;
    }

    @Generated
    public Float getBorderLineWidth() {
        return this.borderLineWidth;
    }

    @Generated
    public Float getBorderDottedSpacing() {
        return this.borderDottedSpacing;
    }

    @Generated
    public Color getBorderTopColor() {
        return this.borderTopColor;
    }

    @Generated
    public Color getBorderBottomColor() {
        return this.borderBottomColor;
    }

    @Generated
    public Color getBorderLeftColor() {
        return this.borderLeftColor;
    }

    @Generated
    public Color getBorderRightColor() {
        return this.borderRightColor;
    }

    @Generated
    public Boolean getIsBorderTop() {
        return this.isBorderTop;
    }

    @Generated
    public Boolean getIsBorderBottom() {
        return this.isBorderBottom;
    }

    @Generated
    public Boolean getIsBorderLeft() {
        return this.isBorderLeft;
    }

    @Generated
    public Boolean getIsBorderRight() {
        return this.isBorderRight;
    }

    @Generated
    public void setBorderLineStyle(LineStyle borderLineStyle) {
        this.borderLineStyle = borderLineStyle;
    }

    @Generated
    public void setBorderLineCapStyle(LineCapStyle borderLineCapStyle) {
        this.borderLineCapStyle = borderLineCapStyle;
    }

    @Generated
    public void setBorderRadius(Float borderRadius) {
        this.borderRadius = borderRadius;
    }

    @Generated
    public void setBorderTopColor(Color borderTopColor) {
        this.borderTopColor = borderTopColor;
    }

    @Generated
    public void setBorderBottomColor(Color borderBottomColor) {
        this.borderBottomColor = borderBottomColor;
    }

    @Generated
    public void setBorderLeftColor(Color borderLeftColor) {
        this.borderLeftColor = borderLeftColor;
    }

    @Generated
    public void setBorderRightColor(Color borderRightColor) {
        this.borderRightColor = borderRightColor;
    }

    @Generated
    public void setIsBorderTop(Boolean isBorderTop) {
        this.isBorderTop = isBorderTop;
    }

    @Generated
    public void setIsBorderBottom(Boolean isBorderBottom) {
        this.isBorderBottom = isBorderBottom;
    }

    @Generated
    public void setIsBorderLeft(Boolean isBorderLeft) {
        this.isBorderLeft = isBorderLeft;
    }

    @Generated
    public void setIsBorderRight(Boolean isBorderRight) {
        this.isBorderRight = isBorderRight;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BorderConfiguration)) {
            return false;
        }
        BorderConfiguration other = (BorderConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$borderRadius = this.getBorderRadius();
        Float other$borderRadius = other.getBorderRadius();
        if (this$borderRadius == null ? other$borderRadius != null : !((Object)this$borderRadius).equals(other$borderRadius)) {
            return false;
        }
        Float this$borderLineLength = this.getBorderLineLength();
        Float other$borderLineLength = other.getBorderLineLength();
        if (this$borderLineLength == null ? other$borderLineLength != null : !((Object)this$borderLineLength).equals(other$borderLineLength)) {
            return false;
        }
        Float this$borderLineWidth = this.getBorderLineWidth();
        Float other$borderLineWidth = other.getBorderLineWidth();
        if (this$borderLineWidth == null ? other$borderLineWidth != null : !((Object)this$borderLineWidth).equals(other$borderLineWidth)) {
            return false;
        }
        Float this$borderDottedSpacing = this.getBorderDottedSpacing();
        Float other$borderDottedSpacing = other.getBorderDottedSpacing();
        if (this$borderDottedSpacing == null ? other$borderDottedSpacing != null : !((Object)this$borderDottedSpacing).equals(other$borderDottedSpacing)) {
            return false;
        }
        Boolean this$isBorderTop = this.getIsBorderTop();
        Boolean other$isBorderTop = other.getIsBorderTop();
        if (this$isBorderTop == null ? other$isBorderTop != null : !((Object)this$isBorderTop).equals(other$isBorderTop)) {
            return false;
        }
        Boolean this$isBorderBottom = this.getIsBorderBottom();
        Boolean other$isBorderBottom = other.getIsBorderBottom();
        if (this$isBorderBottom == null ? other$isBorderBottom != null : !((Object)this$isBorderBottom).equals(other$isBorderBottom)) {
            return false;
        }
        Boolean this$isBorderLeft = this.getIsBorderLeft();
        Boolean other$isBorderLeft = other.getIsBorderLeft();
        if (this$isBorderLeft == null ? other$isBorderLeft != null : !((Object)this$isBorderLeft).equals(other$isBorderLeft)) {
            return false;
        }
        Boolean this$isBorderRight = this.getIsBorderRight();
        Boolean other$isBorderRight = other.getIsBorderRight();
        if (this$isBorderRight == null ? other$isBorderRight != null : !((Object)this$isBorderRight).equals(other$isBorderRight)) {
            return false;
        }
        LineStyle this$borderLineStyle = this.getBorderLineStyle();
        LineStyle other$borderLineStyle = other.getBorderLineStyle();
        if (this$borderLineStyle == null ? other$borderLineStyle != null : !((Object)((Object)this$borderLineStyle)).equals((Object)other$borderLineStyle)) {
            return false;
        }
        LineCapStyle this$borderLineCapStyle = this.getBorderLineCapStyle();
        LineCapStyle other$borderLineCapStyle = other.getBorderLineCapStyle();
        if (this$borderLineCapStyle == null ? other$borderLineCapStyle != null : !((Object)((Object)this$borderLineCapStyle)).equals((Object)other$borderLineCapStyle)) {
            return false;
        }
        Color this$borderTopColor = this.getBorderTopColor();
        Color other$borderTopColor = other.getBorderTopColor();
        if (this$borderTopColor == null ? other$borderTopColor != null : !((Object)this$borderTopColor).equals(other$borderTopColor)) {
            return false;
        }
        Color this$borderBottomColor = this.getBorderBottomColor();
        Color other$borderBottomColor = other.getBorderBottomColor();
        if (this$borderBottomColor == null ? other$borderBottomColor != null : !((Object)this$borderBottomColor).equals(other$borderBottomColor)) {
            return false;
        }
        Color this$borderLeftColor = this.getBorderLeftColor();
        Color other$borderLeftColor = other.getBorderLeftColor();
        if (this$borderLeftColor == null ? other$borderLeftColor != null : !((Object)this$borderLeftColor).equals(other$borderLeftColor)) {
            return false;
        }
        Color this$borderRightColor = this.getBorderRightColor();
        Color other$borderRightColor = other.getBorderRightColor();
        return !(this$borderRightColor == null ? other$borderRightColor != null : !((Object)this$borderRightColor).equals(other$borderRightColor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BorderConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $borderRadius = this.getBorderRadius();
        result = result * 59 + ($borderRadius == null ? 43 : ((Object)$borderRadius).hashCode());
        Float $borderLineLength = this.getBorderLineLength();
        result = result * 59 + ($borderLineLength == null ? 43 : ((Object)$borderLineLength).hashCode());
        Float $borderLineWidth = this.getBorderLineWidth();
        result = result * 59 + ($borderLineWidth == null ? 43 : ((Object)$borderLineWidth).hashCode());
        Float $borderDottedSpacing = this.getBorderDottedSpacing();
        result = result * 59 + ($borderDottedSpacing == null ? 43 : ((Object)$borderDottedSpacing).hashCode());
        Boolean $isBorderTop = this.getIsBorderTop();
        result = result * 59 + ($isBorderTop == null ? 43 : ((Object)$isBorderTop).hashCode());
        Boolean $isBorderBottom = this.getIsBorderBottom();
        result = result * 59 + ($isBorderBottom == null ? 43 : ((Object)$isBorderBottom).hashCode());
        Boolean $isBorderLeft = this.getIsBorderLeft();
        result = result * 59 + ($isBorderLeft == null ? 43 : ((Object)$isBorderLeft).hashCode());
        Boolean $isBorderRight = this.getIsBorderRight();
        result = result * 59 + ($isBorderRight == null ? 43 : ((Object)$isBorderRight).hashCode());
        LineStyle $borderLineStyle = this.getBorderLineStyle();
        result = result * 59 + ($borderLineStyle == null ? 43 : ((Object)((Object)$borderLineStyle)).hashCode());
        LineCapStyle $borderLineCapStyle = this.getBorderLineCapStyle();
        result = result * 59 + ($borderLineCapStyle == null ? 43 : ((Object)((Object)$borderLineCapStyle)).hashCode());
        Color $borderTopColor = this.getBorderTopColor();
        result = result * 59 + ($borderTopColor == null ? 43 : ((Object)$borderTopColor).hashCode());
        Color $borderBottomColor = this.getBorderBottomColor();
        result = result * 59 + ($borderBottomColor == null ? 43 : ((Object)$borderBottomColor).hashCode());
        Color $borderLeftColor = this.getBorderLeftColor();
        result = result * 59 + ($borderLeftColor == null ? 43 : ((Object)$borderLeftColor).hashCode());
        Color $borderRightColor = this.getBorderRightColor();
        result = result * 59 + ($borderRightColor == null ? 43 : ((Object)$borderRightColor).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BorderConfiguration(borderLineStyle=" + (Object)((Object)this.getBorderLineStyle()) + ", borderLineCapStyle=" + (Object)((Object)this.getBorderLineCapStyle()) + ", borderRadius=" + this.getBorderRadius() + ", borderLineLength=" + this.getBorderLineLength() + ", borderLineWidth=" + this.getBorderLineWidth() + ", borderDottedSpacing=" + this.getBorderDottedSpacing() + ", borderTopColor=" + this.getBorderTopColor() + ", borderBottomColor=" + this.getBorderBottomColor() + ", borderLeftColor=" + this.getBorderLeftColor() + ", borderRightColor=" + this.getBorderRightColor() + ", isBorderTop=" + this.getIsBorderTop() + ", isBorderBottom=" + this.getIsBorderBottom() + ", isBorderLeft=" + this.getIsBorderLeft() + ", isBorderRight=" + this.getIsBorderRight() + ")";
    }
}

