/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.convertor.image;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PageSize;
import org.dromara.pdf.pdfbox.core.component.Image;
import org.dromara.pdf.pdfbox.core.ext.convertor.AbstractConvertor;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class ImageConvertor
extends AbstractConvertor {
    public ImageConvertor(Document document) {
        super(Optional.ofNullable(document).orElse(PdfHandler.getDocumentHandler().create()));
    }

    public void toPdf(File ... files) {
        this.toPdf(PageSize.A4, files);
    }

    public void toPdf(PageSize pageSize, File ... files) {
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>(files.length);
        for (File file : files) {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                 ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
                IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)outputStream);
                list.add(ImageUtil.read(outputStream.toByteArray()));
            }
        }
        this.toPdf(pageSize, list);
    }

    public void toPdf(List<BufferedImage> images) {
        this.toPdf(PageSize.A4, images);
    }

    public void toPdf(PageSize pageSize, List<BufferedImage> images) {
        this.toPdf(pageSize, images.toArray(new BufferedImage[0]));
    }

    public void toPdf(BufferedImage ... images) {
        this.toPdf(PageSize.A4, images);
    }

    public void toPdf(PageSize pageSize, BufferedImage ... images) {
        Objects.requireNonNull(pageSize, "the page size can not be null");
        Objects.requireNonNull(images, "the image can not be null");
        if (images.length == 0) {
            throw new IllegalArgumentException("the image can not be empty");
        }
        ArrayList<Page> pages = new ArrayList<Page>(images.length);
        for (BufferedImage image : images) {
            Page page = new Page(this.document, pageSize);
            Image component = new Image(page);
            component.setImage(image);
            component.setWidth(page.getWidth().intValue());
            component.setHeight(page.getHeight().intValue());
            component.render();
            pages.add(page);
        }
        this.document.appendPage(pages);
    }

    public Document flush() {
        return this.document;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageConvertor)) {
            return false;
        }
        ImageConvertor other = (ImageConvertor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImageConvertor;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

