/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.handler;

import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.component.TextLineInfo;
import org.dromara.pdf.pdfbox.core.ext.handler.AbstractTextHandler;
import org.dromara.pdf.pdfbox.core.ext.handler.tokenizer.StandardTokenizer;
import org.dromara.pdf.pdfbox.support.Constants;

public class TextHandler
extends AbstractTextHandler {
    public TextHandler(Document document) {
        super(document);
        this.tokenizer = new StandardTokenizer();
        this.tokenizer.setContext(this.getContext());
    }

    @Override
    public void writeText(FontConfiguration fontConfiguration, PDPageContentStream contentStream, TextLineInfo text) {
        List<String> specialFontNames = fontConfiguration.getSpecialFontNames();
        PDFont font = this.getContext().getFont(fontConfiguration.getFontName());
        Float fontSize = fontConfiguration.getFontSize();
        String content = text.getText();
        for (int i = 0; i < content.length(); ++i) {
            char character = content.charAt(i);
            try {
                contentStream.showCharacter(character);
                continue;
            }
            catch (Exception e) {
                boolean flag = this.processSingle(contentStream, character, specialFontNames, font, fontSize);
                if (!flag || i + 1 >= content.length()) continue;
                char next = content.charAt(i + 1);
                flag = this.processDouble(contentStream, character, next, specialFontNames, font, fontSize);
                if (flag) {
                    contentStream.setFont(this.getContext().getFont("HarmonyOS_Sans_SC"), fontSize.floatValue());
                    contentStream.showCharacter(Constants.DEFAULT_UNKNOWN_CHARACTER.charValue());
                    contentStream.setFont(font, fontSize.floatValue());
                    continue;
                }
                ++i;
            }
        }
    }

    protected boolean processSingle(PDPageContentStream contentStream, char character, List<String> specialFontNames, PDFont font, Float fontSize) {
        boolean flag = true;
        if (Objects.nonNull(specialFontNames)) {
            for (String specialFontName : specialFontNames) {
                try {
                    contentStream.setFont(this.getContext().getFont(specialFontName), fontSize.floatValue());
                    contentStream.showCharacter(character);
                    flag = false;
                    break;
                }
                catch (Exception exception) {
                }
            }
            contentStream.setFont(font, fontSize.floatValue());
        }
        return flag;
    }

    protected boolean processDouble(PDPageContentStream contentStream, char character, char next, List<String> specialFontNames, PDFont font, Float fontSize) {
        boolean flag = true;
        if (Objects.nonNull(specialFontNames)) {
            String joinStr = String.valueOf(new char[]{character, next});
            for (String specialFontName : specialFontNames) {
                try {
                    contentStream.setFont(this.getContext().getFont(specialFontName), fontSize.floatValue());
                    contentStream.showText(joinStr);
                    flag = false;
                    break;
                }
                catch (Exception exception) {
                }
            }
            contentStream.setFont(font, fontSize.floatValue());
        }
        return flag;
    }
}

