/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.handler.tokenizer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.component.TextLineInfo;
import org.dromara.pdf.pdfbox.core.ext.handler.tokenizer.AbstractTokenizer;

public class WordsTokenizer
extends AbstractTokenizer {
    @Override
    public TextLineInfo splitText(FontConfiguration fontConfiguration, String text, float lineWidth) {
        if (Objects.isNull(text) || text.isEmpty()) {
            return null;
        }
        String[] words = text.split(" ");
        if (this.getTextWidth(fontConfiguration, words[0]) > lineWidth) {
            return null;
        }
        float width = 0.0f;
        float lastWidth = 0.0f;
        StringJoiner joiner = new StringJoiner(" ");
        for (String word : words) {
            joiner.add(word);
            String temp = joiner.toString();
            width = this.getTextWidth(fontConfiguration, temp);
            if (width > lineWidth) {
                return new TextLineInfo(temp.substring(0, temp.length() - word.length() - 1), Float.valueOf(lastWidth));
            }
            lastWidth = width;
        }
        return new TextLineInfo(text, Float.valueOf(width));
    }

    @Override
    public List<TextLineInfo> splitLines(FontConfiguration fontConfiguration, String text, float lineWidth) {
        if (Objects.isNull(text) || text.isEmpty()) {
            return new ArrayList<TextLineInfo>();
        }
        String[] words = text.trim().split(" ");
        if (this.getTextWidth(fontConfiguration, words[0]) > lineWidth) {
            return new ArrayList<TextLineInfo>();
        }
        LinkedList<TextLineInfo> lineList = new LinkedList<TextLineInfo>();
        float lastWidth = 0.0f;
        float width = 0.0f;
        StringJoiner joiner = new StringJoiner(" ");
        for (int beginIndex = 0; beginIndex < words.length; ++beginIndex) {
            joiner.add(words[beginIndex]);
            width = this.getTextWidth(fontConfiguration, joiner.toString());
            if (width > lineWidth) {
                String temp = joiner.toString();
                lineList.add(new TextLineInfo(temp.substring(0, temp.length() - words[beginIndex].length() - 1), Float.valueOf(lastWidth)));
                --beginIndex;
                joiner = new StringJoiner(" ");
                continue;
            }
            lastWidth = width;
        }
        if (joiner.length() > 1) {
            lineList.add(new TextLineInfo(joiner.toString(), Float.valueOf(width)));
        }
        return lineList;
    }
}

