/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.MemoryPolicy;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.support.Constants;
import org.dromara.pdf.pdfbox.util.IdUtil;

public class MergeProcessor
extends AbstractProcessor {
    public MergeProcessor(Document document) {
        super(document);
    }

    public void merge(List<Document> documents) {
        this.merge(documents.toArray(new Document[0]));
    }

    public void merge(Document ... documents) {
        Objects.requireNonNull(documents, "the documents can not be null");
        for (Document document : documents) {
            this.importPage(this.getDocument(), document.getTarget());
        }
    }

    public void merge(File ... files) {
        Objects.requireNonNull(files, "the documents can not be null");
        File temp = new File(Constants.TEMP_FILE_PATH, IdUtil.get() + ".pdf");
        ArrayList<Document> tempDocuments = new ArrayList<Document>(files.length);
        for (File file : files) {
            Document document = PdfHandler.getDocumentHandler().load(file, MemoryPolicy.setupTempFileOnly());
            PDPageTree pageTree = document.getTarget().getPages();
            for (PDPage sourcePage : pageTree) {
                PDPage importPage = this.getDocument().importPage(sourcePage);
                importPage.setResources(sourcePage.getResources());
            }
            tempDocuments.add(document);
        }
        this.getDocument().save(temp);
        this.document.close();
        this.document = PdfHandler.getDocumentHandler().load(temp, MemoryPolicy.setupTempFileOnly());
        tempDocuments.forEach(Document::close);
        temp.deleteOnExit();
    }

    public Document flush() {
        return this.document;
    }

    protected void importPage(PDDocument target, PDDocument source) {
        PDPageTree pageTree = source.getPages();
        for (PDPage sourcePage : pageTree) {
            PDPage importPage = target.importPage(sourcePage);
            importPage.setResources(sourcePage.getResources());
            this.document.getPages().add(new Page(this.document, importPage));
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeProcessor)) {
            return false;
        }
        MergeProcessor other = (MergeProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MergeProcessor;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

