/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PageSize;
import org.dromara.pdf.pdfbox.core.enums.PageJoinType;
import org.dromara.pdf.pdfbox.core.enums.RotationAngle;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.util.IdUtil;

public class PageProcessor
extends AbstractProcessor {
    public PageProcessor(Document document) {
        super(document);
    }

    public List<Page> getPages() {
        return this.document.getPages();
    }

    public void insert(int index, Page page) {
        Objects.requireNonNull(page, "the page can not be null");
        try {
            this.document.getPages().add(index, page);
            while (true) {
                ++index;
                if (!Objects.isNull(page = page.getSubPage())) {
                    this.document.getPages().add(index, page);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
        }
    }

    public void append(Page page) {
        Objects.requireNonNull(page, "the page can not be null");
        this.document.getPages().add(page);
        while (!Objects.isNull(page = page.getSubPage())) {
            this.document.getPages().add(page);
        }
    }

    public void set(int index, Page page) {
        Objects.requireNonNull(page, "the page can not be null");
        try {
            this.document.getPages().set(index, page);
            while (true) {
                ++index;
                if (!Objects.isNull(page = page.getSubPage())) {
                    this.document.getPages().add(index, page);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
        }
    }

    public void remove(int ... indexes) {
        Objects.requireNonNull(indexes, "the indexes can not be null");
        ArrayList<Page> temp = new ArrayList<Page>(this.document.getPages());
        for (int index : indexes) {
            try {
                this.document.getPages().remove(temp.get(index));
            }
            catch (Exception e) {
                this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
            }
        }
    }

    public void join(PageJoinType type, Page newPage, Page ... pages) {
        Objects.requireNonNull(type, "the type can not be null");
        Objects.requireNonNull(type, "the new page can not be null");
        Objects.requireNonNull(pages, "the pages can not be null");
        this.join(type, (Float)null, (Float)null, newPage, pages);
    }

    public void join(PageJoinType type, Float beginX, Float beginY, Page newPage, Page ... pages) {
        float x = Optional.ofNullable(beginX).orElse(Float.valueOf(0.0f)).floatValue();
        float y = Optional.ofNullable(beginY).orElse(newPage.getHeight()).floatValue();
        for (Page page : pages) {
            if (type == PageJoinType.VERTICAL) {
                y -= page.getHeight().floatValue();
            }
            LayerUtility layer = new LayerUtility(this.document.getTarget());
            PDFormXObject form = layer.importPageAsForm(page.getContext().getTargetDocument(), page.getTarget());
            layer.appendFormAsLayer(newPage.getTarget(), form, AffineTransform.getTranslateInstance(x, y), IdUtil.get());
            if (type != PageJoinType.HORIZONTAL) continue;
            x += page.getWidth().floatValue();
        }
        if (!this.document.getPages().contains(newPage)) {
            this.document.getPages().add(newPage);
        }
    }

    public void restructure(int ... indexes) {
        Objects.requireNonNull(indexes, "the indexes can not be null");
        List<Page> pages = this.document.getPages();
        ArrayList<Page> newPages = new ArrayList<Page>(indexes.length);
        for (int index : indexes) {
            try {
                newPages.add(pages.get(index));
            }
            catch (Exception e) {
                this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
            }
        }
        this.document.setPages(newPages);
    }

    public void resort(int ... indexes) {
        Objects.requireNonNull(indexes, "the indexes can not be null");
        List<Page> pages = this.document.getPages();
        ArrayList<Page> orderPages = new ArrayList<Page>(pages.size());
        for (int index : indexes) {
            try {
                orderPages.add(pages.remove(index));
            }
            catch (Exception e) {
                this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
            }
        }
        orderPages.addAll(pages);
        this.document.setPages(orderPages);
    }

    public void rotation(RotationAngle angle, int ... pageIndexes) {
        Objects.requireNonNull(angle, "the rotation angle can not be null");
        List<Page> pages = this.getPages();
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int index : pageIndexes) {
                try {
                    pages.get(index).rotation(angle);
                }
                catch (Exception e) {
                    this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
                }
            }
        } else {
            for (Page page : pages) {
                page.rotation(angle);
            }
        }
    }

    public void scale(PageSize rectangle, int ... pageIndexes) {
        Objects.requireNonNull(rectangle, "the rectangle can not be null");
        List<Page> pages = this.document.getPages();
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int index : pageIndexes) {
                try {
                    pages.get(index).scale(rectangle);
                }
                catch (Exception e) {
                    this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
                }
            }
        } else {
            for (Page page : pages) {
                page.scale(rectangle);
            }
        }
    }

    public void crop(PageSize rectangle, int ... pageIndexes) {
        Objects.requireNonNull(rectangle, "the rectangle can not be null");
        List<Page> pages = this.document.getPages();
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int index : pageIndexes) {
                try {
                    pages.get(index).crop(rectangle);
                }
                catch (Exception e) {
                    this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
                }
            }
        } else {
            for (Page page : pages) {
                page.crop(rectangle);
            }
        }
    }

    public void resetSize() {
        this.document.getPages().forEach(Page::resetRectangle);
    }

    public void flush() {
        for (int i = 0; i < this.document.getPages().size(); ++i) {
            this.document.getPages().get(i).setIndex(i);
        }
        PDPageTree pageTree = this.getDocument().getPages();
        pageTree.forEach(arg_0 -> ((PDPageTree)pageTree).remove(arg_0));
        this.document.getPages().forEach(page -> this.getDocument().addPage(page.getTarget()));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageProcessor)) {
            return false;
        }
        PageProcessor other = (PageProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageProcessor;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

