/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.form;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.Size;
import org.dromara.pdf.pdfbox.core.enums.FormFieldStateStyle;
import org.dromara.pdf.pdfbox.core.ext.processor.form.AbstractFormFieldBuilder;

public class CheckBoxFieldBuilder
extends AbstractFormFieldBuilder {
    protected FormFieldStateStyle style;
    protected String value;
    protected Boolean isSelected;

    private CheckBoxFieldBuilder(Document document, Page page, Size size) {
        super(document, page, size);
    }

    public static CheckBoxFieldBuilder builder(Document document, Page page, Size size) {
        return new CheckBoxFieldBuilder(document, page, size);
    }

    @Override
    public PDField build(PDAcroForm form) {
        PDCheckBox field = new PDCheckBox(form);
        this.initProperties(field);
        this.initSize((PDField)field);
        this.initWidget(field);
        return field;
    }

    protected void initProperties(PDCheckBox field) {
        Objects.requireNonNull(this.name, "the value can not be null");
        super.initProperties((PDField)field);
        field.getCOSObject().setItem(COSName.OPT, (COSBase)new COSArray(Collections.singletonList(new COSString(this.value))));
    }

    protected void initWidget(PDCheckBox field) {
        PDAnnotationWidget widget = (PDAnnotationWidget)field.getWidgets().get(0);
        this.initAppearance(widget);
        this.initBorder(widget);
    }

    protected void initAppearance(PDAnnotationWidget widget) {
        PDAppearanceCharacteristicsDictionary appearance = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
        COSDictionary dictionary = appearance.getCOSObject();
        dictionary.setItem(COSName.CA, (COSBase)this.style.getType());
        widget.setAppearanceCharacteristics(appearance);
        widget.setAppearanceState(Optional.ofNullable(this.isSelected).filter(v -> v).map(v -> "0").orElse(COSName.Off.getName()));
    }

    protected void initBorder(PDAnnotationWidget widget) {
        PDBorderStyleDictionary borderStyle = new PDBorderStyleDictionary(new COSDictionary());
        borderStyle.setWidth(1.0f);
        borderStyle.setStyle("I");
        widget.setBorderStyle(borderStyle);
    }

    @Generated
    public void setStyle(FormFieldStateStyle style) {
        this.style = style;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckBoxFieldBuilder)) {
            return false;
        }
        CheckBoxFieldBuilder other = (CheckBoxFieldBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isSelected = this.isSelected;
        Boolean other$isSelected = other.isSelected;
        if (this$isSelected == null ? other$isSelected != null : !((Object)this$isSelected).equals(other$isSelected)) {
            return false;
        }
        FormFieldStateStyle this$style = this.style;
        FormFieldStateStyle other$style = other.style;
        if (this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CheckBoxFieldBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isSelected = this.isSelected;
        result = result * 59 + ($isSelected == null ? 43 : ((Object)$isSelected).hashCode());
        FormFieldStateStyle $style = this.style;
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

