/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.form;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.dromara.pdf.pdfbox.core.base.Size;
import org.dromara.pdf.pdfbox.core.enums.FormFieldStateStyle;

public class RadioField {
    protected FormFieldStateStyle style;
    protected Size size;
    protected String value;
    protected Boolean isSelected;

    public RadioField(Size size, String value) {
        this(null, size, value, false);
    }

    public RadioField(Size size, String value, boolean isSelected) {
        this(null, size, value, isSelected);
    }

    public RadioField(FormFieldStateStyle style, Size size, String value) {
        this(style, size, value, false);
    }

    public RadioField(FormFieldStateStyle style, Size size, String value, boolean isSelected) {
        Objects.requireNonNull(size, "the size can not be null");
        this.style = Optional.ofNullable(style).orElse(FormFieldStateStyle.HOOK);
        this.size = size;
        this.value = value;
        this.isSelected = isSelected;
    }

    @Generated
    public FormFieldStateStyle getStyle() {
        return this.style;
    }

    @Generated
    public Size getSize() {
        return this.size;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Boolean getIsSelected() {
        return this.isSelected;
    }

    @Generated
    public void setStyle(FormFieldStateStyle style) {
        this.style = style;
    }

    @Generated
    public void setSize(Size size) {
        this.size = size;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RadioField)) {
            return false;
        }
        RadioField other = (RadioField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isSelected = this.getIsSelected();
        Boolean other$isSelected = other.getIsSelected();
        if (this$isSelected == null ? other$isSelected != null : !((Object)this$isSelected).equals(other$isSelected)) {
            return false;
        }
        FormFieldStateStyle this$style = this.getStyle();
        FormFieldStateStyle other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style)) {
            return false;
        }
        Size this$size = this.getSize();
        Size other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RadioField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isSelected = this.getIsSelected();
        result = result * 59 + ($isSelected == null ? 43 : ((Object)$isSelected).hashCode());
        FormFieldStateStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        Size $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RadioField(style=" + (Object)((Object)this.getStyle()) + ", size=" + this.getSize() + ", value=" + this.getValue() + ", isSelected=" + this.getIsSelected() + ")";
    }
}

