/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.templater;

import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.PageSize;
import org.dromara.pdf.pdfbox.core.ext.convertor.html.HtmlConvertor;
import org.dromara.pdf.pdfbox.core.ext.templater.AbstractTemplater;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.support.Constants;
import org.dromara.pdf.pdfbox.util.IdUtil;

public abstract class AbstractHtmlTemplater
extends AbstractTemplater {
    protected final HtmlConvertor convertor = PdfHandler.getDocumentConvertor().getHtmlConvertor();
    protected String templatePath;
    protected String templateName;
    protected Map<String, Object> templateData;
    protected Integer dpi;
    protected PageSize pageSize;
    protected Float marginTop;
    protected Float marginBottom;
    protected Float marginLeft;
    protected Float marginRight;
    protected Float scale;
    protected Boolean isLandscape;
    protected Boolean isIncludeBackground;

    public AbstractHtmlTemplater(Document document) {
        super(document);
    }

    protected abstract void process(Writer var1);

    public void setMargin(float margin) {
        this.marginTop = Float.valueOf(margin);
        this.marginBottom = Float.valueOf(margin);
        this.marginLeft = Float.valueOf(margin);
        this.marginRight = Float.valueOf(margin);
    }

    public String getHtmlContent() {
        String string;
        Path path = this.processTemplate(this::process);
        try {
            string = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            Files.deleteIfExists(path);
            throw throwable;
        }
        Files.deleteIfExists(path);
        return string;
    }

    public Document transform() {
        Document document;
        this.initConvertor();
        Path path = this.processTemplate(this::process);
        try {
            document = this.convertor.toPdf(path.toAbsolutePath().toString());
        }
        catch (Throwable throwable) {
            Files.deleteIfExists(path);
            throw throwable;
        }
        Files.deleteIfExists(path);
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Path processTemplate(Consumer<Writer> consumer) {
        Objects.requireNonNull(this.templatePath, "the template path can not be null");
        Objects.requireNonNull(this.templateName, "the template name can not be null");
        Path path = new File(Constants.TEMP_FILE_PATH, IdUtil.get() + ".html").toPath();
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            consumer.accept(writer);
            Path path2 = path;
            return path2;
        }
    }

    protected void initConvertor() {
        this.convertor.setDpi(this.dpi);
        this.convertor.setPageSize(this.pageSize);
        this.convertor.setMarginTop(this.marginTop);
        this.convertor.setMarginBottom(this.marginBottom);
        this.convertor.setMarginLeft(this.marginLeft);
        this.convertor.setMarginRight(this.marginRight);
        this.convertor.setScale(this.scale);
        this.convertor.setIsLandscape(this.isLandscape);
        this.convertor.setIsIncludeBackground(this.isIncludeBackground);
    }

    @Generated
    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    @Generated
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Generated
    public void setTemplateData(Map<String, Object> templateData) {
        this.templateData = templateData;
    }

    @Generated
    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    @Generated
    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
    }

    @Generated
    public void setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
    }

    @Generated
    public void setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
    }

    @Generated
    public void setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
    }

    @Generated
    public void setScale(Float scale) {
        this.scale = scale;
    }

    @Generated
    public void setIsLandscape(Boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    @Generated
    public void setIsIncludeBackground(Boolean isIncludeBackground) {
        this.isIncludeBackground = isIncludeBackground;
    }
}

