/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.templater;

import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.pdfbox.io.IOUtils;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.templater.AbstractHtmlTemplater;

public class BeetlTemplater
extends AbstractHtmlTemplater {
    protected static final GroupTemplate ENGINE = BeetlTemplater.initEngine(new StringTemplateResourceLoader());

    public BeetlTemplater(Document document) {
        super(document);
    }

    protected static GroupTemplate initEngine(ResourceLoader<?> loader) {
        return new GroupTemplate(loader, Configuration.defaultConfiguration());
    }

    @Override
    protected void process(Writer writer) {
        byte[] bytes;
        String templatePath = String.join((CharSequence)"/", this.templatePath, this.templateName);
        URL url = Thread.currentThread().getContextClassLoader().getResource(templatePath);
        if (Objects.isNull(url)) {
            bytes = Files.readAllBytes(Paths.get(templatePath, new String[0]));
        } else {
            try (InputStream inputStream = url.openStream();){
                bytes = IOUtils.toByteArray((InputStream)inputStream);
            }
        }
        Template template = ENGINE.getTemplate((Object)new String(bytes, StandardCharsets.UTF_8));
        template.binding(this.templateData);
        template.renderTo(writer);
    }
}

