/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.templater;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.templater.AbstractHtmlTemplater;

public class FreemarkerTemplater
extends AbstractHtmlTemplater {
    protected static final Map<String, Configuration> CONFIGURATION = new ConcurrentHashMap<String, Configuration>(16);

    public FreemarkerTemplater(Document document) {
        super(document);
    }

    @Override
    public void setTemplatePath(String templatePath) {
        super.setTemplatePath(templatePath);
        CONFIGURATION.computeIfAbsent(templatePath, this::initConfiguration);
    }

    @Override
    protected void process(Writer writer) {
        Configuration configuration = CONFIGURATION.get(this.templatePath);
        configuration.getTemplate(this.templateName, StandardCharsets.UTF_8.name()).process((Object)this.templateData, writer);
    }

    protected Configuration initConfiguration(String templatePath) {
        Configuration config = new Configuration(Configuration.VERSION_2_3_34);
        config.setDefaultEncoding(StandardCharsets.UTF_8.name());
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setLogTemplateExceptions(false);
        config.setWrapUncheckedExceptions(true);
        config.setFallbackOnNullLoopVariable(false);
        if (Thread.currentThread().getContextClassLoader().getResource(templatePath) == null) {
            try {
                config.setDirectoryForTemplateLoading(Paths.get(templatePath, new String[0]).toFile());
            }
            catch (Exception e) {
                config.setTemplateLoader((TemplateLoader)new DefaultURLTemplateLoader(templatePath));
            }
        } else {
            config.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(FreemarkerTemplater.class, File.separator + templatePath));
        }
        return config;
    }

    public static class DefaultURLTemplateLoader
    extends URLTemplateLoader {
        private final String remotePath;
        private String templateName;

        public DefaultURLTemplateLoader(String remotePath) {
            this.remotePath = remotePath;
        }

        protected URL getURL(String name) {
            URL url;
            if (!Objects.equals(this.templateName, name)) {
                return null;
            }
            String fullPath = this.remotePath + name;
            if (this.remotePath.equals("/") && this.isInvalid(fullPath)) {
                return null;
            }
            try {
                url = new URL(fullPath);
            }
            catch (MalformedURLException e) {
                url = null;
            }
            return url;
        }

        private boolean isInvalid(String fullPath) {
            int i = 0;
            int ln = fullPath.length();
            if (i < ln && fullPath.charAt(i) == '/') {
                ++i;
            }
            while (i < ln) {
                char c = fullPath.charAt(i);
                if (c == '/') {
                    return false;
                }
                if (c == ':') {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Generated
        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }
    }
}

