/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.templater;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.WriterOutput;
import gg.jte.resolve.DirectoryCodeResolver;
import gg.jte.resolve.ResourceCodeResolver;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.templater.AbstractHtmlTemplater;

public class JteTemplater
extends AbstractHtmlTemplater {
    protected static final Map<String, TemplateEngine> ENGINE_CACHE = new ConcurrentHashMap<String, TemplateEngine>(16);

    public JteTemplater(Document document) {
        super(document);
    }

    @Override
    protected void process(Writer writer) {
        String template = String.join((CharSequence)"/", this.templatePath, this.templateName);
        WriterOutput output = new WriterOutput(writer);
        TemplateEngine engine = this.getEngine(template);
        if (Thread.currentThread().getContextClassLoader().getResource(template) == null) {
            engine.render(this.templateName, this.templateData, (TemplateOutput)output);
        } else {
            engine.render(template, this.templateData, (TemplateOutput)output);
        }
    }

    protected TemplateEngine getEngine(String template) {
        return ENGINE_CACHE.computeIfAbsent(template, this::initEngine);
    }

    protected TemplateEngine initEngine(String template) {
        Object resolver = Thread.currentThread().getContextClassLoader().getResource(template) == null ? new DirectoryCodeResolver(Paths.get(template, new String[0]).getParent()) : new ResourceCodeResolver(".", Thread.currentThread().getContextClassLoader());
        return TemplateEngine.create((CodeResolver)resolver, (ContentType)ContentType.Html);
    }
}

